/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.net.ntp.TimeStamp;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogObjectCache;
import org.apache.impala.catalog.CatalogObjectVersionSet;
import org.apache.impala.catalog.Principal;
import org.apache.impala.catalog.PrincipalPrivilege;
import org.apache.impala.catalog.Role;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.User;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TPrincipal;
import org.apache.impala.thrift.TPrincipalType;
import org.apache.impala.thrift.TPrivilege;
import org.apache.impala.thrift.TResultRow;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.util.TResultRowBuilder;
import org.apache.log4j.Logger;

public class AuthorizationPolicy {
    private static final Logger LOG = Logger.getLogger(AuthorizationPolicy.class);
    private final CatalogObjectCache<Role> roleCache_ = new CatalogObjectCache();
    private final CatalogObjectCache<User> userCache_ = new CatalogObjectCache(false);
    private final Map<Integer, String> principalIds_ = new HashMap<Integer, String>();
    Map<String, Set<String>> groupsToRoles_ = new HashMap<String, Set<String>>();

    public synchronized void addPrincipal(Principal principal) {
        Principal existingPrincipal = this.getPrincipal(principal.getName(), principal.getPrincipalType());
        if (existingPrincipal != null && existingPrincipal.getCatalogVersion() >= principal.getCatalogVersion()) {
            return;
        }
        if (existingPrincipal != null) {
            this.removePrincipal(existingPrincipal.getName(), existingPrincipal.getPrincipalType());
            CatalogObjectVersionSet.INSTANCE.removeAll(existingPrincipal.getPrivileges());
            if (existingPrincipal.getId() == principal.getId()) {
                for (PrincipalPrivilege p : existingPrincipal.getPrivileges()) {
                    principal.addPrivilege(p);
                }
            }
        }
        if (principal.getPrincipalType() == TPrincipalType.USER) {
            Preconditions.checkArgument((boolean)(principal instanceof User));
            this.userCache_.add((User)principal);
        } else {
            Preconditions.checkArgument((boolean)(principal instanceof Role));
            this.roleCache_.add((Role)principal);
        }
        for (String groupName : principal.getGrantGroups()) {
            Set<String> grantedRoles = this.groupsToRoles_.get(groupName);
            if (grantedRoles == null) {
                grantedRoles = new HashSet<String>();
                this.groupsToRoles_.put(groupName, grantedRoles);
            }
            grantedRoles.add(principal.getName().toLowerCase());
        }
        this.principalIds_.put(principal.getId(), principal.getName());
    }

    public synchronized void addPrivilege(PrincipalPrivilege privilege) throws CatalogException {
        Principal principal;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Adding privilege: " + privilege.getName() + " " + Principal.toString(privilege.getPrincipalType()).toLowerCase() + " ID: " + privilege.getPrincipalId()));
        }
        if ((principal = this.getPrincipal(privilege.getPrincipalId(), privilege.getPrincipalType())) == null) {
            throw new CatalogException(String.format("Error adding privilege: %s. %s ID '%d' does not exist.", privilege.getName(), Principal.toString(privilege.getPrincipalType()), privilege.getPrincipalId()));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Adding privilege: " + privilege.getName() + " to " + Principal.toString(privilege.getPrincipalType()).toLowerCase() + ": " + principal.getName() + " with ID: " + principal.getId()));
        }
        principal.addPrivilege(privilege);
    }

    public synchronized List<Role> getAllRoles() {
        return this.roleCache_.getValues();
    }

    public synchronized List<User> getAllUsers() {
        return this.userCache_.getValues();
    }

    public synchronized Set<String> getAllRoleNames() {
        return Sets.newHashSet(this.roleCache_.keySet());
    }

    public synchronized Role getRole(String roleName) {
        return this.roleCache_.get(roleName);
    }

    public synchronized Role getRole(int roleId) {
        String roleName = this.principalIds_.get(roleId);
        if (roleName == null) {
            return null;
        }
        return this.roleCache_.get(roleName);
    }

    public synchronized Set<String> getAllUserNames() {
        return Sets.newHashSet(this.userCache_.keySet());
    }

    public synchronized User getUser(String userName) {
        return this.userCache_.get(userName);
    }

    public synchronized User getUser(int userId) {
        String userName = this.principalIds_.get(userId);
        if (userName == null) {
            return null;
        }
        return this.userCache_.get(userName);
    }

    public synchronized Principal getPrincipal(String principalName, TPrincipalType type) {
        return type == TPrincipalType.ROLE ? (Principal)this.roleCache_.get(principalName) : (Principal)this.userCache_.get(principalName);
    }

    public synchronized Principal getPrincipal(int principalId, TPrincipalType type) {
        String principalName = this.principalIds_.get(principalId);
        if (principalName == null) {
            return null;
        }
        return this.getPrincipal(principalName, type);
    }

    public synchronized List<Role> getGrantedRoles(String groupName) {
        ArrayList<Role> grantedRoles = new ArrayList<Role>();
        Set<String> roleNames = this.groupsToRoles_.get(groupName);
        if (roleNames != null) {
            for (String roleName : roleNames) {
                Principal role = this.roleCache_.get(roleName);
                if (role == null) continue;
                grantedRoles.add(this.roleCache_.get(roleName));
            }
        }
        return grantedRoles;
    }

    public synchronized Principal removePrincipal(String principalName, TPrincipalType type) {
        return type == TPrincipalType.ROLE ? this.removeRole(principalName) : this.removeUser(principalName);
    }

    public synchronized void removePrincipalIfLowerVersion(TPrincipal thriftPrincipal, long dropCatalogVersion) {
        Principal existingPrincipal = this.getPrincipal(thriftPrincipal.getPrincipal_name(), thriftPrincipal.getPrincipal_type());
        if (existingPrincipal == null || existingPrincipal.getCatalogVersion() >= dropCatalogVersion) {
            return;
        }
        this.removePrincipal(thriftPrincipal.getPrincipal_name(), thriftPrincipal.getPrincipal_type());
        CatalogObjectVersionSet.INSTANCE.removeAll(existingPrincipal.getPrivileges());
    }

    public synchronized void removePrivilegeIfLowerVersion(TPrivilege thriftPrivilege, long dropCatalogVersion) {
        Principal principal = this.getPrincipal(thriftPrivilege.getPrincipal_id(), thriftPrivilege.getPrincipal_type());
        if (principal == null) {
            return;
        }
        String privilegeName = PrincipalPrivilege.buildPrivilegeName(thriftPrivilege);
        PrincipalPrivilege existingPrivilege = principal.getPrivilege(privilegeName);
        if (existingPrivilege != null && existingPrivilege.getCatalogVersion() < dropCatalogVersion) {
            principal.removePrivilege(privilegeName);
        }
    }

    public synchronized Role removeRole(String roleName) {
        Role removedRole = this.roleCache_.remove(roleName);
        if (removedRole == null) {
            return null;
        }
        for (String grantGroup : removedRole.getGrantGroups()) {
            Set<String> roles = this.groupsToRoles_.get(grantGroup);
            if (roles == null) continue;
            roles.remove(roleName.toLowerCase());
        }
        this.principalIds_.remove(removedRole.getId());
        return removedRole;
    }

    public synchronized User removeUser(String userName) {
        User removedUser = this.userCache_.remove(userName);
        if (removedUser == null) {
            return null;
        }
        this.principalIds_.remove(removedUser.getId());
        return removedUser;
    }

    public synchronized Role addRoleGrantGroup(String roleName, String groupName) throws CatalogException {
        Role role = this.roleCache_.get(roleName);
        if (role == null) {
            throw new CatalogException("Role does not exist: " + roleName);
        }
        role.addGrantGroup(groupName);
        Set<String> grantedRoles = this.groupsToRoles_.get(groupName);
        if (grantedRoles == null) {
            grantedRoles = new HashSet<String>();
            this.groupsToRoles_.put(groupName, grantedRoles);
        }
        grantedRoles.add(roleName.toLowerCase());
        return role;
    }

    public synchronized Role removeRoleGrantGroup(String roleName, String groupName) throws CatalogException {
        Role role = this.roleCache_.get(roleName);
        if (role == null) {
            throw new CatalogException("Role does not exist: " + roleName);
        }
        role.removeGrantGroup(groupName);
        Set<String> grantedRoles = this.groupsToRoles_.get(groupName);
        if (grantedRoles != null) {
            grantedRoles.remove(roleName.toLowerCase());
        }
        return role;
    }

    public synchronized TResultSet getRolePrivileges(String principalName, TPrivilege filter) {
        TResultSet result = new TResultSet();
        result.setSchema(new TResultSetMetadata());
        this.addColumnOutputColumns(result.getSchema());
        result.setRows(new ArrayList<TResultRow>());
        Role role = this.getRole(principalName);
        if (role != null) {
            for (PrincipalPrivilege p : role.getPrivileges()) {
                TPrivilege privilege = p.toThrift();
                if (filter != null && this.isPrivilegeFiltered(filter, privilege)) continue;
                TResultRowBuilder rowBuilder = new TResultRowBuilder();
                result.addToRows(this.addShowPrincipalOutputResults(privilege, rowBuilder).get());
            }
        }
        return result;
    }

    private boolean isPrivilegeFiltered(TPrivilege filter, TPrivilege privilege) {
        filter.setPrivilege_level(privilege.getPrivilege_level());
        filter.setHas_grant_opt(privilege.isHas_grant_opt());
        String privName = PrincipalPrivilege.buildPrivilegeName(filter);
        return !privName.equalsIgnoreCase(PrincipalPrivilege.buildPrivilegeName(privilege));
    }

    private void addColumnOutputColumns(TResultSetMetadata schema) {
        schema.addToColumns(new TColumn("scope", Type.STRING.toThrift()));
        schema.addToColumns(new TColumn("database", Type.STRING.toThrift()));
        schema.addToColumns(new TColumn("table", Type.STRING.toThrift()));
        schema.addToColumns(new TColumn("column", Type.STRING.toThrift()));
        schema.addToColumns(new TColumn("uri", Type.STRING.toThrift()));
        schema.addToColumns(new TColumn("privilege", Type.STRING.toThrift()));
        schema.addToColumns(new TColumn("grant_option", Type.BOOLEAN.toThrift()));
        schema.addToColumns(new TColumn("create_time", Type.STRING.toThrift()));
    }

    private TResultRowBuilder addShowPrincipalOutputResults(TPrivilege privilege, TResultRowBuilder rowBuilder) {
        rowBuilder.add(privilege.getScope().toString().toLowerCase());
        rowBuilder.add(Strings.nullToEmpty((String)privilege.getDb_name()).toLowerCase());
        rowBuilder.add(Strings.nullToEmpty((String)privilege.getTable_name()).toLowerCase());
        rowBuilder.add(Strings.nullToEmpty((String)privilege.getColumn_name()).toLowerCase());
        rowBuilder.add(Strings.nullToEmpty((String)privilege.getUri()));
        rowBuilder.add(privilege.getPrivilege_level().toString().toLowerCase());
        rowBuilder.add(privilege.isHas_grant_opt());
        if (privilege.getCreate_time_ms() == -1L) {
            rowBuilder.add(null);
        } else {
            rowBuilder.add(TimeStamp.getNtpTime((long)privilege.getCreate_time_ms()).toDateString());
        }
        return rowBuilder;
    }

    public synchronized TResultSet getUserPrivileges(String principalName, Set<String> groupNames, TPrivilege filter) throws AnalysisException {
        TResultSet result = new TResultSet();
        result.setSchema(new TResultSetMetadata());
        result.getSchema().addToColumns(new TColumn("principal_type", Type.STRING.toThrift()));
        result.getSchema().addToColumns(new TColumn("principal_name", Type.STRING.toThrift()));
        this.addColumnOutputColumns(result.getSchema());
        result.setRows(new ArrayList<TResultRow>());
        if (groupNames.isEmpty()) {
            throw new AnalysisException(String.format("User '%s' does not exist.", principalName));
        }
        User user = this.getUser(principalName);
        if (user != null) {
            this.createShowUserPrivilegesResultRows(result, user.getPrivileges(), filter, principalName, TPrincipalType.USER);
        }
        ArrayList<Role> roles = new ArrayList<Role>();
        for (String groupName : groupNames) {
            roles.addAll(this.getGrantedRoles(groupName));
        }
        for (Role role : roles) {
            Role rolePrincipal = this.getRole(role.getName());
            if (rolePrincipal == null) continue;
            this.createShowUserPrivilegesResultRows(result, rolePrincipal.getPrivileges(), filter, rolePrincipal.getName(), TPrincipalType.ROLE);
        }
        return result;
    }

    private void createShowUserPrivilegesResultRows(TResultSet result, List<PrincipalPrivilege> privileges, TPrivilege filter, String name, TPrincipalType type) {
        for (PrincipalPrivilege p : privileges) {
            TPrivilege privilege = p.toThrift();
            if (filter != null && this.isPrivilegeFiltered(filter, privilege)) continue;
            TResultRowBuilder rowBuilder = new TResultRowBuilder();
            rowBuilder.add(Strings.nullToEmpty((String)type.name().toUpperCase()));
            rowBuilder.add(Strings.nullToEmpty((String)name));
            result.addToRows(this.addShowPrincipalOutputResults(privilege, rowBuilder).get());
        }
    }
}

