/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.impala.authorization.Authorizable;

public class AuthorizableTable
extends Authorizable {
    private final String dbName_;
    private final String tableName_;
    @Nullable
    private final String ownerUser_;
    private final List<String> columns_ = new ArrayList<String>();

    public AuthorizableTable(String dbName, String tableName, @Nullable String ownerUser) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dbName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0);
        this.dbName_ = dbName;
        this.tableName_ = tableName;
        this.ownerUser_ = ownerUser;
    }

    @Override
    public String getName() {
        return this.dbName_ + "." + this.tableName_;
    }

    @Override
    public Authorizable.Type getType() {
        return Authorizable.Type.TABLE;
    }

    @Override
    public String getDbName() {
        return this.dbName_;
    }

    @Override
    public String getTableName() {
        return this.tableName_;
    }

    @Override
    public String getFullTableName() {
        return this.getName();
    }

    @Override
    public String getOwnerUser() {
        return this.ownerUser_;
    }

    public void setColumns(List<String> columns) {
        this.columns_.clear();
        this.columns_.addAll(columns);
    }

    public List<String> getColumns() {
        return this.columns_;
    }
}

