/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authentication.saml;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.security.SecureRandom;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.impala.authentication.saml.HiveSamlRelayStateInfo;
import org.apache.impala.authentication.saml.HttpSamlAuthenticationException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.generator.ValueGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSamlRelayStateStore
implements ValueGenerator {
    private final Cache<String, HiveSamlRelayStateInfo> relayStateCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final Random randGenerator = new SecureRandom();
    private static final Logger LOG = LoggerFactory.getLogger(HiveSamlRelayStateStore.class);
    private static final HiveSamlRelayStateStore INSTANCE = new HiveSamlRelayStateStore();

    private HiveSamlRelayStateStore() {
    }

    public static HiveSamlRelayStateStore get() {
        return INSTANCE;
    }

    public String generateValue(WebContext webContext) {
        Optional portNumber = webContext.getRequestHeader("X-Hive-Token-Response-Port");
        if (!portNumber.isPresent()) {
            throw new RuntimeException("SAML response port header X-Hive-Token-Response-Port is not set ");
        }
        int port = Integer.parseInt((String)portNumber.get());
        String relayState = UUID.randomUUID().toString();
        HiveSamlRelayStateInfo relayStateInfo = new HiveSamlRelayStateInfo(port, UUID.randomUUID().toString());
        webContext.setResponseHeader("X-Hive-Client-Identifier", relayStateInfo.getClientIdentifier());
        this.relayStateCache.put((Object)relayState, (Object)relayStateInfo);
        return relayState;
    }

    public String getRelayStateInfo(WebContext webContext) throws HttpSamlAuthenticationException {
        Optional relayState = webContext.getRequestParameter("RelayState");
        if (relayState == null || !relayState.isPresent()) {
            throw new HttpSamlAuthenticationException("Could not get the RelayState from the SAML response");
        }
        return (String)relayState.get();
    }

    public HiveSamlRelayStateInfo getRelayStateInfo(String relayState) throws HttpSamlAuthenticationException {
        HiveSamlRelayStateInfo relayStateInfo = (HiveSamlRelayStateInfo)this.relayStateCache.getIfPresent((Object)relayState);
        if (relayStateInfo == null) {
            throw new HttpSamlAuthenticationException("Invalid value of relay state received: " + relayState);
        }
        return relayStateInfo;
    }

    public synchronized boolean validateClientIdentifier(String relayStateKey, String clientIdentifier) {
        HiveSamlRelayStateInfo relayStateInfo = (HiveSamlRelayStateInfo)this.relayStateCache.getIfPresent((Object)relayStateKey);
        if (relayStateInfo == null) {
            return false;
        }
        this.relayStateCache.invalidate((Object)relayStateKey);
        LOG.debug("Validating client identifier {} with {}", (Object)clientIdentifier, (Object)relayStateInfo.getClientIdentifier());
        return relayStateInfo.getClientIdentifier().equals(clientIdentifier);
    }
}

