/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.LimitElement;
import org.apache.impala.analysis.OrderByElement;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SelectList;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SetOperationStmt;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.UnionStmt;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.BetweenToCompoundRule;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.rewrite.ExtractCompoundVerticalBarExprRule;

public class ValuesStmt
extends UnionStmt {
    public ValuesStmt(List<SetOperationStmt.SetOperand> operands, List<OrderByElement> orderByElements, LimitElement limitElement) {
        super(operands, orderByElements, limitElement);
    }

    private ValuesStmt(ValuesStmt other) {
        super(other);
    }

    @Override
    protected String queryStmtToSql(QueryStmt queryStmt) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("(");
        this.appendSelectList((SelectStmt)queryStmt, strBuilder, ToSqlOptions.DEFAULT);
        strBuilder.append(")");
        return strBuilder.toString();
    }

    @Override
    public String toSql(ToSqlOptions options) {
        if (options.showRewritten()) {
            return super.toSql(options);
        }
        StringBuilder strBuilder = new StringBuilder();
        if (this.withClause_ != null) {
            strBuilder.append(this.withClause_.toSql(options));
            strBuilder.append(" ");
        }
        Preconditions.checkState((this.operands_.size() > 0 ? 1 : 0) != 0);
        strBuilder.append("VALUES(");
        for (int i = 0; i < this.operands_.size(); ++i) {
            if (this.operands_.size() != 1) {
                strBuilder.append("(");
            }
            this.appendSelectList((SelectStmt)((SetOperationStmt.SetOperand)this.operands_.get(i)).getQueryStmt(), strBuilder, options);
            if (this.operands_.size() != 1) {
                strBuilder.append(")");
            }
            strBuilder.append(i + 1 != this.operands_.size() ? ", " : "");
        }
        strBuilder.append(")");
        return strBuilder.toString();
    }

    private void appendSelectList(SelectStmt select, StringBuilder strBuilder, ToSqlOptions options) {
        SelectList selectList = select.getSelectList();
        for (int j = 0; j < selectList.getItems().size(); ++j) {
            strBuilder.append(selectList.getItems().get(j).toSql(options));
            strBuilder.append(j + 1 != selectList.getItems().size() ? ", " : "");
        }
    }

    @Override
    public ValuesStmt clone() {
        return new ValuesStmt(this);
    }

    @Override
    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        ExprRewriter mandatoryRewriter = new ExprRewriter(Arrays.asList(BetweenToCompoundRule.INSTANCE, ExtractCompoundVerticalBarExprRule.INSTANCE));
        super.rewriteExprs(mandatoryRewriter);
        rewriter.addNumChanges(mandatoryRewriter);
    }

    @Override
    protected boolean shouldAvoidLossyCharPadding(Analyzer analyzer) {
        return analyzer.getQueryCtx().client_request.query_options.values_stmt_avoid_lossy_char_padding;
    }
}

