/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CollectionTableRef;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;

public class UnnestExpr
extends SlotRef {
    private List<String> rawPathWithoutItem_ = new ArrayList<String>();

    public UnnestExpr(List<String> path) {
        super(path);
    }

    protected UnnestExpr(UnnestExpr other) {
        super(other);
        this.removeItemFromPath();
        this.rawPathWithoutItem_ = other.rawPathWithoutItem_;
    }

    protected UnnestExpr(SlotDescriptor desc) {
        super(desc);
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkNotNull((Object)this.rawPath_);
        Preconditions.checkState((this.rawPath_.size() >= 1 ? 1 : 0) != 0);
        this.verifyTableRefs(analyzer);
        Path resolvedPath = this.resolveAndVerifyRawPath(analyzer);
        Preconditions.checkNotNull((Object)resolvedPath);
        UnnestExpr.verifyNotInsideStruct(resolvedPath);
        Type type = resolvedPath.getMatchedTypes().get(resolvedPath.getMatchedTypes().size() - 1);
        UnnestExpr.verifyContainsNoStruct(type);
        if (!this.rawPathWithoutItem_.isEmpty()) {
            this.rawPathWithoutItem_.clear();
        }
        this.rawPathWithoutItem_.addAll(this.rawPath_);
        List<String> tableRefRawPath = this.constructRawPathForTableRef(resolvedPath);
        Preconditions.checkNotNull(tableRefRawPath);
        CollectionTableRef tblRef = this.createAndRegisterCollectionTableRef(tableRefRawPath, analyzer);
        this.rawPath_.add("item");
        if (this.rawPath_.size() > 2) {
            this.rawPath_ = this.rawPath_.subList(this.rawPath_.size() - 2, this.rawPath_.size());
        }
        super.analyzeImpl(analyzer);
        Preconditions.checkState((tblRef.desc_.getSlots().size() == 1 ? 1 : 0) != 0);
        analyzer.addZippingUnnestTupleId(this.desc_.getParent().getId());
    }

    public static void verifyNotInsideStruct(Path resolvedPath) throws AnalysisException {
        for (Type type : resolvedPath.getMatchedTypes()) {
            if (!type.isStructType()) continue;
            throw new AnalysisException("Zipping unnest on an array that is within a struct is not supported.");
        }
    }

    public static void verifyContainsNoStruct(Type type) throws AnalysisException {
        if (type.isStructType()) {
            throw new AnalysisException("Zipping unnest on an array that (recursively) contains a struct is not supported.");
        }
        if (type.isArrayType()) {
            ArrayType arrType = (ArrayType)type;
            UnnestExpr.verifyContainsNoStruct(arrType.getItemType());
        } else if (type.isMapType()) {
            MapType mapType = (MapType)type;
            UnnestExpr.verifyContainsNoStruct(mapType.getKeyType());
            UnnestExpr.verifyContainsNoStruct(mapType.getValueType());
        }
    }

    private void verifyTableRefs(Analyzer analyzer) throws AnalysisException {
        for (TableRef ref : analyzer.getTableRefs().values()) {
            if (!(ref instanceof CollectionTableRef)) continue;
            if (!ref.isZippingUnnest() && !ref.isCollectionInSelectList()) {
                throw new AnalysisException("Providing zipping and joining unnests together is not supported.");
            }
            if (ref.getZippingUnnestType() != TableRef.ZippingUnnestType.FROM_CLAUSE_ZIPPING_UNNEST) continue;
            throw new AnalysisException("Providing zipping unnest both in the SELECT list and in the FROM clause is not supported.");
        }
    }

    private Path resolveAndVerifyRawPath(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkNotNull((Object)this.rawPath_);
        if (this.resolvedPath_ != null) {
            this.removeItemFromPath();
        }
        Path resolvedPath = null;
        try {
            resolvedPath = analyzer.resolvePath(this.rawPath_, Path.PathType.SLOT_REF);
            if (resolvedPath == null) {
                throw new AnalysisException("Unable to resolve path: " + ToSqlUtils.getPathSql(this.rawPath_));
            }
        }
        catch (TableLoadingException e) {
            throw new AnalysisException(e.toString());
        }
        Preconditions.checkNotNull((Object)resolvedPath);
        Preconditions.checkState((!resolvedPath.getMatchedTypes().isEmpty() ? 1 : 0) != 0);
        Type resolvedType = resolvedPath.getMatchedTypes().get(resolvedPath.getMatchedTypes().size() - 1);
        if (!resolvedType.isArrayType()) {
            throw new AnalysisException("Unnest operator is only supported for arrays. " + ToSqlUtils.getPathSql(this.rawPath_));
        }
        return resolvedPath;
    }

    private List<String> constructRawPathForTableRef(Path resolvedPath) {
        ArrayList<String> tableRefRawPath = new ArrayList<String>();
        tableRefRawPath.add(resolvedPath.getRootDesc().getAlias());
        tableRefRawPath.add((String)this.rawPath_.get(this.rawPath_.size() - 1));
        return tableRefRawPath;
    }

    private CollectionTableRef createAndRegisterCollectionTableRef(List<String> tableRefRawPath, Analyzer analyzer) throws AnalysisException {
        String alias = "";
        if (this.rawPath_ != null && this.rawPath_.size() > 0) {
            alias = (String)this.rawPath_.get(this.rawPath_.size() - 1);
        }
        TableRef tblRef = new TableRef(tableRefRawPath, alias);
        tblRef = analyzer.resolveTableRef(tblRef);
        Preconditions.checkState((boolean)(tblRef instanceof CollectionTableRef));
        tblRef.setZippingUnnestType(TableRef.ZippingUnnestType.SELECT_LIST_ZIPPING_UNNEST);
        TableRef existingTblRef = analyzer.getRegisteredTableRef(tblRef.getUniqueAlias());
        if (existingTblRef == null) {
            tblRef.analyze(analyzer);
            analyzer.addTableRefFromUnnestExpr((CollectionTableRef)tblRef);
            return (CollectionTableRef)tblRef;
        }
        if (existingTblRef.isCollectionInSelectList() || existingTblRef.getZippingUnnestType() == TableRef.ZippingUnnestType.NONE) {
            Preconditions.checkState((boolean)(existingTblRef instanceof CollectionTableRef));
            existingTblRef.setZippingUnnestType(TableRef.ZippingUnnestType.SELECT_LIST_ZIPPING_UNNEST);
            analyzer.addTableRefFromUnnestExpr((CollectionTableRef)existingTblRef);
        }
        existingTblRef.setHidden(false);
        existingTblRef.getDesc().setHidden(false);
        return (CollectionTableRef)existingTblRef;
    }

    private void removeItemFromPath() {
        if (this.rawPath_ == null || this.rawPath_.isEmpty()) {
            return;
        }
        if (((String)this.rawPath_.get(this.rawPath_.size() - 1)).equals("item")) {
            this.rawPath_.remove(this.rawPath_.size() - 1);
        }
    }

    @Override
    public Expr clone() {
        return new UnnestExpr(this);
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        Preconditions.checkState((boolean)this.isAnalyzed());
        String label = "";
        if (this.rawPathWithoutItem_ != null) {
            label = ToSqlUtils.getPathSql(this.rawPathWithoutItem_);
        }
        if (label.equals("") && this.label_ != null && this.label_.endsWith(".item")) {
            label = this.label_.substring(0, this.label_.length() - 5);
        }
        return "UNNEST(" + label + ")";
    }

    @Override
    protected Expr substituteImpl(ExprSubstitutionMap smap, Analyzer analyzer) {
        if (smap == null) {
            return this;
        }
        SlotRef slotRef = new SlotRef(this.desc_);
        Expr substExpr = smap.get(slotRef);
        if (substExpr == null) {
            UnnestExpr unnestExpr = new UnnestExpr(this.desc_);
            substExpr = smap.get(unnestExpr);
            if (substExpr == null) {
                return this;
            }
            return substExpr;
        }
        return new UnnestExpr(((SlotRef)substExpr).getDesc());
    }

    @Override
    public boolean isBoundByTupleIds(List<TupleId> tids) {
        Preconditions.checkState((this.desc_ != null ? 1 : 0) != 0, (Object)"Null desc_ in UnnestExpr");
        Preconditions.checkState((this.desc_.getParent() != null ? 1 : 0) != 0, (Object)"Null parent in UnnestExpr");
        if (this.desc_.getParent().getRootDesc() != null) {
            TupleId parentId = this.desc_.getParent().getRootDesc().getId();
            for (TupleId tid : tids) {
                if (!tid.equals(parentId)) continue;
                return true;
            }
        }
        return super.isBoundByTupleIds(tids);
    }
}

