/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.compat.MetastoreShim;

public class TypeDef
extends StmtNode {
    private boolean isAnalyzed_;
    private final Type parsedType_;

    public TypeDef(Type parsedType) {
        this.parsedType_ = parsedType;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed_) {
            return;
        }
        if (this.parsedType_.exceedsMaxNestingDepth()) {
            throw new AnalysisException(String.format("Type exceeds the maximum nesting depth of %s:\n%s", Type.MAX_NESTING_DEPTH, this.parsedType_.toSql()));
        }
        this.analyze(this.parsedType_, analyzer);
        this.isAnalyzed_ = true;
    }

    private void analyze(Type type, Analyzer analyzer) throws AnalysisException {
        if (!type.isSupported()) {
            throw new AnalysisException("Unsupported data type: " + type.toSql());
        }
        if (type.isScalarType()) {
            this.analyzeScalarType((ScalarType)type, analyzer);
        } else if (type.isStructType()) {
            this.analyzeStructType((StructType)type, analyzer);
        } else if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            this.analyze(arrayType.getItemType(), analyzer);
        } else {
            Preconditions.checkState((boolean)type.isMapType());
            this.analyzeMapType((MapType)type, analyzer);
        }
    }

    private void analyzeScalarType(ScalarType scalarType, Analyzer analyzer) throws AnalysisException {
        PrimitiveType type = scalarType.getPrimitiveType();
        switch (type) {
            case CHAR: 
            case VARCHAR: {
                int maxLen;
                String name;
                if (type == PrimitiveType.VARCHAR) {
                    name = "Varchar";
                    maxLen = 65535;
                } else if (type == PrimitiveType.CHAR) {
                    name = "Char";
                    maxLen = 255;
                } else {
                    Preconditions.checkState((boolean)false);
                    return;
                }
                int len = scalarType.getLength();
                if (len <= 0) {
                    throw new AnalysisException(name + " size must be > 0: " + len);
                }
                if (scalarType.getLength() <= maxLen) break;
                throw new AnalysisException(name + " size must be <= " + maxLen + ": " + len);
            }
            case DECIMAL: {
                int precision = scalarType.decimalPrecision();
                int scale = scalarType.decimalScale();
                if (precision > 38) {
                    throw new AnalysisException("Decimal precision must be <= 38: " + precision);
                }
                if (precision == 0) {
                    throw new AnalysisException("Decimal precision must be > 0: " + precision);
                }
                if (scale <= precision) break;
                throw new AnalysisException("Decimal scale (" + scale + ") must be <= precision (" + precision + ")");
            }
        }
    }

    private void analyzeStructType(StructType structType, Analyzer analyzer) throws AnalysisException {
        HashSet<String> fieldNames = new HashSet<String>();
        for (StructField f : structType.getFields()) {
            this.analyze(f.getType(), analyzer);
            if (!fieldNames.add(f.getName().toLowerCase())) {
                throw new AnalysisException(String.format("Duplicate field name '%s' in struct '%s'", f.getName(), this.toSql()));
            }
            if (MetastoreShim.validateName(f.getName().toLowerCase())) continue;
            throw new AnalysisException("Invalid struct field name: " + f.getName());
        }
    }

    private void analyzeMapType(MapType mapType, Analyzer analyzer) throws AnalysisException {
        this.analyze(mapType.getKeyType(), analyzer);
        if (mapType.getKeyType().isComplexType()) {
            throw new AnalysisException("Map type cannot have a complex-typed key: " + mapType.toSql());
        }
        this.analyze(mapType.getValueType(), analyzer);
    }

    public Type getType() {
        return this.parsedType_;
    }

    public String toString() {
        return this.parsedType_.toSql();
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return this.parsedType_.toSql();
    }
}

