/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.IsNullPredicate;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;
import org.apache.impala.thrift.TTupleIsNullPredicate;

public class TupleIsNullPredicate
extends Predicate {
    private final Set<TupleId> tupleIds_;
    private Analyzer analyzer_;

    public TupleIsNullPredicate(List<TupleId> tupleIds) {
        Preconditions.checkState((tupleIds != null && !tupleIds.isEmpty() ? 1 : 0) != 0);
        this.tupleIds_ = Sets.newHashSet(tupleIds);
    }

    public TupleIsNullPredicate(TupleId tupleId) {
        this(Collections.singletonList(tupleId));
    }

    protected TupleIsNullPredicate(TupleIsNullPredicate other) {
        super(other);
        this.tupleIds_ = Sets.newHashSet(other.tupleIds_);
        this.analyzer_ = other.analyzer_;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        this.analyzer_ = analyzer;
    }

    @Override
    protected float computeEvalCost() {
        return (float)this.tupleIds_.size() * 1.0f;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        Preconditions.checkState((boolean)false, (Object)"Unexpected use of old toThrift() signature");
    }

    @Override
    protected void toThrift(TExprNode msg, ThriftSerializationCtx serialCtx) {
        msg.node_type = TExprNodeType.TUPLE_IS_NULL_PRED;
        msg.tuple_is_null_pred = new TTupleIsNullPredicate();
        Preconditions.checkNotNull((Object)this.analyzer_);
        for (TupleId tid : this.tupleIds_) {
            TupleDescriptor tupleDesc = this.analyzer_.getTupleDesc(tid);
            Preconditions.checkNotNull((Object)tupleDesc, (Object)("Unknown tuple id: " + tid.toString()));
            Preconditions.checkState((boolean)tupleDesc.isMaterialized(), (Object)String.format("Illegal reference to non-materialized tuple: tid=%s", tid));
            msg.tuple_is_null_pred.addToTuple_ids(serialCtx.translateTupleId(tid).asInt());
        }
    }

    @Override
    protected boolean localEquals(Expr that) {
        if (!super.localEquals(that)) {
            return false;
        }
        TupleIsNullPredicate other = (TupleIsNullPredicate)that;
        return other.tupleIds_.containsAll(this.tupleIds_) && this.tupleIds_.containsAll(other.tupleIds_);
    }

    @Override
    protected int localHash() {
        return Objects.hash(super.localHash(), this.tupleIds_);
    }

    @Override
    protected String toSqlImpl(ToSqlOptions options) {
        return "TupleIsNull(" + Joiner.on((String)",").join(this.tupleIds_) + ")";
    }

    public Set<TupleId> getTupleIds() {
        return this.tupleIds_;
    }

    @Override
    public boolean isBoundByTupleIds(List<TupleId> tids) {
        return tids.containsAll(this.tupleIds_);
    }

    @Override
    protected boolean isConstantImpl() {
        return false;
    }

    public static List<Expr> wrapExprs(List<Expr> inputExprs, List<TupleId> tids, Analyzer analyzer) throws InternalException {
        for (TupleId tid : tids) {
            TupleDescriptor tupleDesc = analyzer.getTupleDesc(tid);
            Preconditions.checkState((boolean)tupleDesc.isMaterialized());
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)inputExprs.size());
        for (Expr e : inputExprs) {
            result.add(TupleIsNullPredicate.wrapExpr(e, tids, analyzer));
        }
        return result;
    }

    public static Expr wrapExpr(Expr expr, List<TupleId> tids, Analyzer analyzer) throws InternalException {
        if (!TupleIsNullPredicate.requiresNullWrapping(expr, analyzer)) {
            return expr;
        }
        ArrayList<Expr> params = new ArrayList<Expr>();
        params.add(new TupleIsNullPredicate(tids));
        params.add(new NullLiteral());
        params.add(expr);
        FunctionCallExpr ifExpr = new FunctionCallExpr("if", params);
        ifExpr.analyzeNoThrow(analyzer);
        return ifExpr;
    }

    public static boolean requiresNullWrapping(Expr expr, Analyzer analyzer) throws InternalException {
        Preconditions.checkNotNull((Object)expr);
        if (expr.getType().isComplexType()) {
            Preconditions.checkState((boolean)(expr instanceof SlotRef));
            return false;
        }
        if (expr.contains(TupleIsNullPredicate.class)) {
            return true;
        }
        IsNullPredicate isNotNullLiteralPred = new IsNullPredicate(expr, true);
        isNotNullLiteralPred.analyzeNoThrow(analyzer);
        return analyzer.isTrueWithNullSlots(isNotNullLiteralPred);
    }

    public static Expr unwrapExpr(Expr expr) {
        if (expr instanceof FunctionCallExpr) {
            FunctionCallExpr fnCallExpr = (FunctionCallExpr)expr;
            List<Expr> params = fnCallExpr.getParams().exprs();
            if (fnCallExpr.getFnName().getFunction().equals("if") && params.get(0) instanceof TupleIsNullPredicate && Expr.IS_NULL_LITERAL.apply((Object)params.get(1))) {
                return TupleIsNullPredicate.unwrapExpr(params.get(2));
            }
        }
        for (int i = 0; i < expr.getChildren().size(); ++i) {
            expr.setChild(i, TupleIsNullPredicate.unwrapExpr((Expr)expr.getChild(i)));
        }
        return expr;
    }

    public static List<TupleIsNullPredicate> getUniqueBoundTupleIsNullPredicates(List<Expr> exprs, List<TupleId> tids) {
        ArrayList<TupleIsNullPredicate> tupleIsNullPreds = new ArrayList<TupleIsNullPredicate>();
        for (Expr expr : exprs) {
            if (!expr.isBoundByTupleIds(tids)) continue;
            expr.collect(TupleIsNullPredicate.class, tupleIsNullPreds);
        }
        Expr.removeDuplicates(tupleIsNullPreds);
        return tupleIsNullPreds;
    }

    @Override
    public Expr clone() {
        return new TupleIsNullPredicate(this);
    }

    @Override
    public boolean shouldConvertToCNF() {
        return true;
    }
}

