/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.impala.analysis.BaseTableRef;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.Pair;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.thrift.TTupleDescriptor;

public class TupleDescriptor {
    private static final int KUDU_STRING_PADDING = 4;
    private final TupleId id_;
    private final String debugName_;
    private final List<SlotDescriptor> slots_ = new ArrayList<SlotDescriptor>();
    private Path path_;
    private StructType type_;
    private String[] aliases_;
    private boolean hasExplicitAlias_;
    private boolean isHidden_;
    private boolean isMaterialized_ = true;
    private boolean hasMemLayout_ = false;
    private int byteSize_;
    private int numNullBytes_;
    private float avgSerializedSize_;
    private float serializedPadSize_;
    private BaseTableRef maskedTable_ = null;
    private TupleDescriptor maskedByTuple_ = null;
    private SlotDescriptor parentSlot_ = null;
    private InlineViewRef sourceView_ = null;

    public TupleDescriptor(TupleId id, String debugName) {
        this.id_ = id;
        this.path_ = null;
        this.debugName_ = debugName;
    }

    public void addSlot(SlotDescriptor desc) {
        Preconditions.checkState((!this.hasMemLayout_ ? 1 : 0) != 0);
        this.slots_.add(desc);
    }

    public TupleId getId() {
        return this.id_;
    }

    public List<SlotDescriptor> getSlots() {
        return this.slots_;
    }

    public List<SlotDescriptor> getSlotsRecursively() {
        ArrayList<SlotDescriptor> res = new ArrayList<SlotDescriptor>();
        for (SlotDescriptor slotDesc : this.slots_) {
            res.add(slotDesc);
            TupleDescriptor itemTupleDesc = slotDesc.getItemTupleDesc();
            if (!slotDesc.getType().isStructType() || itemTupleDesc == null) continue;
            res.addAll(itemTupleDesc.getSlotsRecursively());
        }
        return res;
    }

    public boolean hasMaterializedSlots() {
        for (SlotDescriptor slot : this.slots_) {
            if (!slot.isMaterialized()) continue;
            return true;
        }
        return false;
    }

    public List<SlotDescriptor> getMaterializedSlots() {
        ArrayList<SlotDescriptor> result = new ArrayList<SlotDescriptor>();
        for (SlotDescriptor slot : this.slots_) {
            if (!slot.isMaterialized()) continue;
            result.add(slot);
        }
        return result;
    }

    public List<SlotDescriptor> getSlotsOrderedByOffset() {
        Preconditions.checkState((boolean)this.hasMemLayout_);
        List<SlotDescriptor> result = this.getMaterializedSlots();
        Collections.sort(result, new Comparator<SlotDescriptor>(){

            @Override
            public int compare(SlotDescriptor a, SlotDescriptor b) {
                return Integer.compare(a.getByteOffset(), b.getByteOffset());
            }
        });
        return result;
    }

    public FeTable getTable() {
        if (this.path_ == null) {
            return null;
        }
        return this.path_.getRootTable();
    }

    public TableName getTableName() {
        FeTable t = this.getTable();
        return t == null ? null : t.getTableName();
    }

    public void setPath(Path p) {
        Preconditions.checkNotNull((Object)p);
        Preconditions.checkState((boolean)p.isResolved());
        Preconditions.checkState((boolean)p.destType().isComplexType());
        this.path_ = p;
        this.type_ = p.destTable() != null ? (StructType)p.destTable().getType().getItemType() : Path.getTypeAsStruct(p.destType());
    }

    public Path getPath() {
        return this.path_;
    }

    public void setType(StructType type) {
        this.type_ = type;
    }

    public StructType getType() {
        return this.type_;
    }

    public int getByteSize() {
        return this.byteSize_;
    }

    public float getAvgSerializedSize() {
        return this.avgSerializedSize_;
    }

    public float getSerializedPadSize() {
        return this.serializedPadSize_;
    }

    public boolean isMaterialized() {
        return this.isMaterialized_;
    }

    public void setIsMaterialized(boolean value) {
        this.isMaterialized_ = value;
    }

    public boolean hasMemLayout() {
        return this.hasMemLayout_;
    }

    public void setAliases(String[] aliases, boolean hasExplicitAlias) {
        this.aliases_ = aliases;
        this.hasExplicitAlias_ = hasExplicitAlias;
    }

    public boolean hasExplicitAlias() {
        return this.hasExplicitAlias_;
    }

    public String getAlias() {
        return this.aliases_ != null ? this.aliases_[0] : null;
    }

    public TableName getAliasAsName() {
        return this.aliases_ != null ? new TableName(null, this.aliases_[0]) : null;
    }

    public void setSourceView(InlineViewRef value) {
        this.sourceView_ = value;
    }

    public InlineViewRef getSourceView() {
        return this.sourceView_;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden_ = isHidden;
    }

    public boolean isHidden() {
        return this.isHidden_;
    }

    public TupleDescriptor getRootDesc() {
        if (this.path_ == null) {
            return null;
        }
        return this.path_.getRootDesc();
    }

    public TupleDescriptor getMaskedByTuple() {
        return this.maskedByTuple_;
    }

    public BaseTableRef getMaskedTable() {
        return this.maskedTable_;
    }

    public void setMaskedTable(BaseTableRef table) {
        Preconditions.checkState((this.maskedTable_ == null ? 1 : 0) != 0);
        this.maskedTable_ = table;
        table.getDesc().maskedByTuple_ = this;
    }

    public void setParentSlotDesc(SlotDescriptor parent) {
        Type parentType = parent.getType();
        Preconditions.checkState((parentType.isStructType() || parentType.isCollectionType() ? 1 : 0) != 0, (Object)("Parent for a TupleDescriptor should be a STRUCT or a COLLECTION. Actual type is " + parentType + " Tuple ID: " + this.getId()));
        this.parentSlot_ = parent;
    }

    public SlotDescriptor getParentSlotDesc() {
        return this.parentSlot_;
    }

    public boolean isStructChild() {
        return this.parentSlot_ != null && this.parentSlot_.getType().isStructType();
    }

    public String debugString() {
        String tblStr = this.getTable() == null ? "null" : this.getTable().getFullName();
        ArrayList<String> slotStrings = new ArrayList<String>();
        for (SlotDescriptor slot : this.slots_) {
            slotStrings.add(slot.debugString());
        }
        MoreObjects.ToStringHelper toStrHelper = MoreObjects.toStringHelper((Object)this).add("id", this.id_.asInt()).add("name", (Object)this.debugName_).add("tbl", (Object)tblStr).add("byte_size", this.byteSize_).add("is_materialized", this.isMaterialized_).add("slots", (Object)("[" + Joiner.on((String)", ").join(slotStrings) + "]"));
        if (this.maskedTable_ != null) {
            toStrHelper.add("masks", (Object)this.maskedTable_.getId());
        }
        if (this.parentSlot_ != null) {
            toStrHelper.add("parentSlot", (Object)this.parentSlot_.getId());
        }
        return toStrHelper.toString();
    }

    public String toString() {
        return this.debugString();
    }

    public void checkIsExecutable() {
        Preconditions.checkState((boolean)this.isMaterialized_, (Object)String.format("Illegal reference to non-materialized tuple: debugname=%s alias=%s tid=%s", this.debugName_, StringUtils.defaultIfEmpty((CharSequence)this.getAlias(), (CharSequence)"n/a"), this.id_));
        Preconditions.checkState((boolean)this.hasMemLayout_, (Object)String.format("Missing memory layout for tuple: debugname=%s alias=%s tid=%s", this.debugName_, StringUtils.defaultIfEmpty((CharSequence)this.getAlias(), (CharSequence)"n/a"), this.id_));
    }

    public void materializeSlots() {
        for (SlotDescriptor slot : this.getSlotsRecursively()) {
            slot.setIsMaterialized(true);
        }
    }

    public TTupleDescriptor toThrift(Integer tableId, ThriftSerializationCtx serialCtx) {
        TTupleDescriptor ttupleDesc = new TTupleDescriptor(serialCtx.translateTupleId(this.id_).asInt(), this.byteSize_, this.numNullBytes_);
        if (tableId == null) {
            return ttupleDesc;
        }
        ttupleDesc.setTableId(tableId);
        Preconditions.checkNotNull((Object)this.path_);
        ttupleDesc.setTuplePath(this.path_.getAbsolutePath());
        return ttupleDesc;
    }

    public void resetHasMemoryLayout() {
        this.hasMemLayout_ = false;
    }

    public void recomputeMemLayout() {
        if (!this.hasMemLayout_) {
            return;
        }
        this.hasMemLayout_ = false;
        this.computeMemLayout();
    }

    public Pair<Integer, Integer> computeMemLayout() {
        boolean isChildOfStruct = this.isStructChild();
        if (isChildOfStruct) {
            Preconditions.checkState((this.parentSlot_.getByteOffset() != -1 ? 1 : 0) != 0);
        }
        if (this.hasMemLayout_) {
            return null;
        }
        this.hasMemLayout_ = true;
        boolean alwaysAddNullBit = this.hasNullableKuduScanSlots();
        this.avgSerializedSize_ = 0.0f;
        this.serializedPadSize_ = 0.0f;
        HashMap slotsBySize = new HashMap();
        int numNullBits = 0;
        int totalSlotSize = 0;
        for (SlotDescriptor d : this.slots_) {
            if (!d.isMaterialized()) continue;
            int slotSize = this.getSlotSize(d);
            this.addToAvgSerializedSize(d);
            if (!slotsBySize.containsKey(slotSize)) {
                slotsBySize.put(slotSize, new ArrayList());
            }
            ((List)slotsBySize.get(slotSize)).add(d);
            totalSlotSize += slotSize;
            numNullBits += this.getNumNullBits(d, alwaysAddNullBit);
        }
        Preconditions.checkState((!slotsBySize.containsKey(0) ? 1 : 0) != 0);
        Preconditions.checkState((!slotsBySize.containsKey(-1) ? 1 : 0) != 0);
        this.numNullBytes_ = isChildOfStruct ? 0 : (numNullBits + 7) / 8;
        int slotOffset = 0;
        int nullIndicatorByte = totalSlotSize;
        int nullIndicatorBit = 0;
        if (isChildOfStruct) {
            nullIndicatorByte = this.parentSlot_.getNullIndicatorByte();
            nullIndicatorBit = (this.parentSlot_.getNullIndicatorBit() + 1) % 8;
            if (nullIndicatorBit == 0) {
                ++nullIndicatorByte;
            }
        }
        int slotIdx = 0;
        ArrayList sortedSizes = new ArrayList(slotsBySize.keySet());
        Collections.sort(sortedSizes, Collections.reverseOrder());
        Iterator iterator = sortedSizes.iterator();
        while (iterator.hasNext()) {
            int slotSize = (Integer)iterator.next();
            if (((List)slotsBySize.get(slotSize)).isEmpty()) continue;
            for (SlotDescriptor d : (List)slotsBySize.get(slotSize)) {
                Preconditions.checkState((boolean)d.isMaterialized());
                d.setByteSize(slotSize);
                d.setByteOffset(isChildOfStruct ? this.parentSlot_.getByteOffset() + slotOffset : slotOffset);
                slotOffset += slotSize;
                d.setSlotIdx(slotIdx++);
                if (d.getIsNullable() || alwaysAddNullBit) {
                    d.setNullIndicatorByte(nullIndicatorByte);
                    d.setNullIndicatorBit(nullIndicatorBit);
                    nullIndicatorBit = (nullIndicatorBit + 1) % 8;
                    if (nullIndicatorBit == 0) {
                        ++nullIndicatorByte;
                    }
                }
                if (!d.getIsNullable()) {
                    d.setNullIndicatorBit(-1);
                    d.setNullIndicatorByte(0);
                }
                if (d.getType().isStructType()) {
                    Pair<Integer, Integer> nullIndicators = d.getItemTupleDesc().computeMemLayout();
                    nullIndicatorByte = (Integer)nullIndicators.first;
                    nullIndicatorBit = (Integer)nullIndicators.second;
                }
                if (!d.getType().isCollectionType() || !d.shouldMaterializeRecursively()) continue;
                d.getItemTupleDesc().computeMemLayout();
            }
        }
        Preconditions.checkState((slotOffset == totalSlotSize ? 1 : 0) != 0);
        this.byteSize_ = totalSlotSize + this.numNullBytes_;
        return new Pair<Integer, Integer>(nullIndicatorByte, nullIndicatorBit);
    }

    public void resetMemLayout() {
        this.hasMemLayout_ = false;
    }

    private int getSlotSize(SlotDescriptor slotDesc) {
        int slotSize = slotDesc.getMaterializedSlotSize();
        if (slotDesc.isKuduStringSlot()) {
            slotSize += 4;
        }
        return slotSize;
    }

    private void addToAvgSerializedSize(SlotDescriptor slotDesc) {
        ColumnStats stats = slotDesc.getStats();
        if (stats.hasAvgSize()) {
            this.avgSerializedSize_ = (float)((double)this.avgSerializedSize_ + stats.getAvgSerializedSize());
            this.serializedPadSize_ = (float)((double)this.serializedPadSize_ + Math.max(0.0, stats.getAvgSerializedSize() - stats.getAvgSize()));
        } else {
            this.avgSerializedSize_ += (float)slotDesc.getMaterializedSlotSize();
        }
        if (slotDesc.isKuduStringSlot()) {
            this.avgSerializedSize_ += 4.0f;
            this.serializedPadSize_ += 4.0f;
        }
    }

    private int getNumNullBits(SlotDescriptor slotDesc, boolean alwaysAddNullBit) {
        Preconditions.checkState((!slotDesc.getType().isStructType() || slotDesc.getIsNullable() ? 1 : 0) != 0);
        if (!slotDesc.getIsNullable() && !alwaysAddNullBit) {
            return 0;
        }
        if (!slotDesc.getType().isStructType()) {
            return 1;
        }
        TupleDescriptor childrenTuple = slotDesc.getItemTupleDesc();
        Preconditions.checkState((childrenTuple != null ? 1 : 0) != 0);
        int numNullBits = 1;
        for (SlotDescriptor child : childrenTuple.getSlots()) {
            numNullBits += this.getNumNullBits(child, alwaysAddNullBit);
        }
        return numNullBits;
    }

    private boolean hasNullableKuduScanSlots() {
        if (!(this.getTable() instanceof FeKuduTable)) {
            return false;
        }
        for (SlotDescriptor d : this.slots_) {
            if (!d.isMaterialized() || !d.getIsNullable()) continue;
            return true;
        }
        return false;
    }

    public boolean hasClusteringColsOnly() {
        FeTable table = this.getTable();
        if (!(table instanceof FeFsTable)) {
            return false;
        }
        if (!this.hasMaterializedSlots()) {
            return true;
        }
        if (table.getNumClusteringCols() == 0) {
            return false;
        }
        FeFsTable hdfsTable = (FeFsTable)table;
        for (SlotDescriptor slotDesc : this.getSlots()) {
            if (!slotDesc.isMaterialized() || slotDesc.getColumn() != null && hdfsTable.isClusteringColumn(slotDesc.getColumn())) continue;
            return false;
        }
        return true;
    }

    public List<SlotId> getPartitionSlots() {
        ArrayList<SlotId> partitionSlots = new ArrayList<SlotId>();
        for (SlotDescriptor slotDesc : this.getSlots()) {
            if (slotDesc.getColumn() == null || slotDesc.getColumn().getPosition() >= this.getTable().getNumClusteringCols()) continue;
            partitionSlots.add(slotDesc.getId());
        }
        return partitionSlots;
    }

    public boolean hasVarLenSlots() {
        for (SlotDescriptor slot : this.slots_) {
            if (slot.getType().isFixedLengthType()) continue;
            return true;
        }
        return false;
    }
}

