/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;

public class TrimFromExpr
extends FunctionCallExpr {
    private final FunctionName trimFromFnName_;
    private final TrimOption where_;
    private final Expr charset_;
    private final Expr srcExpr_;
    private SlotRef slotRef_ = null;

    private static FunctionName baseFnName(FunctionName fnName, TrimOption where) {
        String fn = fnName.toString();
        if (where == null) {
            where = TrimOption.BOTH;
        }
        switch (where) {
            case LEADING: {
                fn = fn.replaceAll("trim", "ltrim");
                break;
            }
            case TRAILING: {
                fn = fn.replaceAll("trim", "rtrim");
                break;
            }
            default: {
                fn = fn.replaceAll("trim", "btrim");
            }
        }
        return new FunctionName(fn);
    }

    public TrimFromExpr(FunctionName fnName, TrimOption where, Expr srcexpr) {
        this(fnName, where, null, srcexpr);
    }

    public TrimFromExpr(FunctionName fnName, Expr charset, Expr srcexpr) {
        this(fnName, null, charset, srcexpr);
    }

    public TrimFromExpr(FunctionName fnName, String slot, Expr srcexpr) {
        this(fnName, null, null, srcexpr);
        this.slotRef_ = new SlotRef(Arrays.asList(slot));
    }

    public TrimFromExpr(FunctionName fnName, TrimOption where, Expr charset, Expr srcexpr) {
        super(TrimFromExpr.baseFnName(fnName, where), (List<Expr>)(charset == null ? Lists.newArrayList((Object[])new Expr[]{srcexpr}) : Lists.newArrayList((Object[])new Expr[]{srcexpr, charset})));
        this.trimFromFnName_ = fnName;
        this.where_ = where;
        this.charset_ = charset;
        this.srcExpr_ = srcexpr;
        this.type_ = Type.STRING;
    }

    protected TrimFromExpr(TrimFromExpr other) {
        super(other);
        this.trimFromFnName_ = other.trimFromFnName_;
        this.where_ = other.where_;
        this.charset_ = other.charset_;
        this.srcExpr_ = other.srcExpr_;
        this.slotRef_ = other.slotRef_;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        this.trimFromFnName_.analyze(analyzer);
        if (!this.trimFromFnName_.getFunction().equals("trim") && !this.trimFromFnName_.getFunction().equals("utf8_trim")) {
            throw new AnalysisException("Function " + this.trimFromFnName_.getFunction().toUpperCase() + " does not accept the keyword FROM.");
        }
        if (this.trimFromFnName_.getDb() != null && !this.trimFromFnName_.getDb().equals("_impala_builtins")) {
            throw new AnalysisException("Function " + this.trimFromFnName_.toString() + " conflicts with the TRIM builtin.");
        }
        super.analyzeImpl(analyzer);
        if (this.slotRef_ != null) {
            try {
                this.slotRef_.analyze(analyzer);
            }
            catch (AnalysisException e) {
                throw new AnalysisException("Trim option '" + this.slotRef_.toSql() + "' in expression '" + this.toSql() + "' is invalid. Expected one of: " + Arrays.stream(TrimOption.values()).map(option -> option.name()).collect(Collectors.joining(", ")) + ". Note: TRIM-FROM syntax also accepts a column name identifier as a charset argument.");
            }
            if (super.getParams().size() == 1) {
                super.getParams().exprs().add(this.slotRef_);
                this.children_.add(this.slotRef_);
            }
        }
    }

    @Override
    protected String getFunctionNotFoundError(Type[] argTypes) {
        StringBuilder errMsg = new StringBuilder();
        if (this.charset_ != null && this.charset_.getType() != Type.STRING) {
            errMsg.append("Expression '" + this.charset_.toSql() + "' has a return type of " + this.charset_.getType().toSql() + " but a STRING is required.");
        }
        if (this.slotRef_ != null && this.slotRef_.getType() != Type.STRING) {
            errMsg.append("Expression '" + this.slotRef_.toSql() + "' has a return type of " + this.slotRef_.getType().toSql() + " but a STRING is required.");
        }
        if (this.srcExpr_ != null && this.srcExpr_.getType() != Type.STRING) {
            if (errMsg.length() > 0) {
                errMsg.append(" ");
            }
            errMsg.append("Expression '" + this.srcExpr_.toSql() + "' has a return type of " + this.srcExpr_.getType().toSql() + " but a STRING is required.");
        }
        return errMsg.toString();
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(this.trimFromFnName_ + "(");
        if (this.where_ != null) {
            strBuilder.append(this.where_.name() + " ");
        }
        if (this.slotRef_ != null) {
            strBuilder.append(this.slotRef_.toSql(options) + " ");
        }
        if (this.charset_ != null) {
            strBuilder.append(this.charset_.toSql(options) + " ");
        }
        strBuilder.append("FROM " + this.srcExpr_.toSql(options) + ")");
        return strBuilder.toString();
    }

    @Override
    public Expr clone() {
        return new TrimFromExpr(this);
    }

    public static enum TrimOption {
        LEADING,
        TRAILING,
        BOTH;

    }
}

