/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hadoop.hive.ql.parse.HiveLexer;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.CreateTableAsSelectStmt;
import org.apache.impala.analysis.CreateTableStmt;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.IcebergPartitionSpec;
import org.apache.impala.analysis.KuduPartitionParam;
import org.apache.impala.analysis.PlanHint;
import org.apache.impala.analysis.SqlScanner;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.DataSourceTable;
import org.apache.impala.catalog.FeDataSourceTable;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HdfsCompression;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.KuduColumn;
import org.apache.impala.catalog.KuduTable;
import org.apache.impala.catalog.RowFormat;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.paimon.FePaimonTable;
import org.apache.impala.catalog.paimon.PaimonUtil;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TBucketInfo;
import org.apache.impala.thrift.TBucketType;
import org.apache.impala.thrift.TIcebergCatalog;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.BucketUtils;
import org.apache.impala.util.IcebergUtil;
import org.apache.impala.util.KuduUtil;
import org.apache.paimon.CoreOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToSqlUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ToSqlUtils.class);
    @VisibleForTesting
    protected static final ImmutableSet<String> HIDDEN_TABLE_PROPERTIES = ImmutableSet.of((Object)"EXTERNAL", (Object)"comment", (Object)"sort.columns", (Object)"sort.order", (Object)"numFilesErasureCoded", (Object)"numFiles", (Object[])new String[]{"totalSize", "impala.events.catalogServiceId", "impala.events.catalogVersion", "last_modified_by", "last_modified_time", "numRows"});

    @VisibleForTesting
    protected static void removeHiddenTableProperties(Map<String, String> tblProperties) {
        for (String key : HIDDEN_TABLE_PROPERTIES) {
            tblProperties.remove(key);
        }
    }

    @VisibleForTesting
    protected static void removeHiddenKuduTableProperties(Map<String, String> tblProperties) {
        tblProperties.remove("kudu.table_name");
    }

    @VisibleForTesting
    protected static List<String> getSortColumns(Map<String, String> properties) {
        String sortByKey = "sort.columns";
        if (!properties.containsKey(sortByKey)) {
            return null;
        }
        return Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)properties.get(sortByKey)));
    }

    @VisibleForTesting
    protected static String getSortingOrder(Map<String, String> properties) {
        String sortOrderKey = "sort.order";
        if (!properties.containsKey(sortOrderKey)) {
            return TSortingOrder.LEXICAL.toString();
        }
        return properties.get(sortOrderKey);
    }

    private static String getKuduPartitionByParams(CreateTableStmt stmt) {
        List<KuduPartitionParam> partitionParams = stmt.getKuduPartitionParams();
        Preconditions.checkNotNull(partitionParams);
        if (partitionParams.isEmpty()) {
            return null;
        }
        ArrayList<String> paramStrings = new ArrayList<String>();
        for (KuduPartitionParam p : partitionParams) {
            paramStrings.add(p.toSql());
        }
        return Joiner.on((String)", ").join(paramStrings);
    }

    public static boolean hiveNeedsQuotes(String ident) {
        HiveLexer hiveLexer = new HiveLexer((CharStream)new ANTLRStringStream(ident.toUpperCase())){

            public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Error in checking needsQuotes using HiveLexer {}: {}", (Object)this.getErrorHeader(e), (Object)this.getErrorMessage(e, tokenNames));
                }
            }
        };
        try {
            Token t = hiveLexer.nextToken();
            if (t.getType() != 24) {
                return true;
            }
            t = hiveLexer.nextToken();
            return t.getType() != -1;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean impalaNeedsQuotes(String ident) {
        return SqlScanner.isReserved(ident) || Character.isDigit(ident.charAt(0)) || ident.contains("#") || ident.contains("--");
    }

    public static String getIdentSql(String ident) {
        if (ident.equals("*")) {
            return ident;
        }
        return ToSqlUtils.hiveNeedsQuotes(ident) || ToSqlUtils.impalaNeedsQuotes(ident) ? "`" + ident + "`" : ident;
    }

    public static String identSql(String ident) {
        ArrayList<String> parts = new ArrayList<String>();
        for (String part : Splitter.on((char)'.').split((CharSequence)ident)) {
            parts.add(ident.equals("*") ? part : ToSqlUtils.getIdentSql(part));
        }
        return Joiner.on((char)'.').join(parts);
    }

    public static List<String> getIdentSqlList(List<String> identList) {
        ArrayList<String> identSqlList = new ArrayList<String>();
        for (String ident : identList) {
            identSqlList.add(ToSqlUtils.getIdentSql(ident));
        }
        return identSqlList;
    }

    public static String getPathSql(List<String> path) {
        StringBuilder result = new StringBuilder();
        for (String p : path) {
            if (result.length() > 0) {
                result.append(".");
            }
            result.append(ToSqlUtils.getIdentSql(p));
        }
        return result.toString();
    }

    private static String getIcebergPartitionSpecsSql(CreateTableStmt stmt) {
        List<IcebergPartitionSpec> partitionSpecs = stmt.getIcebergPartitionSpecs();
        if (!partitionSpecs.isEmpty() && partitionSpecs.get(0).hasPartitionFields()) {
            return partitionSpecs.get(0).toSql();
        }
        return null;
    }

    public static String getCreateTableSql(CreateTableStmt stmt) {
        ArrayList<String> colsSql = new ArrayList<String>();
        for (ColumnDef columnDef : stmt.getColumnDefs()) {
            colsSql.add(columnDef.toString());
        }
        ArrayList<String> partitionColsSql = new ArrayList<String>();
        for (ColumnDef col : stmt.getPartitionColumnDefs()) {
            partitionColsSql.add(col.toString());
        }
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap(stmt.getTblProperties());
        LinkedHashMap generatedProperties = Maps.newLinkedHashMap(stmt.getGeneratedKuduProperties());
        ToSqlUtils.removeHiddenTableProperties(linkedHashMap);
        ToSqlUtils.removeHiddenKuduTableProperties(generatedProperties);
        linkedHashMap.putAll(generatedProperties);
        String kuduParamsSql = ToSqlUtils.getKuduPartitionByParams(stmt);
        String icebergPartitionSpecs = ToSqlUtils.getIcebergPartitionSpecsSql(stmt);
        return ToSqlUtils.getCreateTableSql(stmt.getDb(), stmt.getTbl(), stmt.getComment(), colsSql, partitionColsSql, stmt.isPrimaryKeyUnique(), stmt.getTblPrimaryKeyColumnNames(), stmt.getForeignKeysSql(), kuduParamsSql, new Pair<List<String>, TSortingOrder>(stmt.getSortColumns(), stmt.getSortingOrder()), linkedHashMap, stmt.getSerdeProperties(), stmt.isExternal(), stmt.getIfNotExists(), stmt.getRowFormat(), HdfsFileFormat.fromThrift(stmt.getFileFormat()), HdfsCompression.NONE, null, stmt.getLocation(), icebergPartitionSpecs, stmt.geTBucketInfo());
    }

    public static String getCreateTableSql(CreateTableAsSelectStmt stmt, ToSqlOptions options) {
        CreateTableStmt innerStmt = stmt.getCreateStmt();
        ArrayList<String> partitionColsSql = new ArrayList<String>();
        for (ColumnDef col : innerStmt.getPartitionColumnDefs()) {
            partitionColsSql.add(col.getColName());
        }
        LinkedHashMap properties = Maps.newLinkedHashMap(innerStmt.getTblProperties());
        LinkedHashMap generatedProperties = Maps.newLinkedHashMap(stmt.getCreateStmt().getGeneratedKuduProperties());
        ToSqlUtils.removeHiddenTableProperties(properties);
        ToSqlUtils.removeHiddenKuduTableProperties(generatedProperties);
        properties.putAll(generatedProperties);
        String kuduParamsSql = ToSqlUtils.getKuduPartitionByParams(innerStmt);
        String icebergPartitionSpecs = ToSqlUtils.getIcebergPartitionSpecsSql(innerStmt);
        String createTableSql = ToSqlUtils.getCreateTableSql(innerStmt.getDb(), innerStmt.getTbl(), innerStmt.getComment(), null, partitionColsSql, innerStmt.isPrimaryKeyUnique(), innerStmt.getTblPrimaryKeyColumnNames(), innerStmt.getForeignKeysSql(), kuduParamsSql, new Pair<List<String>, TSortingOrder>(innerStmt.getSortColumns(), innerStmt.getSortingOrder()), properties, innerStmt.getSerdeProperties(), innerStmt.isExternal(), innerStmt.getIfNotExists(), innerStmt.getRowFormat(), HdfsFileFormat.fromThrift(innerStmt.getFileFormat()), HdfsCompression.NONE, null, innerStmt.getLocation(), icebergPartitionSpecs, innerStmt.geTBucketInfo());
        return createTableSql + " AS " + stmt.getQueryStmt().toSql(options);
    }

    public static String getCreateTableSql(FeTable table) throws CatalogException {
        String inputFormat;
        Preconditions.checkNotNull((Object)table);
        if (table instanceof FeView) {
            return ToSqlUtils.getCreateViewSql((FeView)table);
        }
        org.apache.hadoop.hive.metastore.api.Table msTable = table.getMetaStoreTable();
        LinkedHashMap properties = Maps.newLinkedHashMap((Map)msTable.getParameters());
        if (properties.containsKey("transient_lastDdlTime")) {
            properties.remove("transient_lastDdlTime");
        }
        boolean isExternal = Table.isExternalTable(msTable);
        List<String> sortColsSql = ToSqlUtils.getSortColumns(properties);
        TSortingOrder sortingOrder = TSortingOrder.valueOf(ToSqlUtils.getSortingOrder(properties));
        String comment = (String)properties.get("comment");
        ToSqlUtils.removeHiddenTableProperties(properties);
        ArrayList<String> colsSql = new ArrayList<String>();
        ArrayList<String> partitionColsSql = new ArrayList<String>();
        boolean isHbaseTable = table instanceof FeHBaseTable;
        boolean isFullAcid = AcidUtils.isFullAcidTable(table.getMetaStoreTable().getParameters());
        for (int i = 0; i < table.getColumns().size(); ++i) {
            Column col = table.getColumns().get(i);
            if (!isHbaseTable && i < table.getNumClusteringCols()) {
                partitionColsSql.add(ToSqlUtils.columnToSql(col));
                continue;
            }
            if (isFullAcid && i == table.getNumClusteringCols()) {
                Preconditions.checkState((boolean)col.getName().equals("row__id"));
                continue;
            }
            colsSql.add(ToSqlUtils.columnToSql(col));
        }
        RowFormat rowFormat = RowFormat.fromStorageDescriptor(msTable.getSd());
        HdfsFileFormat format = null;
        HdfsCompression compression = null;
        String location = isHbaseTable ? null : msTable.getSd().getLocation();
        Map serdeParameters = msTable.getSd().getSerdeInfo().getParameters();
        TBucketInfo bucketInfo = BucketUtils.fromStorageDescriptor(msTable.getSd());
        String storageHandlerClassName = table.getStorageHandlerClassName();
        boolean isPrimaryKeyUnique = true;
        List<String> primaryKeySql = new ArrayList<String>();
        List<String> foreignKeySql = new ArrayList<String>();
        String kuduPartitionByParams = null;
        String icebergPartitions = null;
        if (table instanceof FeKuduTable) {
            FeKuduTable kuduTable = (FeKuduTable)table;
            location = null;
            format = HdfsFileFormat.KUDU;
            storageHandlerClassName = null;
            properties.remove("storage_handler");
            String kuduTableName = (String)properties.get("kudu.table_name");
            if (kuduTableName != null && KuduUtil.isDefaultKuduTableName(kuduTableName, table.getDb().getName(), table.getName())) {
                properties.remove("kudu.table_name");
            }
            properties.remove("kudu.table_id");
            properties.remove("DO_NOT_UPDATE_STATS");
            isPrimaryKeyUnique = kuduTable.isPrimaryKeyUnique();
            if (KuduTable.isSynchronizedTable(msTable)) {
                primaryKeySql.addAll(kuduTable.getPrimaryKeyColumnNames());
                ArrayList<String> paramsSql = new ArrayList<String>();
                for (KuduPartitionParam param : kuduTable.getPartitionBy()) {
                    paramsSql.add(param.toSql());
                }
                kuduPartitionByParams = Joiner.on((String)", ").join(paramsSql);
            } else {
                colsSql = null;
            }
        } else if (table instanceof FeFsTable) {
            if (table instanceof FeIcebergTable) {
                IcebergPartitionSpec latestPartitionSpec;
                storageHandlerClassName = null;
                properties.remove("storage_handler");
                properties.remove("DO_NOT_UPDATE_STATS");
                properties.remove("metadata_location");
                properties.remove("previous_metadata_location");
                properties.remove("current-schema");
                properties.remove("snapshot-count");
                properties.remove("current-snapshot-id");
                properties.remove("current-snapshot-summary");
                properties.remove("current-snapshot-timestamp-ms");
                properties.remove("default-partition-spec");
                properties.remove("uuid");
                FeIcebergTable feIcebergTable = (FeIcebergTable)table;
                if (!feIcebergTable.getPartitionSpecs().isEmpty() && (latestPartitionSpec = feIcebergTable.getDefaultPartitionSpec()).hasPartitionFields()) {
                    icebergPartitions = feIcebergTable.getDefaultPartitionSpec().toSql();
                }
            }
            inputFormat = msTable.getSd().getInputFormat();
            String serDeLib = msTable.getSd().getSerdeInfo().getSerializationLib();
            format = HdfsFileFormat.fromHdfsInputFormatClass(inputFormat, serDeLib);
            compression = HdfsCompression.fromHdfsInputFormatClass(inputFormat);
            try {
                primaryKeySql = ((FeFsTable)table).getPrimaryKeyColumnNames();
                foreignKeySql = ((FeFsTable)table).getForeignKeysSql();
            }
            catch (Exception e) {
                throw new CatalogException("Could not get primary key/foreign keys sql.", e);
            }
        } else if (table instanceof FePaimonTable) {
            inputFormat = msTable.getSd().getInputFormat();
            String serDeLib = msTable.getSd().getSerdeInfo().getSerializationLib();
            format = HdfsFileFormat.fromHdfsInputFormatClass(inputFormat, serDeLib);
            storageHandlerClassName = null;
            isPrimaryKeyUnique = true;
            properties.remove(CoreOptions.PRIMARY_KEY.key());
            properties.remove(CoreOptions.PARTITION.key());
            properties.remove("storage_handler");
            properties.remove("OBJCAPABILITIES");
            if (PaimonUtil.isSynchronizedTable(msTable)) {
                properties.remove("TRANSLATED_TO_EXTERNAL");
                properties.remove("external.table.purge");
                if (location != null && location.toLowerCase().endsWith(table.getName().toLowerCase())) {
                    location = null;
                }
                isExternal = false;
            }
            try {
                Column col;
                int i;
                FePaimonTable fePaimonTable = (FePaimonTable)table;
                primaryKeySql = fePaimonTable.getPaimonApiTable().primaryKeys().stream().map(String::toLowerCase).collect(Collectors.toList());
                partitionColsSql = new ArrayList();
                for (i = 0; i < table.getNumClusteringCols(); ++i) {
                    col = table.getColumns().get(i);
                    partitionColsSql.add(ToSqlUtils.columnToSql(col));
                }
                colsSql = new ArrayList();
                for (i = table.getNumClusteringCols(); i < table.getColumns().size(); ++i) {
                    col = table.getColumns().get(i);
                    colsSql.add(ToSqlUtils.columnToSql(col));
                }
            }
            catch (Exception e) {
                throw new CatalogException("Could not get primary key/foreign keys sql.", e);
            }
        } else if (table instanceof FeDataSourceTable) {
            Set<String> keysToBeMasked = DataSourceTable.getJdbcTblPropertyMaskKeys();
            for (String key : properties.keySet()) {
                if (!keysToBeMasked.contains(key.toLowerCase())) continue;
                properties.put(key, "******");
            }
        }
        HdfsUri tableLocation = location == null ? null : new HdfsUri(location);
        return ToSqlUtils.getCreateTableSql(table.getDb().getName(), table.getName(), comment, colsSql, partitionColsSql, isPrimaryKeyUnique, primaryKeySql, foreignKeySql, kuduPartitionByParams, new Pair<List<String>, TSortingOrder>(sortColsSql, sortingOrder), properties, serdeParameters, isExternal, false, rowFormat, format, compression, storageHandlerClassName, tableLocation, icebergPartitions, bucketInfo);
    }

    public static String getCreateTableSql(String dbName, String tableName, String tableComment, List<String> columnsSql, List<String> partitionColumnsSql, boolean isPrimaryKeyUnique, List<String> primaryKeysSql, List<String> foreignKeysSql, String kuduPartitionByParams, Pair<List<String>, TSortingOrder> sortProperties, Map<String, String> tblProperties, Map<String, String> serdeParameters, boolean isExternal, boolean ifNotExists, RowFormat rowFormat, HdfsFileFormat fileFormat, HdfsCompression compression, String storageHandlerClass, HdfsUri location, String icebergPartitions, TBucketInfo bucketInfo) {
        boolean isHadoopCatalog;
        Preconditions.checkNotNull((Object)tableName);
        StringBuilder sb = new StringBuilder("CREATE ");
        if (isExternal) {
            sb.append("EXTERNAL ");
        }
        sb.append("TABLE ");
        if (ifNotExists) {
            sb.append("IF NOT EXISTS ");
        }
        if (dbName != null) {
            sb.append(dbName + ".");
        }
        sb.append(tableName);
        if (columnsSql != null && !columnsSql.isEmpty()) {
            sb.append(" (\n  ");
            sb.append(Joiner.on((String)",\n  ").join(columnsSql));
            if (CollectionUtils.isNotEmpty(primaryKeysSql)) {
                sb.append(",\n  ");
                sb.append(KuduUtil.getPrimaryKeyString(isPrimaryKeyUnique)).append(" (");
                Joiner.on((String)", ").appendTo(sb, primaryKeysSql).append(")");
            }
            if (CollectionUtils.isNotEmpty(foreignKeysSql)) {
                sb.append(",\n  FOREIGN KEY");
                Joiner.on((String)",\n  FOREIGN KEY").appendTo(sb, foreignKeysSql).append("\n");
            }
            sb.append("\n)");
        } else if (primaryKeysSql != null && !primaryKeysSql.isEmpty()) {
            sb.append("\n ");
            sb.append(KuduUtil.getPrimaryKeyString(isPrimaryKeyUnique)).append(" (");
            Joiner.on((String)", ").appendTo(sb, primaryKeysSql).append(")");
        }
        sb.append("\n");
        if (partitionColumnsSql != null && partitionColumnsSql.size() > 0) {
            sb.append(String.format("PARTITIONED BY (\n  %s\n)\n", Joiner.on((String)", \n  ").join(partitionColumnsSql)));
        }
        if (kuduPartitionByParams != null && !kuduPartitionByParams.equals("")) {
            sb.append("PARTITION BY " + kuduPartitionByParams + "\n");
        }
        if (bucketInfo != null && bucketInfo.getBucket_type() != TBucketType.NONE) {
            sb.append(String.format("CLUSTERED BY (\n %s\n)\n", Joiner.on((String)", \n  ").join(bucketInfo.getBucket_columns())));
            if (sortProperties.first != null) {
                sb.append(String.format("SORT BY %s (\n  %s\n)\n", ((TSortingOrder)((Object)sortProperties.second)).toString(), Joiner.on((String)", \n  ").join((Iterable)sortProperties.first)));
            }
            sb.append(String.format("INTO %s BUCKETS\n", bucketInfo.getNum_bucket()));
        } else if (sortProperties.first != null) {
            sb.append(String.format("SORT BY %s (\n  %s\n)\n", ((TSortingOrder)((Object)sortProperties.second)).toString(), Joiner.on((String)", \n  ").join((Iterable)sortProperties.first)));
        }
        if (icebergPartitions != null && !icebergPartitions.isEmpty()) {
            sb.append("PARTITIONED BY SPEC\n");
            sb.append(icebergPartitions);
            sb.append("\n");
        }
        if (tableComment != null) {
            sb.append(" COMMENT '" + tableComment + "'\n");
        }
        if (rowFormat != null && !rowFormat.isDefault()) {
            sb.append("ROW FORMAT DELIMITED");
            if (rowFormat.getFieldDelimiter() != null) {
                String fieldDelim = StringEscapeUtils.escapeJava((String)rowFormat.getFieldDelimiter());
                sb.append(" FIELDS TERMINATED BY '" + fieldDelim + "'");
            }
            if (rowFormat.getEscapeChar() != null) {
                String escapeChar = StringEscapeUtils.escapeJava((String)rowFormat.getEscapeChar());
                sb.append(" ESCAPED BY '" + escapeChar + "'");
            }
            if (rowFormat.getLineDelimiter() != null) {
                String lineDelim = StringEscapeUtils.escapeJava((String)rowFormat.getLineDelimiter());
                sb.append(" LINES TERMINATED BY '" + lineDelim + "'");
            }
            sb.append("\n");
        }
        if (storageHandlerClass == null) {
            if (compression != HdfsCompression.LZO && compression != HdfsCompression.LZO_INDEX && serdeParameters != null && !serdeParameters.isEmpty()) {
                sb.append("WITH SERDEPROPERTIES " + ToSqlUtils.propertyMapToSql(serdeParameters) + "\n");
            }
            if (fileFormat != null) {
                sb.append("STORED AS " + fileFormat.toSql(compression) + "\n");
            }
        } else {
            sb.append("STORED BY '" + storageHandlerClass + "'\n");
            if (serdeParameters != null && !serdeParameters.isEmpty()) {
                sb.append("WITH SERDEPROPERTIES " + ToSqlUtils.propertyMapToSql(serdeParameters) + "\n");
            }
        }
        TIcebergCatalog icebergCatalog = IcebergUtil.getTIcebergCatalog(tblProperties.get("iceberg.catalog"));
        boolean bl = isHadoopCatalog = fileFormat == HdfsFileFormat.ICEBERG && icebergCatalog == TIcebergCatalog.HADOOP_CATALOG;
        if (location != null && !isHadoopCatalog) {
            sb.append("LOCATION '" + location.toString() + "'\n");
        }
        if (tblProperties != null && !tblProperties.isEmpty()) {
            sb.append("TBLPROPERTIES " + ToSqlUtils.propertyMapToSql(tblProperties));
        }
        return sb.toString();
    }

    public static String getCreateFunctionSql(List<Function> functions) {
        Preconditions.checkNotNull(functions);
        StringBuilder sb = new StringBuilder();
        for (Function fn : functions) {
            if (sb.length() > 0) {
                sb.append(";\n");
            }
            sb.append(fn.toSql(false));
        }
        return sb.append("\n").toString();
    }

    public static String getCreateViewSql(FeView view) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE VIEW ");
        sb.append(view.getTableName().toSql());
        sb.append(" AS\n");
        sb.append(view.getQueryStmt().toSql());
        return sb.toString();
    }

    private static String encodeColumnName(String name) {
        if (ToSqlUtils.impalaNeedsQuotes(name)) {
            return String.format("`%s`", name);
        }
        return name;
    }

    private static String columnToSql(Column col) {
        IcebergColumn icebergCol;
        Boolean isNullable;
        StringBuilder sb = new StringBuilder(ToSqlUtils.encodeColumnName(col.getName()));
        if (col.getType() != null) {
            sb.append(" " + col.getType().toSql());
        }
        if (col instanceof KuduColumn) {
            KuduColumn kuduCol = (KuduColumn)col;
            Boolean isNullable2 = kuduCol.isNullable();
            if (isNullable2 != null) {
                sb.append(isNullable2 != false ? " NULL" : " NOT NULL");
            }
            if (kuduCol.getEncoding() != null) {
                sb.append(" ENCODING " + kuduCol.getEncoding());
            }
            if (kuduCol.getCompression() != null) {
                sb.append(" COMPRESSION " + kuduCol.getCompression());
            }
            if (kuduCol.hasDefaultValue()) {
                sb.append(" DEFAULT " + kuduCol.getDefaultValueSql());
            }
            if (kuduCol.getBlockSize() != 0) {
                sb.append(String.format(" BLOCK_SIZE %d", kuduCol.getBlockSize()));
            }
        } else if (col instanceof IcebergColumn && (isNullable = Boolean.valueOf((icebergCol = (IcebergColumn)col).isNullable())) != null) {
            sb.append(isNullable != false ? " NULL" : " NOT NULL");
        }
        if (!Strings.isNullOrEmpty((String)col.getComment())) {
            sb.append(String.format(" COMMENT '%s'", col.getComment()));
        }
        return sb.toString();
    }

    public static String propertyMapToSql(Map<String, String> propertyMap) {
        ArrayList mapEntries = Lists.newArrayList(propertyMap.entrySet());
        Collections.sort(mapEntries, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return ObjectUtils.compare((Comparable)((Comparable)((Object)o1.getKey())), (Comparable)((Comparable)((Object)o2.getKey())));
            }
        });
        ArrayList<String> properties = new ArrayList<String>();
        for (Map.Entry entry : mapEntries) {
            properties.add(String.format("'%s'='%s'", entry.getKey(), StringEscapeUtils.escapeJava((String)((String)entry.getValue()))));
        }
        return "(" + Joiner.on((String)", ").join(properties) + ")";
    }

    public static String getPlanHintsSql(ToSqlOptions options, List<PlanHint> hints) {
        Preconditions.checkNotNull(hints);
        if (hints.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (options.showRewritten()) {
            sb.append("/* +");
            sb.append(Joiner.on((String)",").join(hints));
            sb.append(" */");
        } else {
            sb.append("\n-- +");
            sb.append(Joiner.on((String)",").join(hints));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String formatAlias(String alias) {
        if (alias == null) {
            return "";
        }
        return " " + ToSqlUtils.getIdentSql(alias);
    }
}

