/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ArithmeticExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Function;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;

public class TimestampArithmeticExpr
extends Expr {
    private static Map<String, TimeUnit> TIME_UNITS_MAP = new HashMap<String, TimeUnit>();
    private final String funcName_;
    private ArithmeticExpr.Operator op_;
    private final String timeUnitIdent_;
    private TimeUnit timeUnit_;
    private final boolean intervalFirst_;

    public TimestampArithmeticExpr(String funcName, Expr e1, Expr e2, String timeUnitIdent) {
        this.funcName_ = funcName.toLowerCase();
        this.timeUnitIdent_ = timeUnitIdent;
        this.intervalFirst_ = false;
        this.children_.add(e1);
        this.children_.add(e2);
    }

    public TimestampArithmeticExpr(ArithmeticExpr.Operator op, Expr e1, Expr e2, String timeUnitIdent, boolean intervalFirst) {
        Preconditions.checkState((op == ArithmeticExpr.Operator.ADD || op == ArithmeticExpr.Operator.SUBTRACT ? 1 : 0) != 0);
        this.funcName_ = null;
        this.op_ = op;
        this.timeUnitIdent_ = timeUnitIdent;
        this.intervalFirst_ = intervalFirst;
        this.children_.add(e1);
        this.children_.add(e2);
    }

    protected TimestampArithmeticExpr(TimestampArithmeticExpr other) {
        super(other);
        this.funcName_ = other.funcName_;
        this.op_ = other.op_;
        this.timeUnitIdent_ = other.timeUnitIdent_;
        this.timeUnit_ = other.timeUnit_;
        this.intervalFirst_ = other.intervalFirst_;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        if (this.funcName_ != null) {
            if (this.funcName_.equals("date_add")) {
                this.op_ = ArithmeticExpr.Operator.ADD;
            } else if (this.funcName_.equals("date_sub")) {
                this.op_ = ArithmeticExpr.Operator.SUBTRACT;
            } else {
                throw new AnalysisException("Encountered function name '" + this.funcName_ + "' in timestamp/date arithmetic expression '" + this.toSql() + "'. Expected function name 'DATE_ADD' or 'DATE_SUB'.");
            }
        }
        this.timeUnit_ = TIME_UNITS_MAP.get(this.timeUnitIdent_.toUpperCase());
        if (this.timeUnit_ == null) {
            throw new AnalysisException("Invalid time unit '" + this.timeUnitIdent_ + "' in timestamp/date arithmetic expression '" + this.toSql() + "'.");
        }
        if (!(((Expr)this.getChild(0)).getType().isTimestamp() || ((Expr)this.getChild(0)).getType().isDate() || ((Expr)this.getChild(0)).getType().isNull())) {
            throw new AnalysisException("Operand '" + ((Expr)this.getChild(0)).toSql() + "' of timestamp/date arithmetic expression '" + this.toSql() + "' returns type '" + ((Expr)this.getChild(0)).getType().toSql() + "'. Expected type 'TIMESTAMP' or 'DATE'.");
        }
        if (((Expr)this.getChild(0)).getType().isDate() && this.timeUnit_ != TimeUnit.YEAR && this.timeUnit_ != TimeUnit.MONTH && this.timeUnit_ != TimeUnit.WEEK && this.timeUnit_ != TimeUnit.DAY) {
            throw new AnalysisException("'" + (Object)((Object)this.timeUnit_) + "' intervals are not allowed in date arithmetic expressions");
        }
        if (!((Expr)this.getChild(1)).getType().isIntegerType() && !((Expr)this.getChild(1)).getType().isNull()) {
            throw new AnalysisException("Operand '" + ((Expr)this.getChild(1)).toSql() + "' of timestamp/date arithmetic expression '" + this.toSql() + "' returns type '" + ((Expr)this.getChild(1)).getType().toSql() + "'. Expected an integer type.");
        }
        String funcOpName = String.format("%sS_%s", new Object[]{this.timeUnit_, this.op_ == ArithmeticExpr.Operator.ADD ? "ADD" : "SUB"});
        if (this.timeUnit_ == TimeUnit.MONTH) {
            funcOpName = funcOpName + "_INTERVAL";
        }
        this.fn_ = this.getBuiltinFunction(analyzer, funcOpName.toLowerCase(), this.collectChildReturnTypes(), Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        this.castForFunctionCall(false, analyzer.getRegularCompatibilityLevel());
        Preconditions.checkNotNull((Object)this.fn_);
        Preconditions.checkState((this.fn_.getReturnType().isTimestamp() || this.fn_.getReturnType().isDate() ? 1 : 0) != 0);
        this.type_ = this.fn_.getReturnType();
    }

    @Override
    protected float computeEvalCost() {
        return this.hasChildCosts() ? this.getChildCosts() + 5.0f : -1.0f;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.FUNCTION_CALL;
    }

    public String getTimeUnitIdent() {
        return this.timeUnitIdent_;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit_;
    }

    public ArithmeticExpr.Operator getOp() {
        return this.op_;
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        StringBuilder strBuilder = new StringBuilder();
        if (this.funcName_ != null) {
            strBuilder.append(this.funcName_.toUpperCase() + "(");
            strBuilder.append(((Expr)this.getChild(0)).toSql(options) + ", ");
            strBuilder.append("INTERVAL ");
            strBuilder.append(((Expr)this.getChild(1)).toSql(options));
            strBuilder.append(" " + this.timeUnitIdent_);
            strBuilder.append(")");
            return strBuilder.toString();
        }
        if (this.intervalFirst_) {
            strBuilder.append("INTERVAL ");
            strBuilder.append(((Expr)this.getChild(1)).toSql(options) + " ");
            strBuilder.append(this.timeUnitIdent_);
            strBuilder.append(" " + this.op_.toString() + " ");
            strBuilder.append(((Expr)this.getChild(0)).toSql(options));
        } else {
            strBuilder.append(((Expr)this.getChild(0)).toSql(options));
            strBuilder.append(" " + this.op_.toString() + " ");
            strBuilder.append("INTERVAL ");
            strBuilder.append(((Expr)this.getChild(1)).toSql(options) + " ");
            strBuilder.append(this.timeUnitIdent_);
        }
        return strBuilder.toString();
    }

    @Override
    public Expr clone() {
        return new TimestampArithmeticExpr(this);
    }

    static {
        for (TimeUnit timeUnit : TimeUnit.values()) {
            TIME_UNITS_MAP.put(timeUnit.toString(), timeUnit);
            TIME_UNITS_MAP.put(timeUnit.toString() + "S", timeUnit);
        }
    }

    public static enum TimeUnit {
        YEAR("YEAR"),
        MONTH("MONTH"),
        WEEK("WEEK"),
        DAY("DAY"),
        HOUR("HOUR"),
        MINUTE("MINUTE"),
        SECOND("SECOND"),
        MILLISECOND("MILLISECOND"),
        MICROSECOND("MICROSECOND"),
        NANOSECOND("NANOSECOND");

        private final String description_;

        private TimeUnit(String description) {
            this.description_ = description;
        }

        public String toString() {
            return this.description_;
        }
    }
}

