/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.common.AnalysisException;

public class TableSampleClause
extends StmtNode {
    private final long percentBytes_;
    private final Long randomSeed_;

    public TableSampleClause(long percentBytes, Long randomSeed) {
        this.percentBytes_ = percentBytes;
        this.randomSeed_ = randomSeed;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.percentBytes_ < 0L || this.percentBytes_ > 100L) {
            throw new AnalysisException(String.format("Invalid percent of bytes value '%s'. The percent of bytes to sample must be between 0 and 100.", this.percentBytes_));
        }
    }

    public long getPercentBytes() {
        return this.percentBytes_;
    }

    public boolean hasRandomSeed() {
        return this.randomSeed_ != null;
    }

    public long getRandomSeed() {
        Preconditions.checkState((boolean)this.hasRandomSeed());
        return this.randomSeed_;
    }

    public TableSampleClause clone() {
        return new TableSampleClause(this.percentBytes_, this.randomSeed_);
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return this.toSql(this.randomSeed_);
    }

    public String toSql(Long randomSeed) {
        StringBuilder builder = new StringBuilder();
        builder.append("TABLESAMPLE SYSTEM(" + this.percentBytes_ + ")");
        if (randomSeed != null) {
            builder.append(" REPEATABLE(" + randomSeed + ")");
        }
        return builder.toString();
    }
}

