/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.IcebergPartitionSpec;
import org.apache.impala.analysis.KuduPartitionParam;

class TableDataLayout {
    private final List<ColumnDef> partitionColDefs_;
    private final List<KuduPartitionParam> kuduPartitionParams_;
    private final List<IcebergPartitionSpec> icebergPartitionSpecs_;

    private TableDataLayout(List<ColumnDef> partitionColumnDefs, List<KuduPartitionParam> partitionParams, List<IcebergPartitionSpec> icebergPartitionSpecs) {
        this.partitionColDefs_ = partitionColumnDefs;
        this.kuduPartitionParams_ = partitionParams;
        this.icebergPartitionSpecs_ = icebergPartitionSpecs;
    }

    static TableDataLayout createPartitionedLayout(List<ColumnDef> partitionColumnDefs) {
        return new TableDataLayout(partitionColumnDefs, new ArrayList<KuduPartitionParam>(), new ArrayList<IcebergPartitionSpec>());
    }

    static TableDataLayout createKuduPartitionedLayout(List<KuduPartitionParam> partitionParams) {
        return new TableDataLayout(new ArrayList<ColumnDef>(), partitionParams, new ArrayList<IcebergPartitionSpec>());
    }

    static TableDataLayout createIcebergPartitionedLayout(List<IcebergPartitionSpec> icebergPartitionSpecs) {
        return new TableDataLayout(new ArrayList<ColumnDef>(), new ArrayList<KuduPartitionParam>(), icebergPartitionSpecs);
    }

    static TableDataLayout createEmptyLayout() {
        return new TableDataLayout(new ArrayList<ColumnDef>(), new ArrayList<KuduPartitionParam>(), new ArrayList<IcebergPartitionSpec>());
    }

    List<ColumnDef> getPartitionColumnDefs() {
        return this.partitionColDefs_;
    }

    List<KuduPartitionParam> getKuduPartitionParams() {
        return this.kuduPartitionParams_;
    }

    List<IcebergPartitionSpec> getIcebergPartitionSpecs() {
        return this.icebergPartitionSpecs_;
    }
}

