/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.thrift.TExprNode;

public class Subquery
extends Expr {
    protected QueryStmt stmt_;
    protected Analyzer analyzer_;

    public Analyzer getAnalyzer() {
        return this.analyzer_;
    }

    public QueryStmt getStatement() {
        return this.stmt_;
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        return "(" + this.stmt_.toSql(options) + ")";
    }

    public Subquery(QueryStmt queryStmt) {
        Preconditions.checkNotNull((Object)queryStmt);
        this.stmt_ = queryStmt;
    }

    public Subquery(Subquery other) {
        super(other);
        this.stmt_ = other.stmt_.clone();
        this.analyzer_ = other.analyzer_;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        if (!(this.stmt_ instanceof SelectStmt)) {
            throw new AnalysisException("A subquery must contain a single select block: " + this.toSql());
        }
        this.analyzer_ = new Analyzer(analyzer);
        this.analyzer_.setIsSubquery();
        this.stmt_.analyze(this.analyzer_);
        this.stmt_.getCorrelatedTupleIds();
        List<Expr> stmtResultExprs = this.stmt_.getResultExprs();
        if (stmtResultExprs.size() == 1) {
            this.type_ = stmtResultExprs.get(0).getType();
            if (this.type_.isComplexType()) {
                throw new AnalysisException("A subquery can't return complex types. " + this.toSql());
            }
        } else {
            this.type_ = this.createStructTypeFromExprList();
        }
        if (!((SelectStmt)this.stmt_).returnsAtMostOneRow()) {
            this.stmt_.setIsRuntimeScalar(true);
        }
        Preconditions.checkNotNull((Object)this.type_);
    }

    @Override
    protected float computeEvalCost() {
        return -1.0f;
    }

    @Override
    protected boolean isConstantImpl() {
        return false;
    }

    public boolean returnsScalarColumn() {
        List<Expr> stmtResultExprs = this.stmt_.getResultExprs();
        return stmtResultExprs.size() == 1 && stmtResultExprs.get(0).getType().isScalarType();
    }

    private StructType createStructTypeFromExprList() {
        List<Expr> stmtResultExprs = this.stmt_.getResultExprs();
        ArrayList<StructField> structFields = new ArrayList<StructField>();
        List<String> labels = this.stmt_.getColLabels();
        boolean hasUniqueLabels = true;
        if (Sets.newHashSet(labels).size() != labels.size()) {
            hasUniqueLabels = false;
        }
        for (int i = 0; i < stmtResultExprs.size(); ++i) {
            Expr expr = stmtResultExprs.get(i);
            String fieldName = null;
            if (MetastoreShim.validateName(labels.get(i))) {
                fieldName = labels.get(i);
                if (!hasUniqueLabels) {
                    fieldName = "_" + Integer.toString(i) + "_" + fieldName;
                }
            } else {
                fieldName = "_" + Integer.toString(i);
            }
            Preconditions.checkNotNull((Object)fieldName);
            structFields.add(new StructField(fieldName, expr.getType(), null));
        }
        Preconditions.checkState((structFields.size() != 0 ? 1 : 0) != 0);
        return new StructType(structFields);
    }

    @Override
    protected boolean localEquals(Expr that) {
        return super.localEquals(that) && this.stmt_.toSql().equals(((Subquery)that).stmt_.toSql());
    }

    @Override
    protected int localHash() {
        return Objects.hash(super.localHash(), this.stmt_.toSql());
    }

    @Override
    public Subquery clone() {
        return new Subquery(this);
    }

    @Override
    protected void toThrift(TExprNode msg) {
    }

    @Override
    public boolean resolveTableMask(Analyzer analyzer) throws AnalysisException {
        return this.stmt_.resolveTableMask(analyzer);
    }

    @Override
    protected void resetAnalysisState() {
        super.resetAnalysisState();
        this.stmt_.reset();
        this.analyzer_ = null;
    }
}

