/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java_cup.runtime.Symbol;
import org.apache.commons.codec.binary.Hex;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.SqlScanner;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;
import org.apache.impala.thrift.TStringLiteral;
import org.apache.impala.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringLiteral
extends LiteralExpr {
    private static final Logger LOG = LoggerFactory.getLogger(StringLiteral.class);
    private final String strValue_;
    private final byte[] binValue_;
    public static int MAX_STRING_LEN = Integer.MAX_VALUE;
    private final boolean needsUnescaping_;

    public StringLiteral(String value) {
        this(value, ScalarType.STRING, true);
    }

    public StringLiteral(String value, Type type, boolean needsUnescaping) {
        this.strValue_ = value;
        this.binValue_ = null;
        this.type_ = type;
        this.needsUnescaping_ = needsUnescaping;
    }

    public StringLiteral(byte[] value, Type type) {
        this.strValue_ = StringUtils.fromUtf8Buffer(ByteBuffer.wrap(value), true);
        this.binValue_ = (byte[])(this.strValue_ == null ? value : null);
        this.type_ = type;
        this.needsUnescaping_ = false;
    }

    protected StringLiteral(StringLiteral other) {
        super(other);
        this.strValue_ = other.strValue_;
        this.binValue_ = other.binValue_;
        this.needsUnescaping_ = other.needsUnescaping_;
    }

    @Override
    protected boolean localEquals(Expr that) {
        if (!super.localEquals(that)) {
            return false;
        }
        StringLiteral other = (StringLiteral)that;
        if (!this.type_.equals(other.type_)) {
            return false;
        }
        if (this.needsUnescaping_ != other.needsUnescaping_) {
            return false;
        }
        if (this.binValue_ != null) {
            Preconditions.checkState((this.strValue_ == null ? 1 : 0) != 0);
            if (other.binValue_ == null) {
                return false;
            }
            return Arrays.equals(this.binValue_, other.binValue_);
        }
        Preconditions.checkState((this.strValue_ != null ? 1 : 0) != 0);
        return this.strValue_.equals(other.strValue_);
    }

    @Override
    public int hashCode() {
        return this.binValue_ != null ? Arrays.hashCode(this.binValue_) : this.strValue_.hashCode();
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        return "'" + this.getNormalizedValue() + "'";
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.STRING_LITERAL;
        byte[] val = this.needsUnescaping_ ? StringUtils.toUtf8Array(this.getUnescapedValue()) : this.getBinValue();
        msg.string_literal = new TStringLiteral(ByteBuffer.wrap(val));
    }

    public String getValueWithOriginalEscapes() {
        this.checkHasValidString();
        return this.strValue_;
    }

    public String getUnescapedValue() {
        this.checkHasValidString();
        return MetastoreShim.unescapeSQLString("'" + this.getNormalizedValue() + "'");
    }

    private String unescapeIfNeeded() {
        this.checkHasValidString();
        return this.needsUnescaping_ ? this.getUnescapedValue() : this.strValue_;
    }

    private String getNormalizedValue() {
        if (this.strValue_ == null) {
            String hex = Hex.encodeHexString((byte[])this.binValue_);
            return "unhex(\"" + hex.toUpperCase() + "\")";
        }
        int len = this.strValue_.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char currentChar = this.strValue_.charAt(i);
            if (currentChar == '\\' && i + 1 < len) {
                char nextChar = this.strValue_.charAt(i + 1);
                if (nextChar == '\"' || nextChar == '\'' || nextChar == '\\') {
                    if (nextChar != '\"') {
                        sb.append(currentChar);
                    }
                    sb.append(nextChar);
                    ++i;
                    continue;
                }
                sb.append(currentChar);
                continue;
            }
            if (currentChar == '\'') {
                sb.append("\\'");
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    @Override
    public String getStringValue() {
        return this.getValueWithOriginalEscapes();
    }

    @Override
    public String debugString() {
        String str = this.strValue_ != null ? this.strValue_ : "<can't encode as String>";
        return MoreObjects.toStringHelper((Object)this).add("strValue", (Object)str).toString();
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType, TypeCompatibility compatibility) throws AnalysisException {
        Preconditions.checkState((targetType.isNumericType() || targetType.isDateOrTimeType() || targetType.equals(this.type_) || targetType.isStringType() ? 1 : 0) != 0);
        if (targetType.equals(this.type_)) {
            return this;
        }
        if (targetType.isStringType()) {
            this.type_ = targetType;
        } else {
            if (targetType.isNumericType()) {
                return this.convertToNumber(targetType);
            }
            if (targetType.isDateOrTimeType()) {
                return new CastExpr(targetType, (Expr)this, compatibility);
            }
        }
        return this;
    }

    public LiteralExpr convertToNumber(Type targetType) throws AnalysisException {
        Symbol sym;
        this.checkHasValidString();
        StringReader reader = new StringReader(this.strValue_);
        SqlScanner scanner = new SqlScanner(reader);
        boolean negative = false;
        try {
            sym = scanner.next_token();
            while (sym.sym == 255) {
                negative = !negative;
                sym = scanner.next_token();
            }
        }
        catch (IOException e) {
            throw new AnalysisException("Failed to convert string literal to number.", e);
        }
        if (sym.sym == 271) {
            throw new AnalysisException("Number too large: " + this.strValue_);
        }
        if (sym.sym == 272) {
            BigDecimal val = (BigDecimal)sym.value;
            if (negative) {
                val = val.negate();
            }
            return new NumericLiteral(val, targetType);
        }
        if (sym.sym == 273) {
            BigDecimal val = (BigDecimal)sym.value;
            if (negative) {
                val = val.negate();
            }
            return new NumericLiteral(val, targetType);
        }
        throw new AnalysisException("Failed to convert string literal '" + this.strValue_ + "' to number.");
    }

    @Override
    public int compareTo(LiteralExpr o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        StringLiteral other = (StringLiteral)o;
        byte[] arr1 = this.getBinValue();
        byte[] arr2 = other.getBinValue();
        for (int i = 0; i < arr1.length && i < arr2.length; ++i) {
            if (arr1[i] < arr2[i]) {
                return -1;
            }
            if (arr1[i] <= arr2[i]) continue;
            return 1;
        }
        if (arr1.length < arr2.length) {
            return -1;
        }
        if (arr1.length > arr2.length) {
            return 1;
        }
        return 0;
    }

    @Override
    public Expr clone() {
        return new StringLiteral(this);
    }

    public int utf8ArrayLength() {
        return this.getBinValue().length;
    }

    public boolean isValidUtf8() {
        return this.binValue_ == null;
    }

    public byte[] getBinValue() {
        if (this.binValue_ != null) {
            return this.binValue_;
        }
        return StringUtils.toUtf8Array(this.unescapeIfNeeded());
    }

    private void checkHasValidString() {
        Preconditions.checkState((this.strValue_ != null ? 1 : 0) != 0, (String)"non-utf8 string: %s", (Object)this.getNormalizedValue());
    }
}

