/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.CollectionTableRef;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.CopyTestCaseStmt;
import org.apache.impala.analysis.CreateTableAsSelectStmt;
import org.apache.impala.analysis.DeleteStmt;
import org.apache.impala.analysis.ExistsPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FromClause;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.InPredicate;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.InsertStmt;
import org.apache.impala.analysis.IsNullPredicate;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.analysis.LikePredicate;
import org.apache.impala.analysis.LimitElement;
import org.apache.impala.analysis.MergeStmt;
import org.apache.impala.analysis.OrderByElement;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SelectList;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SetOperationStmt;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TableSampleClause;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.analysis.UnionStmt;
import org.apache.impala.analysis.UpdateStmt;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.TableAliasGenerator;
import org.apache.impala.util.AcidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StmtRewriter {
    private static final Logger LOG = LoggerFactory.getLogger(StmtRewriter.class);

    public void rewrite(StatementBase stmt) throws AnalysisException {
        QueryStmt queryStmt;
        Preconditions.checkState((boolean)stmt.isAnalyzed());
        if (stmt instanceof QueryStmt) {
            queryStmt = (QueryStmt)stmt;
        } else if (stmt instanceof InsertStmt) {
            queryStmt = ((InsertStmt)stmt).getQueryStmt();
        } else if (stmt instanceof CreateTableAsSelectStmt) {
            queryStmt = ((CreateTableAsSelectStmt)stmt).getQueryStmt();
        } else if (stmt instanceof UpdateStmt) {
            queryStmt = ((UpdateStmt)stmt).getQueryStmt();
        } else if (stmt instanceof DeleteStmt) {
            queryStmt = ((DeleteStmt)stmt).getQueryStmt();
        } else if (stmt instanceof MergeStmt) {
            queryStmt = ((MergeStmt)stmt).getQueryStmt();
        } else if (stmt instanceof CopyTestCaseStmt) {
            queryStmt = ((CopyTestCaseStmt)stmt).getQueryStmt();
        } else {
            throw new AnalysisException("Unsupported statement: " + stmt.toSql());
        }
        this.rewriteQueryStatement(queryStmt, queryStmt.getAnalyzer());
    }

    protected void rewriteQueryStatement(QueryStmt stmt, Analyzer analyzer) throws AnalysisException {
        Preconditions.checkNotNull((Object)stmt);
        Preconditions.checkState((boolean)stmt.isAnalyzed());
        if (stmt instanceof SelectStmt) {
            this.rewriteSelectStatement((SelectStmt)stmt, analyzer);
        } else if (stmt instanceof SetOperationStmt) {
            this.rewriteSetOperationStatement((SetOperationStmt)stmt, analyzer);
        } else {
            throw new AnalysisException("Subqueries not supported for " + stmt.getClass().getSimpleName() + " statements");
        }
    }

    protected void rewriteSelectStatement(SelectStmt stmt, Analyzer analyzer) throws AnalysisException {
        for (TableRef tblRef : stmt.fromClause_) {
            if (!(tblRef instanceof InlineViewRef)) continue;
            InlineViewRef inlineViewRef = (InlineViewRef)tblRef;
            this.rewriteQueryStatement(inlineViewRef.getViewStmt(), inlineViewRef.getAnalyzer());
            if (!(inlineViewRef.getViewStmt() instanceof SetOperationStmt) || inlineViewRef.getViewStmt() instanceof UnionStmt) continue;
            inlineViewRef.queryStmt_ = ((SetOperationStmt)inlineViewRef.getViewStmt()).getRewrittenStmt();
            Preconditions.checkState((inlineViewRef.queryStmt_ != null ? 1 : 0) != 0);
        }
        this.rewriteSelectStmtHook(stmt, analyzer);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Rewritten SQL: " + stmt.toSql(ToSqlOptions.REWRITTEN));
        }
    }

    private static Expr getSetOpJoinPredicates(InlineViewRef left, InlineViewRef right, SetOperationStmt.SetOperator operator) {
        Preconditions.checkState((left.getColLabels().size() == right.getColLabels().size() ? 1 : 0) != 0);
        Preconditions.checkState((operator == SetOperationStmt.SetOperator.EXCEPT || operator == SetOperationStmt.SetOperator.INTERSECT ? 1 : 0) != 0);
        BinaryPredicate.Operator eqOp = BinaryPredicate.Operator.NOT_DISTINCT;
        ArrayList conjuncts = Lists.newArrayListWithCapacity((int)left.getColLabels().size());
        for (int i = 0; i < left.getColLabels().size(); ++i) {
            conjuncts.add(new BinaryPredicate(eqOp, new SlotRef(Path.createRawPath(left.getUniqueAlias(), left.getColLabels().get(i))), new SlotRef(Path.createRawPath(right.getUniqueAlias(), right.getColLabels().get(i)))));
        }
        return CompoundPredicate.createConjunctivePredicate(conjuncts);
    }

    private void rewriteSetOperationStatement(SetOperationStmt stmt, Analyzer analyzer) throws AnalysisException {
        SetOperationStmt setOpStmt;
        if (stmt instanceof UnionStmt) {
            for (SetOperationStmt.SetOperand operand : stmt.getOperands()) {
                SetOperationStmt setOpStmt2;
                this.rewriteQueryStatement(operand.getQueryStmt(), operand.getAnalyzer());
                if (!(operand.getQueryStmt() instanceof SetOperationStmt) || operand.getQueryStmt() instanceof UnionStmt || !(setOpStmt2 = (SetOperationStmt)operand.getQueryStmt()).hasRewrittenStmt()) continue;
                QueryStmt rewrittenStmt = setOpStmt2.getRewrittenStmt();
                operand.setQueryStmt(rewrittenStmt);
            }
            return;
        }
        TableAliasGenerator tableAliasGenerator = new TableAliasGenerator(analyzer, null);
        SelectStmt uSelect = null;
        SelectStmt eiSelect = null;
        SetOperationStmt unionStmt = null;
        SetOperationStmt.SetOperand firstOperand = stmt.getOperands().get(0);
        this.rewriteQueryStatement(firstOperand.getQueryStmt(), firstOperand.getAnalyzer());
        if (firstOperand.getQueryStmt() instanceof SetOperationStmt && (setOpStmt = (SetOperationStmt)firstOperand.getQueryStmt()).hasRewrittenStmt()) {
            firstOperand.setQueryStmt(setOpStmt.getRewrittenStmt());
        }
        block5: for (int i = 1; i < stmt.getOperands().size(); ++i) {
            SetOperationStmt setOpStmt3;
            SetOperationStmt.SetOperand operand = stmt.getOperands().get(i);
            this.rewriteQueryStatement(operand.getQueryStmt(), operand.getAnalyzer());
            if (operand.getQueryStmt() instanceof SetOperationStmt && (setOpStmt3 = (SetOperationStmt)operand.getQueryStmt()).hasRewrittenStmt()) {
                operand.setQueryStmt(setOpStmt3.getRewrittenStmt());
            }
            switch (operand.getSetOperator()) {
                case EXCEPT: 
                case INTERSECT: {
                    QueryStmt outer;
                    SelectStmt inner;
                    if (eiSelect == null) {
                        InlineViewRef leftMostView = null;
                        SelectList sl = new SelectList(Lists.newArrayList((Object[])new SelectListItem[]{SelectListItem.createStarItem(null)}));
                        sl.setIsDistinct(true);
                        eiSelect = new SelectStmt(sl, null, null, null, null, null, null);
                        if (i == 1) {
                            if (firstOperand.getQueryStmt() instanceof SelectStmt) {
                                SelectStmt firstOpStmt = (SelectStmt)firstOperand.getQueryStmt();
                                if (firstOpStmt.getSelectList().isDistinct()) {
                                    sl.setIsDistinct(false);
                                } else if (firstOpStmt.getTableRefs().size() > 0 && !firstOpStmt.hasAnalyticInfo()) {
                                    if (!firstOpStmt.hasMultiAggInfo()) {
                                        firstOpStmt.getSelectList().setIsDistinct(true);
                                    }
                                    sl.setIsDistinct(false);
                                }
                            }
                            leftMostView = new InlineViewRef(tableAliasGenerator.getNextAlias(), firstOperand.getQueryStmt(), (TableSampleClause)null);
                            leftMostView.analyze(analyzer);
                            eiSelect.getTableRefs().add(leftMostView);
                        }
                        if (uSelect != null) {
                            Preconditions.checkState((i != 1 ? 1 : 0) != 0);
                            if (uSelect.getSelectList().isDistinct() && eiSelect.getTableRefs().size() == 0) {
                                sl.setIsDistinct(false);
                            }
                            leftMostView = new InlineViewRef(tableAliasGenerator.getNextAlias(), (QueryStmt)uSelect, (TableSampleClause)null);
                            leftMostView.analyze(analyzer);
                            eiSelect.getTableRefs().add(leftMostView);
                            uSelect = null;
                        }
                    }
                    JoinOperator joinOp = operand.getSetOperator() == SetOperationStmt.SetOperator.EXCEPT ? JoinOperator.LEFT_ANTI_JOIN : JoinOperator.LEFT_SEMI_JOIN;
                    TableRef rightMostTbl = eiSelect.getTableRefs().get(eiSelect.getTableRefs().size() - 1);
                    if (operand.getQueryStmt() instanceof SelectStmt && (inner = (SelectStmt)operand.getQueryStmt()).getSelectList().isDistinct() && rightMostTbl instanceof InlineViewRef && (outer = ((InlineViewRef)rightMostTbl).getViewStmt()) instanceof SelectStmt && ((SelectStmt)outer).getSelectList().isDistinct() && operand.getSetOperator() == SetOperationStmt.SetOperator.INTERSECT) {
                        joinOp = JoinOperator.INNER_JOIN;
                        TableRef firstTbl = eiSelect.getTableRefs().get(0);
                        eiSelect.getSelectList().getItems().set(0, SelectListItem.createStarItem(Lists.newArrayList((Object[])new String[]{firstTbl.getUniqueAlias()})));
                    }
                    ArrayList<String> colLabels = new ArrayList<String>();
                    for (int j = 0; j < operand.getQueryStmt().getColLabels().size(); ++j) {
                        colLabels.add(eiSelect.getColumnAliasGenerator().getNextAlias());
                    }
                    InlineViewRef opWrapperView = new InlineViewRef(tableAliasGenerator.getNextAlias(), operand.getQueryStmt(), colLabels);
                    opWrapperView.setLeftTblRef(rightMostTbl);
                    opWrapperView.setJoinOp(joinOp);
                    opWrapperView.setOnClause(StmtRewriter.getSetOpJoinPredicates((InlineViewRef)eiSelect.getTableRefs().get(0), opWrapperView, operand.getSetOperator()));
                    opWrapperView.analyze(analyzer);
                    eiSelect.getTableRefs().add(opWrapperView);
                    continue block5;
                }
                case UNION: {
                    if (uSelect == null) {
                        unionStmt = null;
                        SelectList sl = new SelectList(Lists.newArrayList((Object[])new SelectListItem[]{SelectListItem.createStarItem(null)}));
                        uSelect = new SelectStmt(sl, null, null, null, null, null, null);
                        SetOperationStmt.SetOperand eiOperand = null;
                        if (eiSelect != null) {
                            eiOperand = new SetOperationStmt.SetOperand(eiSelect, null, null);
                            eiSelect = null;
                        }
                        ArrayList<SetOperationStmt.SetOperand> initialOps = new ArrayList<SetOperationStmt.SetOperand>();
                        if (i == 1) {
                            initialOps.add(firstOperand);
                            firstOperand = null;
                        }
                        if (eiOperand != null) {
                            initialOps.add(eiOperand);
                        }
                        unionStmt = new UnionStmt(initialOps, null, null);
                        uSelect.getTableRefs().add(new InlineViewRef(tableAliasGenerator.getNextAlias(), (QueryStmt)unionStmt, (TableSampleClause)null));
                    }
                    operand.reset();
                    unionStmt.getOperands().add(operand);
                    continue block5;
                }
                default: {
                    throw new AnalysisException("Unknown Set Operation Statement Operator Type");
                }
            }
        }
        SelectStmt newStmt = uSelect != null ? uSelect : eiSelect;
        Preconditions.checkNotNull(newStmt);
        newStmt.limitElement_ = stmt.limitElement_;
        newStmt.limitElement_.reset();
        if (stmt.hasOrderByClause()) {
            newStmt.orderByElements_ = stmt.cloneOrderByElements();
            if (newStmt.orderByElements_ != null) {
                for (OrderByElement o : newStmt.orderByElements_) {
                    o.getExpr().reset();
                }
            }
        }
        newStmt.analyze(analyzer);
        stmt.rewrittenStmt_ = newStmt;
    }

    protected void rewriteSelectStmtHook(SelectStmt stmt, Analyzer analyzer) throws AnalysisException {
    }

    static class ZippingUnnestRewriter
    extends StmtRewriter {
        ZippingUnnestRewriter() {
        }

        @Override
        protected void rewriteSelectStmtHook(SelectStmt stmt, Analyzer analyzer) throws AnalysisException {
            Set<CollectionTableRef> unnestTableRefs = analyzer.getTableRefsFromUnnestExpr();
            Preconditions.checkState((stmt.getResultExprs().size() >= unnestTableRefs.size() ? 1 : 0) != 0);
            for (TableRef tableRef : unnestTableRefs) {
                stmt.fromClause_.add(tableRef);
            }
        }
    }

    static class AcidRewriter
    extends StmtRewriter {
        AcidRewriter() {
        }

        @Override
        protected void rewriteSelectStmtHook(SelectStmt stmt, Analyzer analyzer) throws AnalysisException {
            for (int i = 0; i < stmt.fromClause_.size(); ++i) {
                CollectionTableRef collRef;
                TableRef tblRef = stmt.fromClause_.get(i);
                if (!(tblRef instanceof CollectionTableRef) || !AcidUtils.isFullAcidTable(tblRef.getTable().getMetaStoreTable().getParameters()) || (collRef = (CollectionTableRef)tblRef).getCollectionExpr() != null) continue;
                this.splitCollectionRef(analyzer, stmt, i);
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Rewritten ACID FROM Clause SQL: " + stmt.toSql(ToSqlOptions.REWRITTEN));
            }
        }

        private void splitCollectionRef(Analyzer analyzer, SelectStmt stmt, int tableRefIdx) throws AnalysisException {
            String[] old_aliases;
            TableRef collTblRef = stmt.fromClause_.get(tableRefIdx);
            Preconditions.checkState((boolean)(collTblRef instanceof CollectionTableRef));
            TableName tblName = collTblRef.getTable().getTableName();
            List<String> rawTblPath = this.generatePathFrom(tblName);
            String alias = stmt.getTableAliasGenerator().getNextAlias();
            TableRef baseTblRef = TableRef.newTableRef(analyzer, rawTblPath, alias);
            ArrayList<String> newCollPath = new ArrayList<String>(collTblRef.getPath());
            if (((String)newCollPath.get(0)).equals(tblName.getDb())) {
                newCollPath.remove(0);
            }
            Preconditions.checkState((boolean)((String)newCollPath.get(0)).equals(tblName.getTbl()));
            newCollPath.remove(0);
            newCollPath.add(0, alias);
            for (String old_alias : old_aliases = collTblRef.getAliases()) {
                analyzer.removeAlias(old_alias);
            }
            TableRef newCollTblRef = TableRef.newTableRef(analyzer, newCollPath, old_aliases[old_aliases.length - 1]);
            newCollTblRef.setOnClause(collTblRef.getOnClause());
            newCollTblRef.setJoinHints(collTblRef.getJoinHints());
            newCollTblRef.setTableHints(collTblRef.getTableHints());
            stmt.fromClause_.set(tableRefIdx, newCollTblRef);
            stmt.fromClause_.add(tableRefIdx, baseTblRef);
            baseTblRef.setHidden(true);
        }

        private List<String> generatePathFrom(TableName tblName) {
            ArrayList<String> rawTblPath = new ArrayList<String>();
            if (tblName.getDb() != null) {
                rawTblPath.add(tblName.getDb());
            }
            rawTblPath.add(tblName.getTbl());
            return rawTblPath;
        }
    }

    static class SubqueryRewriter
    extends StmtRewriter {
        SubqueryRewriter() {
        }

        private static boolean hasSubqueryInDisjunction(Expr expr) {
            if (!(expr instanceof CompoundPredicate)) {
                return false;
            }
            if (Expr.IS_OR_PREDICATE.apply((Object)expr)) {
                return expr.contains(Subquery.class);
            }
            for (Expr child : expr.getChildren()) {
                if (!SubqueryRewriter.hasSubqueryInDisjunction(child)) continue;
                return true;
            }
            return false;
        }

        private static BoolLiteral replaceExistsPredicate(ExistsPredicate predicate) {
            Subquery subquery = predicate.getSubquery();
            Preconditions.checkNotNull((Object)subquery);
            SelectStmt subqueryStmt = (SelectStmt)subquery.getStatement();
            BoolLiteral boolLiteral = null;
            if (subqueryStmt.getAnalyzer().hasEmptyResultSet()) {
                boolLiteral = new BoolLiteral(predicate.isNotExists());
            } else if (subqueryStmt.hasMultiAggInfo() && subqueryStmt.getMultiAggInfo().hasAggregateExprs() && !subqueryStmt.hasAnalyticInfo() && subqueryStmt.getHavingPred() == null) {
                boolLiteral = new BoolLiteral(!predicate.isNotExists());
            }
            return boolLiteral;
        }

        private static Expr rewriteInConstant(SelectStmt outerBlock, InPredicate inPred) {
            Expr lhs = (Expr)inPred.getChild(0);
            Preconditions.checkArgument((boolean)lhs.isConstant());
            Expr rhs = (Expr)inPred.getChild(1);
            QueryStmt subquery = inPred.getSubquery().getStatement();
            Preconditions.checkState((boolean)(subquery instanceof SelectStmt));
            SelectStmt rhsQuery = (SelectStmt)subquery;
            if (!inPred.isNotIn()) {
                return null;
            }
            if (rhsQuery.returnsExactlyOneRow()) {
                return new BinaryPredicate(BinaryPredicate.Operator.NE, lhs, rhs);
            }
            Preconditions.checkState((rhsQuery.getResultExprs().size() == 1 ? 1 : 0) != 0);
            if (SubqueryRewriter.isCorrelated(rhsQuery)) {
                return null;
            }
            String wrapperTableAlias = outerBlock.getTableAliasGenerator().getNextAlias();
            String wrapperColumnAlias = outerBlock.getColumnAliasGenerator().getNextAlias();
            InlineViewRef wrapperView = new InlineViewRef(wrapperTableAlias, (QueryStmt)rhsQuery, Lists.newArrayList((Object[])new String[]{wrapperColumnAlias}));
            SlotRef wrapperResult = new SlotRef(Lists.newArrayList((Object[])new String[]{wrapperTableAlias, wrapperColumnAlias}));
            CompoundPredicate rewritePredicate = new CompoundPredicate(CompoundPredicate.Operator.OR, new IsNullPredicate(lhs, false), new CompoundPredicate(CompoundPredicate.Operator.OR, new IsNullPredicate(wrapperResult, false), new BinaryPredicate(BinaryPredicate.Operator.EQ, wrapperResult, lhs)));
            ArrayList<TableRef> fromList = new ArrayList<TableRef>();
            fromList.add(wrapperView);
            SelectStmt rewriteQuery = new SelectStmt(new SelectList(Lists.newArrayList((Object[])new SelectListItem[]{new SelectListItem(wrapperResult, null)})), new FromClause(fromList), rewritePredicate, null, null, null, null);
            Subquery newSubquery = new Subquery(rewriteQuery);
            rhsQuery.reset();
            return new ExistsPredicate(newSubquery, true);
        }

        private static boolean isCorrelated(SelectStmt subqueryStmt) {
            if (!subqueryStmt.hasWhereClause()) {
                return false;
            }
            return SubqueryRewriter.containsCorrelatedPredicate(subqueryStmt.getWhereClause(), subqueryStmt.getTableRefIds());
        }

        private static boolean mergeExpr(SelectStmt stmt, Expr expr, Analyzer analyzer) throws AnalysisException {
            Expr onClausePredicate;
            List<Expr> onClauseConjuncts;
            Preconditions.checkNotNull((Object)expr);
            Preconditions.checkNotNull((Object)analyzer);
            boolean updateSelectList = false;
            SelectStmt subqueryStmt = (SelectStmt)expr.getSubquery().getStatement();
            boolean isScalarSubquery = expr.getSubquery().isScalarSubquery();
            boolean isScalarColumn = expr.getSubquery().returnsScalarColumn();
            boolean isRuntimeScalar = subqueryStmt.isRuntimeScalar();
            boolean isDisjunctive = SubqueryRewriter.hasSubqueryInDisjunction(expr);
            ArrayList<String> colLabels = new ArrayList<String>();
            for (int i = 0; i < subqueryStmt.getColLabels().size(); ++i) {
                colLabels.add(subqueryStmt.getColumnAliasGenerator().getNextAlias());
            }
            InlineViewRef inlineView = new InlineViewRef(stmt.getTableAliasGenerator().getNextAlias(), (QueryStmt)subqueryStmt, colLabels);
            ArrayList<Expr> whereClauseConjuncts = null;
            ArrayList<Expr> whereClauseSmapLhs = null;
            ArrayList<Expr> whereClauseSmapRhs = null;
            if (isDisjunctive) {
                whereClauseConjuncts = new ArrayList<Expr>();
                whereClauseSmapLhs = new ArrayList<Expr>();
                whereClauseSmapRhs = new ArrayList<Expr>();
                expr = SubqueryRewriter.replaceSubqueryInDisjunct(expr, inlineView, subqueryStmt, whereClauseConjuncts, whereClauseSmapLhs, whereClauseSmapRhs);
            }
            if (!(onClauseConjuncts = SubqueryRewriter.extractCorrelatedPredicates(subqueryStmt)).isEmpty()) {
                SubqueryRewriter.validateCorrelatedSubqueryStmt(expr);
                subqueryStmt.limitElement_ = new LimitElement(null, null);
            }
            if (isRuntimeScalar) {
                subqueryStmt.setLimit(2L);
            }
            boolean updateGroupBy = isScalarSubquery || expr instanceof ExistsPredicate && !subqueryStmt.getSelectList().isDistinct() && subqueryStmt.hasMultiAggInfo();
            ArrayList<Expr> lhsExprs = new ArrayList<Expr>();
            ArrayList<Expr> rhsExprs = new ArrayList<Expr>();
            for (Expr conjunct : onClauseConjuncts) {
                SubqueryRewriter.updateInlineView(inlineView, conjunct, stmt.getTableRefIds(), lhsExprs, rhsExprs, updateGroupBy);
            }
            inlineView.reset();
            try {
                inlineView.analyze(analyzer);
            }
            catch (AnalysisException e) {
                if (isDisjunctive && subqueryStmt.hasAggregate(false)) {
                    throw new AnalysisException("Aggregate functions in subquery in disjunction not supported: " + subqueryStmt.toSql());
                }
                throw e;
            }
            inlineView.setLeftTblRef(stmt.fromClause_.get(stmt.fromClause_.size() - 1));
            stmt.fromClause_.add(inlineView);
            Expr joinConjunct = SubqueryRewriter.createJoinConjunct(expr, inlineView, analyzer, !onClauseConjuncts.isEmpty());
            JoinOperator joinOp = JoinOperator.LEFT_SEMI_JOIN;
            if (isDisjunctive) {
                for (Expr expr2 : whereClauseSmapRhs) {
                    expr2.analyze(analyzer);
                }
                ExprSubstitutionMap smap = new ExprSubstitutionMap(whereClauseSmapLhs, whereClauseSmapRhs);
                for (Expr pred : whereClauseConjuncts) {
                    pred = pred.substitute(smap, analyzer, false);
                    stmt.whereClause_ = CompoundPredicate.createConjunction(pred, stmt.whereClause_);
                }
                joinOp = JoinOperator.LEFT_OUTER_JOIN;
                updateSelectList = true;
                if (joinConjunct != null) {
                    onClauseConjuncts.add(joinConjunct);
                }
            } else if (joinConjunct != null) {
                SelectListItem firstItem = ((SelectStmt)inlineView.getViewStmt()).getSelectList().getItems().get(0);
                if (!onClauseConjuncts.isEmpty() && firstItem.getExpr() != null && firstItem.getExpr().contains(Expr.NON_NULL_EMPTY_AGG)) {
                    stmt.whereClause_ = CompoundPredicate.createConjunction(joinConjunct, stmt.whereClause_);
                    joinConjunct = null;
                    joinOp = JoinOperator.LEFT_OUTER_JOIN;
                    updateSelectList = true;
                }
                if (joinConjunct != null) {
                    onClauseConjuncts.add(joinConjunct);
                }
            }
            if (!onClauseConjuncts.isEmpty()) {
                SubqueryRewriter.validateCorrelatedPredicates(expr, inlineView, onClauseConjuncts);
            }
            if ((onClausePredicate = CompoundPredicate.createConjunctivePredicate(onClauseConjuncts)) == null) {
                Preconditions.checkState((boolean)(expr instanceof ExistsPredicate));
                ExistsPredicate existsPredicate = (ExistsPredicate)expr;
                if (existsPredicate.isNotExists()) {
                    inlineView.setJoinOp(JoinOperator.LEFT_ANTI_JOIN);
                } else {
                    inlineView.setJoinOp(JoinOperator.LEFT_SEMI_JOIN);
                }
                if (!inlineView.isCorrelated()) {
                    subqueryStmt.setLimit(1L);
                    inlineView.setOnClause(new BoolLiteral(true));
                }
                return false;
            }
            ExprSubstitutionMap exprSubstitutionMap = new ExprSubstitutionMap();
            Preconditions.checkState((lhsExprs.size() == rhsExprs.size() ? 1 : 0) != 0);
            for (int i = 0; i < lhsExprs.size(); ++i) {
                Expr lhsExpr = (Expr)lhsExprs.get(i);
                Expr rhsExpr = (Expr)rhsExprs.get(i);
                rhsExpr.analyze(analyzer);
                exprSubstitutionMap.put(lhsExpr, rhsExpr);
            }
            if (!(onClausePredicate = onClausePredicate.substitute(exprSubstitutionMap, analyzer, false)).isBoundByTupleIds(stmt.getTableRefIds())) {
                throw new AnalysisException("Unsupported correlated subquery: " + subqueryStmt.toSql());
            }
            boolean hasEqJoinPred = false;
            for (Expr conjunct : onClausePredicate.getConjuncts()) {
                BinaryPredicate.Operator operator;
                if (!(conjunct instanceof BinaryPredicate) || !(operator = ((BinaryPredicate)conjunct).getOp()).isEquivalence()) continue;
                ArrayList<TupleId> lhsTupleIds = new ArrayList<TupleId>();
                ((Expr)conjunct.getChild(0)).getIds(lhsTupleIds, null);
                if (lhsTupleIds.isEmpty() && !((Expr)conjunct.getChild(0)).isConstant()) continue;
                ArrayList<TupleId> rhsTupleIds = new ArrayList<TupleId>();
                ((Expr)conjunct.getChild(1)).getIds(rhsTupleIds, null);
                if (rhsTupleIds.isEmpty() || lhsTupleIds.contains(inlineView.getDesc().getId()) && lhsTupleIds.size() > 1 || rhsTupleIds.contains(inlineView.getDesc().getId()) && rhsTupleIds.size() > 1) continue;
                hasEqJoinPred = true;
                break;
            }
            if (!(hasEqJoinPred || inlineView.isCorrelated() || isDisjunctive)) {
                boolean hasGroupBy = ((SelectStmt)inlineView.getViewStmt()).hasGroupByClause();
                if (!isScalarSubquery && !isRuntimeScalar || hasGroupBy && !stmt.selectList_.isDistinct() && !isScalarColumn && !isRuntimeScalar) {
                    throw new AnalysisException("Unsupported predicate with subquery: " + expr.toSql());
                }
                if (isScalarSubquery && expr instanceof InPredicate && ((InPredicate)expr).isNotIn()) {
                    throw new AnalysisException("Unsupported NOT IN predicate with subquery: " + expr.toSql());
                }
                stmt.whereClause_ = CompoundPredicate.createConjunction(onClausePredicate, stmt.whereClause_);
                inlineView.setJoinOp(JoinOperator.CROSS_JOIN);
                if (isScalarSubquery) {
                    inlineView.setIsNonCorrelatedScalarSubquery();
                }
                return true;
            }
            if (expr instanceof InPredicate && ((InPredicate)expr).isNotIn() || expr instanceof ExistsPredicate && ((ExistsPredicate)expr).isNotExists()) {
                if (expr instanceof InPredicate) {
                    joinOp = JoinOperator.NULL_AWARE_LEFT_ANTI_JOIN;
                    ArrayList<TupleId> tIds = new ArrayList<TupleId>();
                    joinConjunct.getIds(tIds, null);
                    if (tIds.size() <= 1 || !tIds.contains(inlineView.getDesc().getId())) {
                        throw new AnalysisException("Unsupported NOT IN predicate with subquery: " + expr.toSql());
                    }
                    for (Expr conjunct : onClausePredicate.getConjuncts()) {
                        if (!conjunct.equals(joinConjunct)) continue;
                        Preconditions.checkState((boolean)(conjunct instanceof BinaryPredicate));
                        BinaryPredicate binaryPredicate = (BinaryPredicate)conjunct;
                        Preconditions.checkState((boolean)binaryPredicate.getOp().isEquivalence());
                        binaryPredicate.setOp(BinaryPredicate.Operator.NULL_MATCHING_EQ);
                        break;
                    }
                } else {
                    joinOp = JoinOperator.LEFT_ANTI_JOIN;
                }
            }
            inlineView.setJoinOp(joinOp);
            inlineView.setOnClause(onClausePredicate);
            return updateSelectList;
        }

        private static Expr replaceSubqueryInDisjunct(Expr expr, InlineViewRef inlineView, SelectStmt subqueryStmt, List<Expr> whereClauseConjuncts, List<Expr> smapLhs, List<Expr> smapRhs) throws AnalysisException {
            Preconditions.checkState((subqueryStmt.getSelectList().getItems().size() == 1 ? 1 : 0) != 0);
            ArrayList parents = new ArrayList();
            expr.collect(Expr.HAS_SUBQUERY_CHILD, parents);
            Preconditions.checkState((parents.size() == 1 ? 1 : 0) != 0, (Object)"Must contain exactly 1 subquery");
            Expr parent = (Expr)parents.get(0);
            if (parent instanceof ExistsPredicate) {
                throw new AnalysisException("EXISTS/NOT EXISTS subqueries in OR predicates are not supported: " + expr.toSql());
            }
            if (parent instanceof InPredicate && ((InPredicate)parent).isNotIn()) {
                throw new AnalysisException("NOT IN subqueries in OR predicates are not supported: " + expr.toSql());
            }
            if (!(parent instanceof Predicate)) {
                throw new AnalysisException("Subqueries that are arguments to non-predicate exprs are not supported inside OR: " + expr.toSql());
            }
            Preconditions.checkState((parent instanceof InPredicate || parent instanceof BinaryPredicate || parent instanceof LikePredicate ? 1 : 0) != 0, (Object)parent);
            SlotRef slotRef = new SlotRef(Lists.newArrayList((Object[])new String[]{inlineView.getUniqueAlias(), inlineView.getColLabels().get(0)}));
            whereClauseConjuncts.add(expr);
            if (!subqueryStmt.returnsAtMostOneRow()) {
                subqueryStmt.getSelectList().setIsDistinct(true);
                subqueryStmt.removeGroupBy();
            }
            smapLhs.add(parent);
            smapRhs.add(new IsNullPredicate(slotRef, true));
            return parent;
        }

        private static void replaceUnqualifiedStarItems(SelectStmt stmt, int tableIdx) {
            Preconditions.checkState((tableIdx < stmt.fromClause_.size() ? 1 : 0) != 0);
            ArrayList<SelectListItem> newItems = new ArrayList<SelectListItem>();
            for (int i = 0; i < stmt.selectList_.getItems().size(); ++i) {
                SelectListItem item = stmt.selectList_.getItems().get(i);
                if (!item.isStar() || item.getRawPath() != null) {
                    newItems.add(item);
                    continue;
                }
                for (int j = 0; j < tableIdx; ++j) {
                    TableRef tableRef = stmt.fromClause_.get(j);
                    if (tableRef.getJoinOp() == JoinOperator.LEFT_SEMI_JOIN || tableRef.getJoinOp() == JoinOperator.LEFT_ANTI_JOIN) continue;
                    newItems.add(SelectListItem.createStarItem(Lists.newArrayList((Object[])new String[]{tableRef.getUniqueAlias()})));
                }
            }
            Preconditions.checkState((!newItems.isEmpty() ? 1 : 0) != 0);
            boolean isDistinct = stmt.selectList_.isDistinct();
            stmt.selectList_ = new SelectList(newItems, isDistinct, stmt.selectList_.getPlanHints());
        }

        private static boolean canEliminate(Expr expr) {
            return expr.isTriviallyTrue();
        }

        private static List<Expr> extractCorrelatedPredicates(SelectStmt subqueryStmt) throws AnalysisException {
            List<TupleId> subqueryTupleIds = subqueryStmt.getTableRefIds();
            ArrayList<Expr> correlatedPredicates = new ArrayList<Expr>();
            if (subqueryStmt.hasWhereClause()) {
                if (!SubqueryRewriter.canExtractCorrelatedPredicates(subqueryStmt.getWhereClause(), subqueryTupleIds)) {
                    throw new AnalysisException("Disjunctions with correlated predicates are not supported: " + subqueryStmt.getWhereClause().toSql());
                }
                Expr newWhereClause = SubqueryRewriter.extractCorrelatedPredicates(subqueryStmt.getWhereClause(), subqueryTupleIds, correlatedPredicates);
                if (SubqueryRewriter.canEliminate(newWhereClause)) {
                    newWhereClause = null;
                }
                subqueryStmt.setWhereClause(newWhereClause);
            }
            for (TableRef tableRef : subqueryStmt.getTableRefs()) {
                if (tableRef.getOnClause() == null) continue;
                ArrayList<Expr> onClauseCorrelatedPreds = new ArrayList<Expr>();
                Expr newOnClause = SubqueryRewriter.extractCorrelatedPredicates(tableRef.getOnClause(), subqueryTupleIds, onClauseCorrelatedPreds);
                if (onClauseCorrelatedPreds.isEmpty()) continue;
                correlatedPredicates.addAll(onClauseCorrelatedPreds);
                if (SubqueryRewriter.canEliminate(newOnClause)) {
                    tableRef.setJoinOp(JoinOperator.CROSS_JOIN);
                    tableRef.setOnClause(null);
                    continue;
                }
                tableRef.setOnClause(newOnClause);
            }
            return correlatedPredicates;
        }

        private static Expr extractCorrelatedPredicates(Expr root, List<TupleId> tupleIds, List<Expr> matches) {
            if (SubqueryRewriter.isCorrelatedPredicate(root, tupleIds)) {
                matches.add(root);
                return new BoolLiteral(true);
            }
            for (int i = 0; i < root.getChildren().size(); ++i) {
                root.getChildren().set(i, SubqueryRewriter.extractCorrelatedPredicates((Expr)root.getChild(i), tupleIds, matches));
            }
            return root;
        }

        private static void validateCorrelatedSubqueryStmt(Expr expr) throws AnalysisException {
            Preconditions.checkNotNull((Object)expr);
            Preconditions.checkState((boolean)expr.contains(Subquery.class));
            SelectStmt stmt = (SelectStmt)expr.getSubquery().getStatement();
            Preconditions.checkNotNull((Object)stmt);
            if (expr instanceof BinaryPredicate && (stmt.hasGroupByClause() || stmt.hasAnalyticInfo()) || expr instanceof InPredicate && (stmt.hasMultiAggInfo() || stmt.hasAnalyticInfo())) {
                throw new AnalysisException("Unsupported correlated subquery with grouping and/or aggregation: " + stmt.toSql());
            }
            if (!(expr.getSubquery().isScalarSubquery() || expr instanceof InPredicate || expr instanceof ExistsPredicate)) {
                throw new AnalysisException("Unsupported correlated subquery with runtime scalar check: " + stmt.toSql());
            }
            if (!(!stmt.hasLimit() || expr instanceof BinaryPredicate && stmt.hasMultiAggInfo() && !stmt.selectList_.isDistinct() || expr instanceof ExistsPredicate)) {
                throw new AnalysisException("Unsupported correlated subquery with a LIMIT clause: " + stmt.toSql());
            }
        }

        private static void validateCorrelatedPredicates(Expr expr, InlineViewRef inlineView, List<Expr> correlatedPredicates) throws AnalysisException {
            List<TupleId> subqueryTblIds;
            com.google.common.base.Predicate<Expr> isBoundBySubqueryTids;
            ArrayList unsupportedPredicates;
            Preconditions.checkNotNull((Object)expr);
            Preconditions.checkNotNull(correlatedPredicates);
            Preconditions.checkState((boolean)inlineView.isAnalyzed());
            SelectStmt stmt = (SelectStmt)expr.getSubquery().getStatement();
            com.google.common.base.Predicate<Expr> isSingleSlotRef = new com.google.common.base.Predicate<Expr>(){

                public boolean apply(Expr arg) {
                    return arg.unwrapSlotRef(false) != null;
                }
            };
            if (!(!(expr instanceof ExistsPredicate) || !stmt.hasHavingClause() || correlatedPredicates.isEmpty() || stmt.hasMultiAggInfo() && Iterables.all(correlatedPredicates, (com.google.common.base.Predicate)Predicates.or(Expr.IS_EQ_BINARY_PREDICATE, (com.google.common.base.Predicate)isSingleSlotRef)))) {
                throw new AnalysisException("Unsupported correlated EXISTS subquery with a HAVING clause: " + stmt.toSql());
            }
            if (expr instanceof BinaryPredicate && !inlineView.isCorrelated() && !correlatedPredicates.isEmpty() && !(unsupportedPredicates = Lists.newArrayList((Iterable)Iterables.filter(correlatedPredicates, (com.google.common.base.Predicate)Predicates.and(Expr.IS_NOT_EQ_BINARY_PREDICATE, (com.google.common.base.Predicate)(isBoundBySubqueryTids = new com.google.common.base.Predicate<Expr>(subqueryTblIds = stmt.getTableRefIds()){
                final /* synthetic */ List val$subqueryTblIds;
                {
                    this.val$subqueryTblIds = list;
                }

                public boolean apply(Expr arg) {
                    ArrayList<TupleId> tids = new ArrayList<TupleId>();
                    arg.getIds(tids, null);
                    return !Collections.disjoint(tids, this.val$subqueryTblIds);
                }
            }))))).isEmpty()) {
                throw new AnalysisException("Unsupported aggregate subquery with non-equality correlated predicates: " + Expr.listToSql(unsupportedPredicates, ToSqlOptions.DEFAULT));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void updateInlineView(InlineViewRef inlineView, Expr expr, List<TupleId> parentQueryTids, List<Expr> lhsExprs, List<Expr> rhsExprs, boolean updateGroupBy) throws AnalysisException {
            SelectStmt stmt = (SelectStmt)inlineView.getViewStmt();
            List<TupleId> subqueryTblIds = stmt.getTableRefIds();
            ArrayList<Expr> groupByExprs = null;
            if (updateGroupBy) {
                groupByExprs = new ArrayList<Expr>();
            }
            List<SelectListItem> items = stmt.selectList_.getItems();
            ArrayList slotRefs = new ArrayList();
            expr.collectAll(Predicates.instanceOf(SlotRef.class), slotRefs);
            ArrayList<Object> exprsBoundBySubqueryTids = new ArrayList<Object>();
            for (Expr expr2 : slotRefs) {
                if (!expr2.isBoundByTupleIds(subqueryTblIds)) continue;
                exprsBoundBySubqueryTids.add(expr2);
            }
            if (exprsBoundBySubqueryTids.isEmpty()) {
                return;
            }
            if (updateGroupBy) {
                Object exprBoundBySubqueryTids;
                Preconditions.checkState((boolean)(expr instanceof BinaryPredicate));
                if (exprsBoundBySubqueryTids.size() > 1) {
                    if (((Expr)expr.getChild(0)).isBoundByTupleIds(subqueryTblIds) && ((Expr)expr.getChild(1)).isBoundByTupleIds(parentQueryTids)) {
                        exprBoundBySubqueryTids = (Expr)expr.getChild(0);
                    } else {
                        if (!((Expr)expr.getChild(0)).isBoundByTupleIds(parentQueryTids) || !((Expr)expr.getChild(1)).isBoundByTupleIds(subqueryTblIds)) throw new AnalysisException("All subquery columns that participate in a predicate must be on the same side of that predicate: " + expr.toSql());
                        exprBoundBySubqueryTids = (Expr)expr.getChild(1);
                    }
                } else {
                    Preconditions.checkState((exprsBoundBySubqueryTids.size() == 1 ? 1 : 0) != 0);
                    exprBoundBySubqueryTids = (Expr)exprsBoundBySubqueryTids.get(0);
                }
                exprsBoundBySubqueryTids.clear();
                exprsBoundBySubqueryTids.add(exprBoundBySubqueryTids);
            }
            for (Expr expr3 : exprsBoundBySubqueryTids) {
                String colAlias = stmt.getColumnAliasGenerator().getNextAlias();
                items.add(new SelectListItem(expr3, null));
                inlineView.getExplicitColLabels().add(colAlias);
                lhsExprs.add(expr3);
                rhsExprs.add(new SlotRef(Lists.newArrayList((Object[])new String[]{inlineView.getUniqueAlias(), colAlias})));
                if (groupByExprs == null) continue;
                groupByExprs.add(expr3);
            }
            boolean isDistinct = stmt.selectList_.isDistinct();
            stmt.selectList_ = new SelectList(items, isDistinct, stmt.selectList_.getPlanHints());
            if (groupByExprs == null || groupByExprs.isEmpty()) return;
            stmt.addGroupingExprs(groupByExprs);
        }

        private static boolean canExtractCorrelatedPredicates(Expr expr, List<TupleId> subqueryTupleIds) {
            if (!(expr instanceof CompoundPredicate)) {
                return true;
            }
            if (Expr.IS_OR_PREDICATE.apply((Object)expr)) {
                return !SubqueryRewriter.containsCorrelatedPredicate(expr, subqueryTupleIds);
            }
            for (Expr child : expr.getChildren()) {
                if (SubqueryRewriter.canExtractCorrelatedPredicates(child, subqueryTupleIds)) continue;
                return false;
            }
            return true;
        }

        private static boolean containsCorrelatedPredicate(Expr root, List<TupleId> tupleIds) {
            if (SubqueryRewriter.isCorrelatedPredicate(root, tupleIds)) {
                return true;
            }
            for (Expr child : root.getChildren()) {
                if (!SubqueryRewriter.containsCorrelatedPredicate(child, tupleIds)) continue;
                return true;
            }
            return false;
        }

        private static boolean isCorrelatedPredicate(Expr expr, List<TupleId> tupleIds) {
            return (expr instanceof BinaryPredicate || expr instanceof SlotRef) && !expr.isBoundByTupleIds(tupleIds);
        }

        private static Expr createJoinConjunct(Expr exprWithSubquery, InlineViewRef inlineView, Analyzer analyzer, boolean isCorrelated) throws AnalysisException {
            Preconditions.checkNotNull((Object)exprWithSubquery);
            Preconditions.checkNotNull((Object)inlineView);
            Preconditions.checkState((boolean)exprWithSubquery.contains(Subquery.class));
            if (exprWithSubquery instanceof ExistsPredicate) {
                return null;
            }
            SlotRef slotRef = new SlotRef(Lists.newArrayList((Object[])new String[]{inlineView.getUniqueAlias(), inlineView.getColLabels().get(0)}));
            slotRef.analyze(analyzer);
            Expr subquerySubstitute = slotRef;
            if (exprWithSubquery instanceof InPredicate) {
                BinaryPredicate pred = new BinaryPredicate(BinaryPredicate.Operator.EQ, (Expr)exprWithSubquery.getChild(0), slotRef);
                pred.analyze(analyzer);
                return pred;
            }
            Subquery subquery = exprWithSubquery.getSubquery();
            Preconditions.checkState((boolean)subquery.getType().isScalarType());
            ExprSubstitutionMap smap = new ExprSubstitutionMap();
            SelectListItem item = ((SelectStmt)inlineView.getViewStmt()).getSelectList().getItems().get(0);
            if (isCorrelated && item.getExpr().contains(Expr.IS_UDA_FN)) {
                throw new AnalysisException("UDAs are not supported in the select list of correlated subqueries: " + subquery.toSql());
            }
            if (isCorrelated && item.getExpr().contains(Expr.NON_NULL_EMPTY_AGG)) {
                if (!(Expr.NON_NULL_EMPTY_AGG.apply((Object)item.getExpr()) || item.getExpr() instanceof CastExpr && Expr.NON_NULL_EMPTY_AGG.apply(item.getExpr().getChild(0)))) {
                    throw new AnalysisException("Aggregate function that returns non-null on an empty input cannot be used in an expression in a correlated subquery's select list: " + subquery.toSql());
                }
                ArrayList aggFns = new ArrayList();
                item.getExpr().collectAll(Expr.NON_NULL_EMPTY_AGG, aggFns);
                if (((FunctionCallExpr)aggFns.get(0)).getReturnType().isNumericType()) {
                    FunctionCallExpr zeroIfNull = new FunctionCallExpr("zeroifnull", (List<Expr>)Lists.newArrayList((Object[])new Expr[]{slotRef}));
                    zeroIfNull.analyze(analyzer);
                    subquerySubstitute = zeroIfNull;
                } else if (((FunctionCallExpr)aggFns.get(0)).getReturnType().isStringType()) {
                    ArrayList<Expr> params = new ArrayList<Expr>();
                    params.add(slotRef);
                    params.add(new StringLiteral(""));
                    FunctionCallExpr ifnull = new FunctionCallExpr("ifnull", params);
                    ifnull.analyze(analyzer);
                    subquerySubstitute = ifnull;
                } else {
                    throw new AnalysisException("Unsupported aggregate function used in a correlated subquery's select list: " + subquery.toSql());
                }
            }
            smap.put(subquery, subquerySubstitute);
            return exprWithSubquery.substitute(smap, analyzer, false);
        }

        @Override
        protected void rewriteSelectStmtHook(SelectStmt stmt, Analyzer analyzer) throws AnalysisException {
            if (stmt.hasHavingClause() && stmt.havingClause_.getSubquery() != null) {
                this.rewriteHavingClauseSubqueries(stmt, analyzer);
            }
            if (stmt.hasWhereClause()) {
                stmt.whereClause_ = Expr.pushNegationToOperands(stmt.whereClause_);
                this.rewriteWhereClauseSubqueries(stmt, analyzer);
            }
            this.rewriteSelectListSubqueries(stmt, analyzer);
        }

        private void rewriteWhereClauseSubqueries(SelectStmt stmt, Analyzer analyzer) throws AnalysisException {
            int numTableRefs = stmt.fromClause_.size();
            ArrayList<Expr> exprsWithSubqueries = new ArrayList<Expr>();
            ExprSubstitutionMap smap = new ExprSubstitutionMap();
            for (Expr conjunct : stmt.whereClause_.getConjuncts()) {
                BoolLiteral boolLiteral;
                Expr newConjunct;
                ArrayList subqueries = new ArrayList();
                conjunct.collectAll(Predicates.instanceOf(Subquery.class), subqueries);
                if (subqueries.size() == 0) continue;
                if (subqueries.size() > 1) {
                    throw new AnalysisException("Multiple subqueries are not supported in expression: " + conjunct.toSql());
                }
                if (!(conjunct instanceof InPredicate || conjunct instanceof ExistsPredicate || conjunct instanceof BinaryPredicate || conjunct.getSubquery().getType().isScalarType())) {
                    throw new AnalysisException("Non-scalar subquery is not supported in expression: " + conjunct.toSql());
                }
                Expr rewrittenConjunct = conjunct;
                if (conjunct instanceof InPredicate && ((Expr)conjunct.getChild(0)).isConstant() && (newConjunct = SubqueryRewriter.rewriteInConstant(stmt, (InPredicate)conjunct)) != null) {
                    newConjunct.analyze(analyzer);
                    rewrittenConjunct = newConjunct;
                }
                if (rewrittenConjunct instanceof ExistsPredicate && (boolLiteral = SubqueryRewriter.replaceExistsPredicate((ExistsPredicate)rewrittenConjunct)) != null) {
                    boolLiteral.analyze(analyzer);
                    smap.put(conjunct, boolLiteral);
                    continue;
                }
                boolLiteral = new BoolLiteral(true);
                boolLiteral.analyze(analyzer);
                smap.put(conjunct, boolLiteral);
                exprsWithSubqueries.add(rewrittenConjunct);
            }
            stmt.whereClause_ = stmt.whereClause_.substitute(smap, analyzer, false);
            boolean hasNewVisibleTuple = false;
            for (Expr expr : exprsWithSubqueries) {
                if (!SubqueryRewriter.mergeExpr(stmt, this.rewriteExpr(expr, analyzer), analyzer)) continue;
                hasNewVisibleTuple = true;
            }
            if (SubqueryRewriter.canEliminate(stmt.whereClause_)) {
                stmt.whereClause_ = null;
            }
            if (hasNewVisibleTuple) {
                SubqueryRewriter.replaceUnqualifiedStarItems(stmt, numTableRefs);
            }
        }

        private Expr rewriteExpr(Expr expr, Analyzer analyzer) throws AnalysisException {
            Subquery subquery = expr.getSubquery();
            Preconditions.checkNotNull((Object)subquery);
            this.rewriteSelectStatement((SelectStmt)subquery.getStatement(), subquery.getAnalyzer());
            QueryStmt rewrittenStmt = subquery.getStatement().clone();
            rewrittenStmt.reset();
            Subquery newSubquery = new Subquery(rewrittenStmt);
            newSubquery.analyze(analyzer);
            ExprSubstitutionMap smap = new ExprSubstitutionMap();
            smap.put(subquery, newSubquery);
            return expr.substitute(smap, analyzer, false);
        }

        private void rewriteSelectListSubqueries(SelectStmt stmt, Analyzer analyzer) throws AnalysisException {
            Preconditions.checkNotNull((Object)stmt);
            Preconditions.checkNotNull((Object)analyzer);
            int numTableRefs = stmt.fromClause_.size();
            boolean parentHasAgg = stmt.hasMultiAggInfo();
            ArrayList<InlineViewRef> newViews = new ArrayList<InlineViewRef>();
            for (SelectListItem selectItem : stmt.getSelectList().getItems()) {
                if (selectItem.isStar()) continue;
                Expr expr = selectItem.getExpr();
                ArrayList subqueries = new ArrayList();
                expr.collect(Predicates.instanceOf(Subquery.class), subqueries);
                if (subqueries.size() == 0) continue;
                ExprSubstitutionMap smap = new ExprSubstitutionMap();
                for (Subquery sq : subqueries) {
                    SelectStmt subqueryStmt = (SelectStmt)sq.getStatement();
                    if (SubqueryRewriter.isCorrelated(subqueryStmt)) {
                        throw new AnalysisException("A correlated scalar subquery is not supported in the expression: " + expr.toSql());
                    }
                    Preconditions.checkState((boolean)sq.getType().isScalarType());
                    boolean replacedExists = false;
                    ArrayList existsPredicates = new ArrayList();
                    expr.collect(ExistsPredicate.class, existsPredicates);
                    for (ExistsPredicate ep : existsPredicates) {
                        if (!ep.contains(sq)) continue;
                        BoolLiteral boolLiteral = SubqueryRewriter.replaceExistsPredicate(ep);
                        if (boolLiteral != null) {
                            boolLiteral.analyze(analyzer);
                            smap.put(ep, boolLiteral);
                            replacedExists = true;
                            break;
                        }
                        throw new AnalysisException("Unsupported subquery with runtime scalar check: " + ep.toSql());
                    }
                    if (replacedExists) continue;
                    ArrayList<String> colLabels = new ArrayList<String>();
                    for (int i = 0; i < subqueryStmt.getColLabels().size(); ++i) {
                        colLabels.add(subqueryStmt.getColumnAliasGenerator().getNextAlias());
                    }
                    InlineViewRef inlineView = new InlineViewRef(stmt.getTableAliasGenerator().getNextAlias(), (QueryStmt)subqueryStmt, colLabels);
                    inlineView.reset();
                    inlineView.analyze(analyzer);
                    inlineView.setJoinOp(subqueryStmt.returnsExactlyOneRow() ? JoinOperator.CROSS_JOIN : JoinOperator.LEFT_OUTER_JOIN);
                    inlineView.setAllowEmptyOn(true);
                    stmt.fromClause_.add(inlineView);
                    newViews.add(inlineView);
                    SlotRef slotRef = new SlotRef(Lists.newArrayList((Object[])new String[]{inlineView.getUniqueAlias(), inlineView.getColLabels().get(0)}));
                    slotRef.analyze(analyzer);
                    Expr substitute = slotRef;
                    if (parentHasAgg) {
                        FunctionCallExpr aggWrapper = new FunctionCallExpr("max", (List<Expr>)Lists.newArrayList((Object[])new Expr[]{slotRef}));
                        aggWrapper.analyze(analyzer);
                        substitute = aggWrapper;
                    }
                    smap.put(sq, substitute);
                }
                selectItem.setExpr(expr.substitute(smap, analyzer, false));
            }
            for (InlineViewRef v : newViews) {
                this.rewriteQueryStatement(v.getViewStmt(), v.getAnalyzer());
            }
            if (!newViews.isEmpty()) {
                SubqueryRewriter.replaceUnqualifiedStarItems(stmt, numTableRefs);
            }
        }

        private void rewriteHavingClauseSubqueries(SelectStmt stmt, Analyzer analyzer) throws AnalysisException {
            SelectStmt innerStmt = stmt.clone();
            List<Object> aggExprs = stmt.hasMultiAggInfo() ? stmt.getMultiAggInfo().getAggExprs() : new ArrayList();
            for (FunctionCallExpr functionCallExpr : aggExprs) {
                SelectListItem selectListItem;
                boolean contains = false;
                Iterator<SelectListItem> iterator = stmt.getSelectList().getItems().iterator();
                while (iterator.hasNext() && !(contains = (selectListItem = iterator.next()).getExpr().equals(functionCallExpr))) {
                }
                if (contains) continue;
                innerStmt.selectList_.getItems().add(new SelectListItem(functionCallExpr.clone().reset(), null));
            }
            innerStmt.havingClause_ = null;
            innerStmt.limitElement_ = new LimitElement(null, null);
            if (innerStmt.hasOrderByClause()) {
                innerStmt.orderByElements_ = null;
            }
            innerStmt.reset();
            List<SelectListItem> preAnalyzeSelectList = innerStmt.getSelectList().clone().getItems();
            ExprSubstitutionMap exprSubstitutionMap = new ExprSubstitutionMap();
            ArrayList colLabels = Lists.newArrayListWithCapacity((int)innerStmt.getSelectList().getItems().size());
            for (int i = 0; i < innerStmt.getSelectList().getItems().size(); ++i) {
                String colAlias = stmt.getColumnAliasGenerator().getNextAlias();
                colLabels.add(colAlias);
            }
            String innerAlias = stmt.getTableAliasGenerator().getNextAlias();
            InlineViewRef innerView = new InlineViewRef(innerAlias, (QueryStmt)innerStmt, colLabels);
            innerView.analyze(analyzer);
            this.rewriteSelectStatement((SelectStmt)innerView.getViewStmt(), innerView.getViewStmt().getAnalyzer());
            for (int i = 0; i < preAnalyzeSelectList.size(); ++i) {
                SlotRef slot = new SlotRef(Lists.newArrayList((Object[])new String[]{innerAlias, (String)colLabels.get(i)}));
                slot.analyze(analyzer);
                exprSubstitutionMap.put(preAnalyzeSelectList.get(i).getExpr(), slot);
            }
            ArrayList<SelectListItem> outerSelectList = new ArrayList<SelectListItem>();
            for (int i = 0; i < stmt.getSelectList().getItems().size(); ++i) {
                SelectListItem si = new SelectListItem(stmt.getSelectList().getItems().get(i).getExpr().clone().reset().substitute(exprSubstitutionMap, analyzer, false), stmt.getColLabels().get(i));
                si.getExpr().analyze(analyzer);
                outerSelectList.add(si);
            }
            stmt.whereClause_ = stmt.havingClause_.reset().substitute(exprSubstitutionMap, analyzer, false);
            stmt.whereClause_.analyze(analyzer);
            stmt.havingClause_ = null;
            stmt.groupingExprs_ = null;
            stmt.selectList_.getItems().clear();
            stmt.selectList_.getItems().addAll(outerSelectList);
            stmt.fromClause_.getTableRefs().clear();
            stmt.fromClause_.add(innerView);
            stmt.analyze(analyzer);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Rewritten HAVING Clause SQL: " + stmt.toSql(ToSqlOptions.REWRITTEN));
            }
        }
    }
}

