/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.collect.Sets;
import org.apache.impala.analysis.ShowTablesOrViewsStmt;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TShowTablesParams;

public class ShowViewsStmt
extends ShowTablesOrViewsStmt {
    public ShowViewsStmt() {
        super(null, null);
    }

    public ShowViewsStmt(String pattern) {
        super(null, pattern);
    }

    public ShowViewsStmt(String database, String pattern) {
        super(database, pattern);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        if (this.getPattern() == null) {
            if (this.getParsedDb() == null) {
                return "SHOW VIEWS";
            }
            return "SHOW VIEWS IN " + this.getParsedDb();
        }
        if (this.getParsedDb() == null) {
            return "SHOW VIEWS LIKE '" + this.getPattern() + "'";
        }
        return "SHOW VIEWS IN " + this.getParsedDb() + " LIKE '" + this.getPattern() + "'";
    }

    @Override
    public TShowTablesParams toThrift() {
        TShowTablesParams params = super.toThrift();
        params.setTable_types(Sets.newHashSet((Object[])new TImpalaTableType[]{TImpalaTableType.VIEW}));
        return params;
    }
}

