/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.SingleTableStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.paimon.PaimonAnalyzer;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.paimon.FePaimonTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TShowStatsOp;
import org.apache.impala.thrift.TShowStatsParams;

public class ShowStatsStmt
extends StatementBase
implements SingleTableStmt {
    protected final TShowStatsOp op_;
    protected final TableName tableName_;
    protected boolean show_column_minmax_stats_ = false;
    protected FeTable table_;

    public ShowStatsStmt(TableName tableName, TShowStatsOp op) {
        this.op_ = (TShowStatsOp)((Object)Preconditions.checkNotNull((Object)((Object)op)));
        this.tableName_ = (TableName)Preconditions.checkNotNull((Object)tableName);
    }

    @Override
    public TableName getTableName() {
        return this.tableName_;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return this.getSqlPrefix() + " " + this.tableName_.toString();
    }

    protected String getSqlPrefix() {
        if (this.op_ == TShowStatsOp.TABLE_STATS) {
            return "SHOW TABLE STATS";
        }
        if (this.op_ == TShowStatsOp.COLUMN_STATS) {
            return "SHOW COLUMN STATS";
        }
        if (this.op_ == TShowStatsOp.PARTITIONS) {
            return "SHOW PARTITIONS";
        }
        if (this.op_ == TShowStatsOp.RANGE_PARTITIONS) {
            return "SHOW RANGE PARTITIONS";
        }
        if (this.op_ == TShowStatsOp.HASH_SCHEMA) {
            return "SHOW HASH_SCHEMA";
        }
        Preconditions.checkState((boolean)false);
        return "";
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.table_ = analyzer.getTable(this.tableName_, Privilege.VIEW_METADATA);
        Preconditions.checkNotNull((Object)this.table_);
        if (this.table_ instanceof FeView) {
            throw new AnalysisException(String.format("%s not applicable to a view: %s", this.getSqlPrefix(), this.table_.getFullName()));
        }
        if (this.table_ instanceof FeFsTable) {
            boolean partitioned = true;
            if (this.op_ == TShowStatsOp.PARTITIONS) {
                if (this.table_ instanceof FeIcebergTable) {
                    FeIcebergTable feIcebergTable = (FeIcebergTable)this.table_;
                    Preconditions.checkNotNull(feIcebergTable.getPartitionSpecs());
                    if (!feIcebergTable.getDefaultPartitionSpec().hasPartitionFields()) {
                        partitioned = false;
                    }
                } else if (this.table_.getNumClusteringCols() == 0) {
                    partitioned = false;
                }
            }
            if (!partitioned) {
                throw new AnalysisException("Table is not partitioned: " + this.table_.getFullName());
            }
            if (this.op_ == TShowStatsOp.RANGE_PARTITIONS || this.op_ == TShowStatsOp.HASH_SCHEMA) {
                throw new AnalysisException(this.getSqlPrefix() + " must target a Kudu table: " + this.table_.getFullName());
            }
        } else if (this.table_ instanceof FePaimonTable) {
            PaimonAnalyzer.analyzeShowStatStmt(this, (FePaimonTable)this.table_, analyzer);
        } else if (this.table_ instanceof FeKuduTable) {
            FeKuduTable kuduTable = (FeKuduTable)this.table_;
            if ((this.op_ == TShowStatsOp.RANGE_PARTITIONS || this.op_ == TShowStatsOp.HASH_SCHEMA) && FeKuduTable.Utils.getRangePartitioningColNames(kuduTable).isEmpty()) {
                throw new AnalysisException(this.getSqlPrefix() + " requested but table does not have range partitions: " + this.table_.getFullName());
            }
        } else {
            if (this.op_ == TShowStatsOp.RANGE_PARTITIONS || this.op_ == TShowStatsOp.HASH_SCHEMA) {
                throw new AnalysisException(this.getSqlPrefix() + " must target a Kudu table: " + this.table_.getFullName());
            }
            if (this.op_ == TShowStatsOp.PARTITIONS) {
                throw new AnalysisException(this.getSqlPrefix() + " must target an HDFS or Kudu table: " + this.table_.getFullName());
            }
        }
        this.show_column_minmax_stats_ = analyzer.getQueryOptions().isShow_column_minmax_stats();
    }

    public TShowStatsParams toThrift() {
        TShowStatsParams showStatsParam = new TShowStatsParams(this.op_, new TableName(this.table_.getDb().getName(), this.table_.getName()).toThrift());
        showStatsParam.setShow_column_minmax_stats(this.show_column_minmax_stats_);
        return showStatsParam;
    }
}

