/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.AuthorizationStmt;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.User;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.thrift.TShowRolesParams;

public class ShowRolesStmt
extends AuthorizationStmt {
    private final String groupName_;
    private final boolean isShowCurrentRoles_;
    private User requestingUser_;

    public ShowRolesStmt(boolean isShowCurrentRoles, String groupName) {
        Preconditions.checkState((!isShowCurrentRoles || groupName == null || !groupName.isEmpty() ? 1 : 0) != 0);
        this.groupName_ = groupName;
        this.isShowCurrentRoles_ = isShowCurrentRoles;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        if (this.groupName_ == null) {
            return this.isShowCurrentRoles_ ? "SHOW CURRENT ROLES" : "SHOW ROLES";
        }
        return "SHOW ROLE GRANT GROUP " + this.groupName_;
    }

    public TShowRolesParams toThrift() throws InternalException {
        TShowRolesParams params = new TShowRolesParams();
        params.setRequesting_user(this.requestingUser_.getShortName());
        params.setIs_show_current_roles(this.isShowCurrentRoles_);
        if (this.groupName_ != null) {
            params.setGrant_group(this.groupName_);
        }
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        this.requestingUser_ = analyzer.getUser();
    }

    @Override
    public boolean requiresHmsMetadata() {
        return false;
    }
}

