/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.Function;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TFunctionCategory;
import org.apache.impala.thrift.TGetFunctionsParams;

public class ShowCreateFunctionStmt
extends StatementBase {
    private final FunctionName functionName_;
    private final TFunctionCategory category_;

    public ShowCreateFunctionStmt(FunctionName functionName, TFunctionCategory category) {
        Preconditions.checkNotNull((Object)functionName);
        Preconditions.checkArgument((category == TFunctionCategory.SCALAR || category == TFunctionCategory.AGGREGATE ? 1 : 0) != 0);
        this.functionName_ = functionName;
        this.category_ = category;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return "SHOW CREATE " + (this.category_ == TFunctionCategory.AGGREGATE ? "AGGREGATE " : "") + "FUNCTION " + this.functionName_;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.functionName_.analyze(analyzer);
        FeDb db = analyzer.getDb(this.functionName_.getDb(), Privilege.VIEW_METADATA);
        List<Function> functions = db.getFunctions(this.category_, this.functionName_.getFunction());
        if (functions.isEmpty()) {
            throw new AnalysisException("Function " + this.functionName_.getFunction() + "() does not exist in database " + this.functionName_.getDb());
        }
    }

    public TGetFunctionsParams toThrift() {
        TGetFunctionsParams params = new TGetFunctionsParams();
        params.setCategory(this.category_);
        params.setDb(this.functionName_.getDb());
        params.setPattern(this.functionName_.getFunction());
        return params;
    }
}

