/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.PlanHint;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.ExprRewriter;

public class SelectList {
    private List<PlanHint> planHints_ = new ArrayList<PlanHint>();
    private boolean isDistinct_;
    private final List<SelectListItem> items_;

    public SelectList(List<SelectListItem> items) {
        this.isDistinct_ = false;
        this.items_ = items;
    }

    public SelectList() {
        this.isDistinct_ = false;
        this.items_ = new ArrayList<SelectListItem>();
    }

    public SelectList(List<SelectListItem> items, boolean isDistinct, List<PlanHint> planHints) {
        this.isDistinct_ = isDistinct;
        this.items_ = items;
        this.planHints_ = planHints;
    }

    public SelectList(SelectList other) {
        this.planHints_ = Lists.newArrayList(other.planHints_);
        this.items_ = new ArrayList<SelectListItem>();
        for (SelectListItem item : other.items_) {
            this.items_.add(item.clone());
        }
        this.isDistinct_ = other.isDistinct_;
    }

    public List<SelectListItem> getItems() {
        return this.items_;
    }

    public void setPlanHints(List<PlanHint> planHints) {
        Preconditions.checkNotNull(planHints);
        this.planHints_ = planHints;
    }

    public List<PlanHint> getPlanHints() {
        return this.planHints_;
    }

    public boolean isDistinct() {
        return this.isDistinct_;
    }

    public void setIsDistinct(boolean value) {
        this.isDistinct_ = value;
    }

    public boolean hasPlanHints() {
        return !this.planHints_.isEmpty();
    }

    public void analyzePlanHints(Analyzer analyzer) {
        for (PlanHint hint : this.planHints_) {
            if (hint.is("straight_join")) {
                analyzer.setIsStraightJoin();
                continue;
            }
            analyzer.addWarning("PLAN hint not recognized: " + hint);
        }
    }

    public void rewriteExprs(ExprRewriter rewriter, Analyzer analyzer) throws AnalysisException {
        ArrayList subqueryExprs = new ArrayList();
        for (SelectListItem item : this.items_) {
            if (item.isStar() || item.isSkipExprRewrite()) continue;
            item.setExpr(rewriter.rewrite(item.getExpr(), analyzer));
            item.getExpr().collect(Subquery.class, subqueryExprs);
        }
        for (Subquery s : subqueryExprs) {
            s.getStatement().rewriteExprs(rewriter);
        }
    }

    public SelectList clone() {
        return new SelectList(this);
    }

    public void reset() {
        for (SelectListItem item : this.items_) {
            if (item.isStar()) continue;
            item.setExpr(item.getExpr().reset());
        }
    }
}

