/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.PartitionSpec;
import org.apache.impala.analysis.SingleTableStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.authorization.User;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TCatalogServiceRequestHeader;
import org.apache.impala.thrift.TResetMetadataRequest;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.util.AcidUtils;

public class ResetMetadataStmt
extends StatementBase
implements SingleTableStmt {
    private TableName tableName_;
    private final List<PartitionSpec> partitionSpecList_;
    private final String database_;
    private final Action action_;
    private User requestingUser_;
    private TUniqueId queryId_;
    private String clientIp_;

    private ResetMetadataStmt(Action action, String db, TableName tableName, List<PartitionSpec> partitionSpecList) {
        Preconditions.checkNotNull((Object)((Object)action));
        this.action_ = action;
        this.database_ = db;
        this.tableName_ = tableName;
        this.partitionSpecList_ = partitionSpecList;
        if (this.partitionSpecList_ != null) {
            this.partitionSpecList_.forEach(p -> p.setTableName(this.tableName_));
        }
    }

    public static ResetMetadataStmt createInvalidateStmt() {
        return new ResetMetadataStmt(Action.INVALIDATE_METADATA_ALL, null, null, null);
    }

    public static ResetMetadataStmt createInvalidateStmt(TableName tableName) {
        return new ResetMetadataStmt(Action.INVALIDATE_METADATA_TABLE, null, (TableName)Preconditions.checkNotNull((Object)tableName), null);
    }

    public static ResetMetadataStmt createRefreshTableStmt(TableName tableName) {
        return new ResetMetadataStmt(Action.REFRESH_TABLE, null, (TableName)Preconditions.checkNotNull((Object)tableName), null);
    }

    public static ResetMetadataStmt createRefreshPartitionsStmt(TableName tableName, List<PartitionSpec> partitionSpecList) {
        return new ResetMetadataStmt(Action.REFRESH_PARTITION, null, (TableName)Preconditions.checkNotNull((Object)tableName), (List)Preconditions.checkNotNull(partitionSpecList));
    }

    public static ResetMetadataStmt createRefreshFunctionsStmt(String db) {
        return new ResetMetadataStmt(Action.REFRESH_FUNCTIONS, (String)Preconditions.checkNotNull((Object)db), null, null);
    }

    public static ResetMetadataStmt createRefreshAuthorizationStmt() {
        return new ResetMetadataStmt(Action.REFRESH_AUTHORIZATION, null, null, null);
    }

    @Override
    public String getParsedDb() {
        return this.database_;
    }

    @Override
    public TableName getTableName() {
        return this.tableName_;
    }

    @VisibleForTesting
    protected Action getAction() {
        return this.action_;
    }

    @VisibleForTesting
    public void setRequestingUser(User user) {
        this.requestingUser_ = user;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        if (this.tableName_ != null && this.partitionSpecList_ != null) {
            tblRefs.add(new TableRef(this.tableName_.toPath(), null));
        }
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.requestingUser_ = analyzer.getUser();
        this.queryId_ = analyzer.getQueryCtx().getQuery_id();
        this.clientIp_ = analyzer.getQueryCtx().getSession().getNetwork_address().getHostname();
        switch (this.action_) {
            case INVALIDATE_METADATA_TABLE: 
            case REFRESH_TABLE: 
            case REFRESH_PARTITION: {
                Preconditions.checkNotNull((Object)this.tableName_);
                String dbName = analyzer.getTargetDbName(this.tableName_);
                this.tableName_ = new TableName(dbName, this.tableName_.getTbl());
                if (this.action_.isRefresh()) {
                    if (!analyzer.dbContainsTable(dbName, this.tableName_.getTbl(), Privilege.REFRESH)) {
                        throw new AnalysisException("Table does not exist: " + this.tableName_);
                    }
                    if (this.partitionSpecList_ == null) break;
                    try {
                        FeTable table = analyzer.getTable(dbName, this.tableName_.getTbl(), true);
                        if (AcidUtils.isTransactionalTable(table)) {
                            throw new AnalysisException("Refreshing partitions is not allowed on transactional tables. Try to refresh the whole table instead.");
                        }
                    }
                    catch (TableLoadingException e) {
                        throw new AnalysisException(e);
                    }
                    for (PartitionSpec ps : this.partitionSpecList_) {
                        ps.setPrivilegeRequirement(Privilege.ANY);
                        ps.analyze(analyzer);
                    }
                    break;
                }
                FeTable tbl = analyzer.getTableNoThrow(dbName, this.tableName_.getTbl());
                if (tbl == null) {
                    analyzer.registerPrivReq(builder -> builder.onTableUnknownOwner(dbName, this.tableName_.getTbl()).allOf(Privilege.REFRESH).build());
                    break;
                }
                analyzer.registerPrivReq(builder -> builder.onTable(dbName, this.tableName_.getTbl(), tbl.getOwnerUser()).allOf(Privilege.REFRESH).build());
                break;
            }
            case REFRESH_AUTHORIZATION: {
                if (!analyzer.isAuthzEnabled()) {
                    throw new AnalysisException("Authorization is not enabled. To enable authorization restart Impala with the --server_name=<name> flag.");
                }
                analyzer.registerPrivReq(builder -> builder.onServer(analyzer.getServerName()).allOf(Privilege.REFRESH).build());
                break;
            }
            case REFRESH_FUNCTIONS: {
                FeDb db = analyzer.getDb(this.database_, false);
                String dbOwner = db == null ? null : db.getOwnerUser();
                analyzer.registerPrivReq(builder -> builder.onDb(this.database_, dbOwner).allOf(Privilege.REFRESH).build());
                break;
            }
            case INVALIDATE_METADATA_ALL: {
                analyzer.registerPrivReq(builder -> builder.onServer(analyzer.getServerName()).allOf(Privilege.REFRESH).build());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid reset metadata action: " + (Object)((Object)this.action_));
            }
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder result = new StringBuilder();
        switch (this.action_) {
            case REFRESH_AUTHORIZATION: {
                result.append("REFRESH AUTHORIZATION");
                break;
            }
            case REFRESH_FUNCTIONS: {
                result.append("REFRESH FUNCTIONS ").append(this.database_);
                break;
            }
            case REFRESH_TABLE: {
                result.append("REFRESH ").append(this.tableName_.toSql());
                break;
            }
            case REFRESH_PARTITION: {
                result.append("REFRESH ").append(this.tableName_.toSql());
                this.partitionSpecList_.forEach(ps -> result.append(" ").append(ps.toSql(options)));
                break;
            }
            case INVALIDATE_METADATA_ALL: {
                result.append("INVALIDATE METADATA");
                break;
            }
            case INVALIDATE_METADATA_TABLE: {
                result.append("INVALIDATE METADATA ").append(this.tableName_.toSql());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid reset metadata action: " + (Object)((Object)this.action_));
            }
        }
        return result.toString();
    }

    public TResetMetadataRequest toThrift() throws InternalException {
        TResetMetadataRequest params = new TResetMetadataRequest();
        params.setHeader(new TCatalogServiceRequestHeader());
        params.header.setRequesting_user(this.requestingUser_.getShortName());
        params.header.setQuery_id(this.queryId_);
        params.header.setCoordinator_hostname(BackendConfig.INSTANCE.getHostname());
        params.header.setClient_ip(this.clientIp_);
        params.setIs_refresh(this.action_.isRefresh());
        if (this.tableName_ != null) {
            params.setTable_name(new TTableName(this.tableName_.getDb(), this.tableName_.getTbl()));
        }
        if (this.partitionSpecList_ != null) {
            for (PartitionSpec ps : this.partitionSpecList_) {
                params.addToPartition_spec_list(ps.toThrift());
            }
        }
        if (this.database_ != null) {
            params.setDb_name(this.database_);
        }
        if (this.action_ == Action.REFRESH_AUTHORIZATION) {
            params.setAuthorization(true);
        }
        return params;
    }

    public static enum Action {
        INVALIDATE_METADATA_ALL(false),
        INVALIDATE_METADATA_TABLE(false),
        REFRESH_TABLE(true),
        REFRESH_PARTITION(true),
        REFRESH_FUNCTIONS(true),
        REFRESH_AUTHORIZATION(true);

        private final boolean isRefresh_;

        private Action(boolean isRefresh) {
            this.isRefresh_ = isRefresh;
        }

        public boolean isRefresh() {
            return this.isRefresh_;
        }
    }
}

