/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.KuduPartitionParam;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TypeDef;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TRangePartition;
import org.apache.impala.util.ExprUtil;
import org.apache.impala.util.KuduUtil;

public class RangePartition
extends StmtNode {
    private final List<Expr> lowerBound_;
    private final List<Expr> upperBound_;
    private final boolean lowerBoundInclusive_;
    private final boolean upperBoundInclusive_;
    private final boolean isSingletonRange_;
    private final List<KuduPartitionParam> hashSpec_;
    private boolean isAnalyzed_ = false;

    private RangePartition(List<Expr> lowerBoundValues, boolean lowerBoundInclusive, List<Expr> upperBoundValues, boolean upperBoundInclusive, List<KuduPartitionParam> hashSpec) {
        Preconditions.checkNotNull(lowerBoundValues);
        Preconditions.checkNotNull(upperBoundValues);
        Preconditions.checkState((!lowerBoundValues.isEmpty() || !upperBoundValues.isEmpty() ? 1 : 0) != 0);
        this.lowerBound_ = lowerBoundValues;
        this.lowerBoundInclusive_ = lowerBoundInclusive;
        this.upperBound_ = upperBoundValues;
        this.upperBoundInclusive_ = upperBoundInclusive;
        this.isSingletonRange_ = upperBoundInclusive && lowerBoundInclusive && lowerBoundValues == upperBoundValues;
        this.hashSpec_ = hashSpec;
    }

    public static RangePartition createFromRange(Pair<List<Expr>, Boolean> lower, Pair<List<Expr>, Boolean> upper, List<KuduPartitionParam> hashSpec) {
        List lowerBoundExprs = Lists.newArrayListWithCapacity((int)1);
        boolean lowerBoundInclusive = false;
        List upperBoundExprs = Lists.newArrayListWithCapacity((int)1);
        boolean upperBoundInclusive = false;
        if (lower != null) {
            lowerBoundExprs = (List)lower.first;
            lowerBoundInclusive = (Boolean)lower.second;
        }
        if (upper != null) {
            upperBoundExprs = (List)upper.first;
            upperBoundInclusive = (Boolean)upper.second;
        }
        return new RangePartition(lowerBoundExprs, lowerBoundInclusive, upperBoundExprs, upperBoundInclusive, hashSpec);
    }

    public static RangePartition createFromValues(List<Expr> values, List<KuduPartitionParam> hashSpec) {
        return new RangePartition(values, true, values, true, hashSpec);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        throw new IllegalStateException("Not implemented");
    }

    void setPkColumnDefMap(Map<String, ColumnDef> pkColumnDefByName) {
        if (this.hashSpec_ != null) {
            for (KuduPartitionParam partitionParam : this.hashSpec_) {
                partitionParam.setPkColumnDefMap(pkColumnDefByName);
            }
        }
    }

    public void analyze(Analyzer analyzer, List<ColumnDef> partColDefs) throws AnalysisException {
        if (this.isAnalyzed_) {
            return;
        }
        this.analyzeBoundaryValues(this.lowerBound_, partColDefs, analyzer);
        if (!this.isSingletonRange_) {
            this.analyzeBoundaryValues(this.upperBound_, partColDefs, analyzer);
        }
        if (this.hashSpec_ != null) {
            for (KuduPartitionParam partitionParam : this.hashSpec_) {
                partitionParam.analyze(analyzer);
            }
        }
        this.isAnalyzed_ = true;
    }

    private void analyzeBoundaryValues(List<Expr> boundaryValues, List<ColumnDef> partColDefs, Analyzer analyzer) throws AnalysisException {
        if (!boundaryValues.isEmpty() && boundaryValues.size() != partColDefs.size()) {
            throw new AnalysisException(String.format("Number of specified range partition values is different than the number of partitioning columns: (%d vs %d). Range partition: '%s'", boundaryValues.size(), partColDefs.size(), this.toSql()));
        }
        for (int i = 0; i < boundaryValues.size(); ++i) {
            LiteralExpr literal = this.analyzeBoundaryValue(boundaryValues.get(i), partColDefs.get(i), analyzer);
            Preconditions.checkNotNull((Object)literal);
            boundaryValues.set(i, literal);
        }
    }

    private LiteralExpr analyzeBoundaryValue(Expr value, ColumnDef pkColumn, Analyzer analyzer) throws AnalysisException {
        Type literalType;
        Type colType = pkColumn.getType();
        if (!KuduUtil.isSupportedKeyType(colType)) {
            throw new AnalysisException(String.format("%s type is not allowed to be part of a PRIMARY KEY therefore not allowed for range-partitioning.", colType.toSql()));
        }
        try {
            value.analyze(analyzer);
        }
        catch (AnalysisException e) {
            throw new AnalysisException(String.format("Only constant values are allowed for range-partition bounds: %s", value.toSql()), e);
        }
        if (!value.isConstant()) {
            throw new AnalysisException(String.format("Only constant values are allowed for range-partition bounds: %s", value.toSql()));
        }
        LiteralExpr literal = LiteralExpr.createBounded(value, analyzer.getQueryCtx(), StringLiteral.MAX_STRING_LEN);
        if (literal == null) {
            throw new AnalysisException(String.format("Only constant values are allowed for range-partition bounds: %s", value.toSql()));
        }
        if (Expr.IS_NULL_VALUE.apply((Object)literal)) {
            throw new AnalysisException(String.format("Range partition values cannot be NULL. Range partition: '%s'", this.toSql()));
        }
        if (literal instanceof StringLiteral && !((StringLiteral)literal).isValidUtf8()) {
            throw new AnalysisException("Invalid String range partition value: " + literal.toSql());
        }
        if (literal.getType().isStringType() && colType.isTimestamp()) {
            CastExpr e = new CastExpr(new TypeDef(Type.TIMESTAMP), (Expr)literal);
            e.analyze(analyzer);
            literal = LiteralExpr.createBounded(e, analyzer.getQueryCtx(), StringLiteral.MAX_STRING_LEN);
            Preconditions.checkNotNull((Object)literal);
            if (Expr.IS_NULL_VALUE.apply((Object)literal)) {
                throw new AnalysisException(String.format("Range partition value %s cannot be cast to target TIMESTAMP partitioning column.", value.toSql()));
            }
        }
        if (!Type.isImplicitlyCastable(literalType = literal.getType(), colType, analyzer.getRegularCompatibilityLevel(TypeCompatibility.STRICT))) {
            throw new AnalysisException(String.format("Range partition value %s (type: %s) is not type compatible with partitioning column '%s' (type: %s).", literal.toSql(), literalType, pkColumn.getColName(), colType.toSql()));
        }
        if (!literalType.equals(colType)) {
            Expr castLiteral = literal.uncheckedCastTo(colType);
            Preconditions.checkNotNull((Object)castLiteral);
            literal = LiteralExpr.createBounded(castLiteral, analyzer.getQueryCtx(), StringLiteral.MAX_STRING_LEN);
        }
        Preconditions.checkNotNull((Object)literal);
        if (colType.isTimestamp()) {
            try {
                long unixTimeMicros = ExprUtil.utcTimestampToUnixTimeMicros(analyzer, literal);
                literal = new NumericLiteral(BigInteger.valueOf(unixTimeMicros), (Type)Type.BIGINT);
            }
            catch (InternalException e) {
                throw new AnalysisException("Error converting timestamp in range definition: " + this.toSql(), e);
            }
        }
        return literal;
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder output = new StringBuilder();
        output.append("PARTITION ");
        if (this.isSingletonRange_) {
            output.append("VALUE = ");
            if (this.lowerBound_.size() > 1) {
                output.append("(");
            }
            output.append(Expr.toSql(this.lowerBound_, options));
            if (this.lowerBound_.size() > 1) {
                output.append(")");
            }
        } else {
            if (!this.lowerBound_.isEmpty()) {
                if (this.lowerBound_.size() > 1) {
                    output.append("(");
                }
                output.append(Expr.toSql(this.lowerBound_, options));
                if (this.lowerBound_.size() > 1) {
                    output.append(")");
                }
                output.append(this.lowerBoundInclusive_ ? " <= " : " < ");
            }
            output.append("VALUES");
            if (!this.upperBound_.isEmpty()) {
                output.append(this.upperBoundInclusive_ ? " <= " : " < ");
                if (this.upperBound_.size() > 1) {
                    output.append("(");
                }
                output.append(Expr.toSql(this.upperBound_, options));
                if (this.upperBound_.size() > 1) {
                    output.append(")");
                }
            }
        }
        if (this.hashSpec_ != null) {
            boolean firstParam = true;
            for (KuduPartitionParam partitionParam : this.hashSpec_) {
                if (firstParam) {
                    firstParam = false;
                } else {
                    output.append(" ");
                }
                partitionParam.toSql(options);
            }
        }
        return output.toString();
    }

    public TRangePartition toThrift() {
        TRangePartition tRangePartition = new TRangePartition();
        for (Expr literal : this.lowerBound_) {
            tRangePartition.addToLower_bound_values(literal.treeToThrift());
        }
        if (!this.lowerBound_.isEmpty()) {
            tRangePartition.setIs_lower_bound_inclusive(this.lowerBoundInclusive_);
        }
        for (Expr literal : this.upperBound_) {
            tRangePartition.addToUpper_bound_values(literal.treeToThrift());
        }
        if (!this.upperBound_.isEmpty()) {
            tRangePartition.setIs_upper_bound_inclusive(this.upperBoundInclusive_);
        }
        Preconditions.checkState((tRangePartition.isSetLower_bound_values() || tRangePartition.isSetUpper_bound_values() ? 1 : 0) != 0);
        if (this.hashSpec_ != null) {
            for (KuduPartitionParam partitionParam : this.hashSpec_) {
                tRangePartition.addToHash_specs(partitionParam.toThrift());
            }
        }
        return tRangePartition;
    }
}

