/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;

public class QueryStringBuilder {
    public static String createTmpTableName(String dbName, String tableName) {
        return dbName + "." + tableName + "_tmp_" + UUID.randomUUID().toString().substring(0, 8);
    }

    private static String appendProps(StringBuilder builder, Map<String, String> props_) {
        builder.append(" TBLPROPERTIES (");
        for (Map.Entry<String, String> prop : props_.entrySet()) {
            builder.append("'").append(prop.getKey()).append("'='").append(prop.getValue()).append("',");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        return builder.toString();
    }

    public static class Invalidate {
        private String tableName_;

        public static Invalidate builder() {
            return new Invalidate();
        }

        public Invalidate table(String tableName) {
            this.tableName_ = tableName;
            return this;
        }

        public String build() {
            return "INVALIDATE METADATA " + this.tableName_;
        }
    }

    public static class Refresh {
        private String tableName_;

        public static Refresh builder() {
            return new Refresh();
        }

        public Refresh table(String tableName) {
            this.tableName_ = tableName;
            return this;
        }

        public String build() {
            return "REFRESH " + this.tableName_;
        }
    }

    public static class Rename {
        private String sourceTableName_;
        private String targetTableName_;

        public static Rename builder() {
            return new Rename();
        }

        public Rename source(String tableName) {
            this.sourceTableName_ = tableName;
            return this;
        }

        public Rename target(String tableName) {
            this.targetTableName_ = tableName;
            return this;
        }

        public String build() {
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            builder.append(this.sourceTableName_);
            builder.append(" RENAME TO ");
            builder.append(this.targetTableName_);
            return builder.toString();
        }
    }

    public static class SetTblProps {
        private String tableName_;
        private final Map<String, String> props_ = Maps.newHashMap();

        public static SetTblProps builder() {
            return new SetTblProps();
        }

        public SetTblProps table(String tableName) {
            this.tableName_ = tableName;
            return this;
        }

        public SetTblProps property(String k, String v) {
            this.props_.put(k, v);
            return this;
        }

        public String build() {
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            builder.append(this.tableName_);
            builder.append(" SET");
            Preconditions.checkState((this.props_.size() >= 1 ? 1 : 0) != 0);
            return QueryStringBuilder.appendProps(builder, this.props_);
        }
    }

    public static class Drop {
        private String tableName_;

        public static Drop builder() {
            return new Drop();
        }

        public Drop table(String tableName) {
            this.tableName_ = tableName;
            return this;
        }

        public String build() {
            StringBuilder builder = new StringBuilder();
            builder.append("DROP TABLE ");
            builder.append(this.tableName_);
            return builder.toString();
        }
    }

    public static class Select {
        private String selectList_;
        private String tableName_;

        public static Select builder() {
            return new Select();
        }

        public Select selectList(String selectList) {
            this.selectList_ = selectList;
            return this;
        }

        public Select from(String tableName) {
            this.tableName_ = tableName;
            return this;
        }

        public String build() {
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT " + this.selectList_ + " ");
            builder.append("FROM " + this.tableName_ + " ");
            return builder.toString();
        }
    }

    public static class Insert {
        private String tableName_;
        private boolean overwrite_;
        private Select select_;

        public static Insert builder() {
            return new Insert();
        }

        public Insert table(String tableName) {
            this.tableName_ = tableName + " ";
            return this;
        }

        public Insert overwrite(boolean overwrite) {
            this.overwrite_ = overwrite;
            return this;
        }

        public Insert select(Select select) {
            this.select_ = select;
            return this;
        }

        public String build() {
            StringBuilder builder = new StringBuilder();
            if (this.overwrite_) {
                builder.append("INSERT OVERWRITE ");
            } else {
                builder.append("INSERT INTO ");
            }
            builder.append(this.tableName_);
            builder.append(this.select_.build());
            return builder.toString();
        }
    }

    public static class Create {
        private String tableName_;
        private boolean external_;
        private boolean like_;
        private String likeFileFormat_;
        private String likeLocation_;
        private String storedAsFileFormat_;
        private String tableLocation_;
        private final Map<String, String> props_ = Maps.newHashMap();

        public static Create builder() {
            return new Create();
        }

        public Create table(String tableName, boolean external) {
            this.tableName_ = tableName;
            this.external_ = external;
            return this;
        }

        public Create like(String fileFormat, String location) {
            this.like_ = true;
            this.likeFileFormat_ = fileFormat.toUpperCase();
            this.likeLocation_ = location;
            return this;
        }

        public Create storedAs(String fileFormat) {
            this.storedAsFileFormat_ = fileFormat.toUpperCase();
            return this;
        }

        public Create tableLocation(String location) {
            this.tableLocation_ = location;
            return this;
        }

        public Create property(String k, String v) {
            this.props_.put(k, v);
            return this;
        }

        public String build() {
            StringBuilder builder = new StringBuilder();
            if (!this.external_) {
                builder.append("CREATE TABLE ");
            } else {
                builder.append("CREATE EXTERNAL TABLE ");
            }
            builder.append(this.tableName_ + " ");
            if (this.like_) {
                builder.append("LIKE " + this.likeFileFormat_ + " '" + this.likeLocation_ + "' ");
            }
            builder.append("STORED AS " + this.storedAsFileFormat_ + " ");
            builder.append("LOCATION '" + this.tableLocation_ + "'");
            if (this.props_.isEmpty()) {
                return builder.toString();
            }
            return QueryStringBuilder.appendProps(builder, this.props_);
        }
    }
}

