/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.DateLiteral;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.PartitionKeyValue;
import org.apache.impala.analysis.PartitionSpecBase;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TPartitionKeyValue;

public class PartitionSpec
extends PartitionSpecBase {
    private List<PartitionKeyValue> partitionSpec_;
    private Boolean partitionExists_;
    private Boolean analyzed_ = false;

    public PartitionSpec(List<PartitionKeyValue> partitionSpec) {
        this.partitionSpec_ = partitionSpec;
    }

    public List<PartitionKeyValue> getPartitionSpecKeyValues() {
        Preconditions.checkState((boolean)this.analyzed_);
        return this.partitionSpec_;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        if (this.table_ instanceof FeIcebergTable) {
            throw new AnalysisException(String.format("Partition clause in this statement is not supported for Iceberg tables.", new Object[0]));
        }
        for (PartitionKeyValue partitionKeyValue : this.partitionSpec_) {
            partitionKeyValue.analyze(analyzer);
        }
        HashSet<String> targetPartitionKeys = new HashSet<String>();
        for (FieldSchema fs : this.table_.getMetaStoreTable().getPartitionKeys()) {
            targetPartitionKeys.add(fs.getName().toLowerCase());
        }
        if (targetPartitionKeys.size() != this.partitionSpec_.size()) {
            throw new AnalysisException(String.format("Items in partition spec must exactly match the partition columns in the table definition: %s (%d vs %d)", this.tableName_, this.partitionSpec_.size(), targetPartitionKeys.size()));
        }
        HashSet<String> hashSet = new HashSet<String>();
        ListIterator<PartitionKeyValue> partitionIterator = this.partitionSpec_.listIterator();
        while (partitionIterator.hasNext()) {
            Type literalType;
            PartitionKeyValue pk = partitionIterator.next();
            if (!hashSet.add(pk.getColName().toLowerCase())) {
                throw new AnalysisException("Duplicate partition key name: " + pk.getColName());
            }
            Column c = this.table_.getColumn(pk.getColName());
            if (c == null) {
                throw new AnalysisException(String.format("Partition column '%s' not found in table: %s", pk.getColName(), this.tableName_));
            }
            if (!targetPartitionKeys.contains(pk.getColName().toLowerCase())) {
                throw new AnalysisException(String.format("Column '%s' is not a partition column in table: %s", pk.getColName(), this.tableName_));
            }
            if (Expr.IS_NULL_LITERAL.apply((Object)pk.getValue())) continue;
            Type colType = c.getType();
            Type compatibleType = Type.getAssignmentCompatibleType(colType, literalType = pk.getValue().getType(), analyzer.getRegularCompatibilityLevel());
            if (!compatibleType.isValid()) {
                throw new AnalysisException(String.format("Value of partition spec (column=%s) has incompatible type: '%s'. Expected type: '%s'.", pk.getColName(), literalType, colType));
            }
            if (!compatibleType.equals(colType)) {
                throw new AnalysisException(String.format("Partition key value may result in loss of precision.\nWould need to cast '%s' to '%s' for partition column: %s", pk.getValue().toSql(), colType.toString(), pk.getColName()));
            }
            if (!pk.isStatic() || !colType.isDate() || !literalType.isStringType()) continue;
            pk = new PartitionKeyValue(pk.getColName(), new DateLiteral(pk.getLiteralValue().getStringValue()));
            pk.analyze(analyzer);
            partitionIterator.set(pk);
        }
        this.partitionSpec_ = ImmutableList.copyOf(this.partitionSpec_);
        this.partitionExists_ = HdfsTable.getPartition(this.table_, this.partitionSpec_) != null;
        if (this.partitionShouldExist_ != null) {
            if (this.partitionShouldExist_.booleanValue() && !this.partitionExists_.booleanValue()) {
                throw new AnalysisException("Partition spec does not exist: (" + Joiner.on((String)", ").join(this.partitionSpec_) + ").");
            }
            if (!this.partitionShouldExist_.booleanValue() && this.partitionExists_.booleanValue()) {
                throw new AnalysisException("Partition spec already exists: (" + Joiner.on((String)", ").join(this.partitionSpec_) + ").");
            }
        }
        this.analyzed_ = true;
    }

    public List<TPartitionKeyValue> toThrift() {
        Preconditions.checkState((boolean)this.analyzed_);
        ArrayList<TPartitionKeyValue> thriftPartitionSpec = new ArrayList<TPartitionKeyValue>();
        for (PartitionKeyValue kv : this.partitionSpec_) {
            String value = PartitionKeyValue.getPartitionKeyValueString(kv.getLiteralValue(), this.getNullPartitionKeyValue());
            thriftPartitionSpec.add(new TPartitionKeyValue(kv.getColName(), value));
        }
        return thriftPartitionSpec;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        Preconditions.checkState((boolean)this.analyzed_);
        ArrayList<String> partitionSpecStr = new ArrayList<String>();
        for (PartitionKeyValue kv : this.partitionSpec_) {
            partitionSpecStr.add(kv.getColName() + "=" + kv.getValue().toSql(options));
        }
        return String.format("PARTITION (%s)", Joiner.on((String)", ").join(partitionSpecStr));
    }

    public String toCanonicalString() {
        Preconditions.checkState((boolean)this.analyzed_);
        ArrayList sortedPartitionSpec = Lists.newArrayList(this.partitionSpec_);
        Collections.sort(sortedPartitionSpec, PartitionKeyValue.getColNameComparator());
        return Joiner.on((String)",").join((Iterable)sortedPartitionSpec);
    }
}

