/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.TypeDef;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.util.FileAnalysisUtil;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;

public class OrcSchemaExtractor {
    private static final String ERROR_MSG = "Failed to convert ORC type\n%s\nto an Impala %s type:\n%s\n";

    private static TypeDescription loadOrcSchema(Path pathToFile) throws AnalysisException {
        FileAnalysisUtil.CheckIfFile(pathToFile);
        Reader reader = null;
        try {
            reader = OrcFile.createReader((Path)pathToFile, (OrcFile.ReaderOptions)new OrcFile.ReaderOptions(FileSystemUtil.getConfiguration()));
        }
        catch (IOException e) {
            throw new AnalysisException("Failed to open file as an ORC file: " + e);
        }
        return reader.getSchema();
    }

    private static Type convertPrimitiveOrcType(TypeDescription type) {
        TypeDescription.Category category = type.getCategory();
        Preconditions.checkState((category.isPrimitive() || category.equals((Object)TypeDescription.Category.TIMESTAMP_INSTANT) ? 1 : 0) != 0);
        switch (category) {
            case BINARY: {
                return Type.STRING;
            }
            case BOOLEAN: {
                return Type.BOOLEAN;
            }
            case BYTE: {
                return Type.TINYINT;
            }
            case CHAR: {
                return ScalarType.createCharType(type.getMaxLength());
            }
            case DATE: {
                return Type.DATE;
            }
            case DECIMAL: {
                return ScalarType.createDecimalType(type.getPrecision(), type.getScale());
            }
            case DOUBLE: {
                return Type.DOUBLE;
            }
            case FLOAT: {
                return Type.FLOAT;
            }
            case INT: {
                return Type.INT;
            }
            case LONG: {
                return Type.BIGINT;
            }
            case SHORT: {
                return Type.SMALLINT;
            }
            case STRING: {
                return Type.STRING;
            }
            case TIMESTAMP: {
                return Type.TIMESTAMP;
            }
            case TIMESTAMP_INSTANT: {
                return Type.TIMESTAMP;
            }
            case VARCHAR: {
                return ScalarType.createVarcharType(type.getMaxLength());
            }
        }
        Preconditions.checkState((boolean)false, (Object)("Unexpected ORC primitive type: " + category.getName()));
        return null;
    }

    private static ArrayType convertArray(TypeDescription listType) throws AnalysisException {
        Preconditions.checkState((listType.getChildren().size() == 1 ? 1 : 0) != 0);
        return new ArrayType(OrcSchemaExtractor.convertOrcType((TypeDescription)listType.getChildren().get(0)));
    }

    private static MapType convertMap(TypeDescription mapType) throws AnalysisException {
        Preconditions.checkState((mapType.getChildren().size() == 2 ? 1 : 0) != 0);
        TypeDescription key = (TypeDescription)mapType.getChildren().get(0);
        TypeDescription value = (TypeDescription)mapType.getChildren().get(1);
        if (!key.getCategory().isPrimitive()) {
            throw new AnalysisException(String.format(ERROR_MSG, mapType.toString(), "MAP", "The key type of the MAP type must be primitive."));
        }
        return new MapType(OrcSchemaExtractor.convertOrcType(key), OrcSchemaExtractor.convertOrcType(value));
    }

    private static StructType convertStruct(TypeDescription structType) throws AnalysisException {
        ArrayList<StructField> structFields = new ArrayList<StructField>();
        List fieldNames = structType.getFieldNames();
        List subTypes = structType.getChildren();
        Preconditions.checkState((subTypes.size() == fieldNames.size() ? 1 : 0) != 0);
        for (int i = 0; i < subTypes.size(); ++i) {
            StructField f = new StructField((String)fieldNames.get(i), OrcSchemaExtractor.convertOrcType((TypeDescription)subTypes.get(i)));
            structFields.add(f);
        }
        return new StructType(structFields);
    }

    private static Type convertComplexOrcType(TypeDescription type) throws AnalysisException {
        TypeDescription.Category category = type.getCategory();
        Preconditions.checkState((!category.isPrimitive() ? 1 : 0) != 0);
        switch (category) {
            case LIST: {
                return OrcSchemaExtractor.convertArray(type);
            }
            case MAP: {
                return OrcSchemaExtractor.convertMap(type);
            }
            case STRUCT: {
                return OrcSchemaExtractor.convertStruct(type);
            }
            case UNION: {
                throw new AnalysisException("Unsupported ORC type UNION for field " + category.getName());
            }
        }
        Preconditions.checkState((boolean)false, (Object)("Unexpected ORC primitive type: " + category.getName()));
        return null;
    }

    private static Type convertOrcType(TypeDescription type) throws AnalysisException {
        TypeDescription.Category category = type.getCategory();
        if (category.isPrimitive() || category.equals((Object)TypeDescription.Category.TIMESTAMP_INSTANT)) {
            return OrcSchemaExtractor.convertPrimitiveOrcType(type);
        }
        return OrcSchemaExtractor.convertComplexOrcType(type);
    }

    public static List<ColumnDef> extract(HdfsUri location) throws AnalysisException {
        ArrayList<ColumnDef> schema = new ArrayList<ColumnDef>();
        TypeDescription orcSchema = OrcSchemaExtractor.loadOrcSchema(location.getPath());
        List subTypes = orcSchema.getChildren();
        List fieldNames = orcSchema.getFieldNames();
        Preconditions.checkState((subTypes.size() == fieldNames.size() ? 1 : 0) != 0);
        for (int i = 0; i < subTypes.size(); ++i) {
            TypeDescription orcType = (TypeDescription)subTypes.get(i);
            Type type = OrcSchemaExtractor.convertOrcType(orcType);
            Preconditions.checkNotNull((Object)type);
            String colName = (String)fieldNames.get(i);
            HashMap<ColumnDef.Option, Object> option = new HashMap<ColumnDef.Option, Object>();
            option.put(ColumnDef.Option.COMMENT, "Inferred from ORC file.");
            schema.add(new ColumnDef(colName, new TypeDef(type), option));
        }
        return schema;
    }
}

