/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.impala.analysis.AlterTableSetTblProperties;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.DmlStatementBase;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FromClause;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SelectList;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.IcebergContentFileStore;
import org.apache.impala.catalog.IcebergFileDescriptor;
import org.apache.impala.catalog.iceberg.GroupedContentFiles;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.TableSink;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.thrift.TIcebergOptimizationMode;
import org.apache.impala.thrift.TIcebergPartition;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.util.ExprUtil;
import org.apache.impala.util.IcebergOptimizeFileFilter;
import org.apache.impala.util.IcebergUtil;

public class OptimizeStmt
extends DmlStatementBase {
    private final TableName originalTableName_;
    private final long fileSizeThreshold_;
    private TableName tableName_;
    private TableRef tableRef_;
    private SelectStmt sourceStmt_;
    private List<Expr> resultExprs_ = new ArrayList<Expr>();
    private List<Expr> sortExprs_ = new ArrayList<Expr>();
    private List<Integer> sortColumns_;
    private TSortingOrder sortingOrder_ = TSortingOrder.LEXICAL;
    protected List<Expr> partitionKeyExprs_ = new ArrayList<Expr>();
    private Set<String> selectedIcebergFilePaths_ = new HashSet<String>();
    private TIcebergOptimizationMode mode_;

    public OptimizeStmt(TableName tableName) {
        this.originalTableName_ = this.tableName_ = tableName;
        this.fileSizeThreshold_ = -1L;
    }

    public OptimizeStmt(TableName tableName, int fileSizeMb) {
        this.originalTableName_ = this.tableName_ = tableName;
        this.fileSizeThreshold_ = (long)fileSizeMb * 0x100000L;
    }

    private OptimizeStmt(OptimizeStmt other) {
        super(other);
        this.tableName_ = other.tableName_;
        this.originalTableName_ = other.originalTableName_;
        this.fileSizeThreshold_ = other.fileSizeThreshold_;
        this.tableRef_ = other.tableRef_;
        this.sourceStmt_ = other.sourceStmt_;
        this.resultExprs_ = other.resultExprs_;
        this.sortExprs_ = other.sortExprs_;
        this.sortColumns_ = other.sortColumns_;
        this.sortingOrder_ = other.sortingOrder_;
        this.partitionKeyExprs_ = other.partitionKeyExprs_;
        this.selectedIcebergFilePaths_ = other.selectedIcebergFilePaths_;
        this.mode_ = other.mode_;
    }

    @Override
    public OptimizeStmt clone() {
        return new OptimizeStmt(this);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        Preconditions.checkState((this.table_ == null ? 1 : 0) != 0);
        if (!this.tableName_.isFullyQualified()) {
            this.tableName_ = new TableName(analyzer.getDefaultDb(), this.tableName_.getTbl());
        }
        this.tableRef_ = TableRef.newTableRef(analyzer, this.tableName_.toPath(), null);
        this.table_ = analyzer.getTable(this.tableName_, Privilege.ALL);
        if (!(this.table_ instanceof FeIcebergTable)) {
            throw new AnalysisException("OPTIMIZE is only supported for Iceberg tables.");
        }
        FeIcebergTable iceTable = (FeIcebergTable)this.table_;
        IcebergUtil.validateIcebergTableForInsert(iceTable);
        this.selectFiles(iceTable);
        this.prepareExpressions(analyzer);
        this.createSourceStmt(analyzer);
        this.setMaxTableSinks(this.analyzer_.getQueryOptions().getMax_fs_writers());
        this.analyzeSortColumns();
        analyzer.getDescTbl().setTargetTable(this.table_);
    }

    @Override
    public void reset() {
        super.reset();
        this.tableName_ = this.originalTableName_;
        this.tableRef_.reset();
        this.sourceStmt_.reset();
        this.resultExprs_.clear();
        this.sortExprs_.clear();
        this.sortColumns_.clear();
        this.sortingOrder_ = TSortingOrder.LEXICAL;
        this.partitionKeyExprs_.clear();
        this.selectedIcebergFilePaths_.clear();
        this.mode_ = null;
    }

    @Override
    public DataSink createDataSink() {
        TableSink tableSink = TableSink.create(this.table_, TableSink.Op.INSERT, this.partitionKeyExprs_, this.resultExprs_, new ArrayList<Integer>(), false, true, new Pair<List<Integer>, TSortingOrder>(this.sortColumns_, this.sortingOrder_), -1L, null, this.maxTableSinks_);
        return tableSink;
    }

    private void selectFiles(FeIcebergTable iceTable) throws AnalysisException {
        try {
            GroupedContentFiles contentFiles = IcebergUtil.getIcebergFiles(iceTable, Lists.newArrayList(), null);
            if (contentFiles.isEmpty()) {
                this.mode_ = TIcebergOptimizationMode.NOOP;
            } else {
                IcebergOptimizeFileFilter.FilterArgs args = new IcebergOptimizeFileFilter.FilterArgs(contentFiles, this.fileSizeThreshold_);
                IcebergOptimizeFileFilter.FileFilteringResult filterResult = IcebergOptimizeFileFilter.filterFilesBySize(args);
                this.mode_ = filterResult.getOptimizationMode();
                if (this.mode_ == TIcebergOptimizationMode.PARTIAL) {
                    List<IcebergFileDescriptor> selectedDataFilesWithoutDeletes = this.dataFilesWithoutDeletesToFileDescriptors(filterResult.getSelectedFilesWithoutDeletes(), iceTable);
                    this.tableRef_.setSelectedDataFilesForOptimize(selectedDataFilesWithoutDeletes);
                    this.collectAbsolutePaths(selectedDataFilesWithoutDeletes);
                }
            }
        }
        catch (Exception e) {
            throw new AnalysisException(e);
        }
    }

    private List<IcebergFileDescriptor> dataFilesWithoutDeletesToFileDescriptors(List<DataFile> contentFiles, FeIcebergTable iceTable) throws IOException, ImpalaRuntimeException {
        GroupedContentFiles selectedContentFiles = new GroupedContentFiles();
        selectedContentFiles.dataFilesWithoutDeletes = contentFiles;
        IcebergContentFileStore selectedFiles = new IcebergContentFileStore(iceTable.getIcebergApiTable(), iceTable.getContentFileStore().getDataFilesWithoutDeletes(), selectedContentFiles, new HashMap<TIcebergPartition, Integer>());
        return selectedFiles.getDataFilesWithoutDeletes();
    }

    private void collectAbsolutePaths(List<IcebergFileDescriptor> selectedFiles) {
        for (IcebergFileDescriptor fileDesc : selectedFiles) {
            org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path(fileDesc.getAbsolutePath(((FeIcebergTable)this.table_).getHdfsBaseDir()));
            this.selectedIcebergFilePaths_.add(path.toUri().toString());
        }
    }

    private void createSourceStmt(Analyzer analyzer) throws AnalysisException {
        List<TableRef> tableRefs = Arrays.asList(this.tableRef_);
        List<Column> columns = this.table_.getColumns();
        ArrayList<SelectListItem> selectListItems = new ArrayList<SelectListItem>();
        for (Column col : columns) {
            selectListItems.add(new SelectListItem(this.createSlotRef(analyzer, col.getName()), null));
        }
        SelectList selectList = new SelectList(selectListItems);
        this.sourceStmt_ = new SelectStmt(selectList, new FromClause(tableRefs), null, null, null, null, null);
        this.sourceStmt_.analyze(analyzer);
        this.sourceStmt_.getSelectList().getItems().addAll(ExprUtil.exprsAsSelectList(this.partitionKeyExprs_));
    }

    private void prepareExpressions(Analyzer analyzer) throws AnalysisException {
        List<Column> columns = this.table_.getColumns();
        for (Column col : columns) {
            this.resultExprs_.add(this.createSlotRef(analyzer, col.getName()));
        }
        IcebergUtil.populatePartitionExprs(analyzer, null, columns, this.resultExprs_, (FeIcebergTable)this.table_, this.partitionKeyExprs_, null);
    }

    private SlotRef createSlotRef(Analyzer analyzer, String colName) throws AnalysisException {
        List<String> path = Path.createRawPath(this.tableRef_.getUniqueAlias(), colName);
        SlotRef ref = new SlotRef(path);
        ref.analyze(analyzer);
        return ref;
    }

    private void analyzeSortColumns() throws AnalysisException {
        Pair<List<Integer>, TSortingOrder> sortProperties = AlterTableSetTblProperties.analyzeSortColumns(this.table_, this.table_.getMetaStoreTable().getParameters());
        this.sortColumns_ = (List)sortProperties.first;
        this.sortingOrder_ = (TSortingOrder)((Object)sortProperties.second);
        for (Integer colIdx : this.sortColumns_) {
            this.sortExprs_.add(this.resultExprs_.get(colIdx));
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        if (options == ToSqlOptions.DEFAULT) {
            return "OPTIMIZE TABLE" + this.originalTableName_.toSql();
        }
        return "OPTIMIZE TABLE" + this.tableName_.toSql();
    }

    public QueryStmt getQueryStmt() {
        return this.sourceStmt_;
    }

    @Override
    public void substituteResultExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.sourceStmt_.substituteResultExprs(smap, analyzer);
        this.resultExprs_ = Expr.substituteList(this.resultExprs_, smap, analyzer, true);
        this.partitionKeyExprs_ = Expr.substituteList(this.partitionKeyExprs_, smap, analyzer, true);
        this.sortExprs_ = Expr.substituteList(this.sortExprs_, smap, analyzer, true);
    }

    @Override
    public TSortingOrder getSortingOrder() {
        return this.sortingOrder_;
    }

    @Override
    public List<Expr> getSortExprs() {
        return this.sortExprs_;
    }

    @Override
    public List<Expr> getPartitionKeyExprs() {
        return this.partitionKeyExprs_;
    }

    @Override
    public List<Expr> getResultExprs() {
        return this.resultExprs_;
    }

    public TIcebergOptimizationMode getOptimizationMode() {
        Preconditions.checkState((boolean)this.isAnalyzed());
        return this.mode_;
    }

    public Set<String> getSelectedIcebergFilePaths() {
        Preconditions.checkState((boolean)this.isAnalyzed());
        return this.selectedIcebergFilePaths_;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
    }

    @Override
    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        Preconditions.checkState((boolean)this.isAnalyzed());
        this.sourceStmt_.rewriteExprs(rewriter);
    }
}

