/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;

public class NullLiteral
extends LiteralExpr {
    public NullLiteral() {
        this.type_ = Type.NULL;
        this.selectivity_ = 0.0;
    }

    protected NullLiteral(NullLiteral other) {
        super(other);
    }

    public static NullLiteral create(Type type) {
        NullLiteral l = new NullLiteral();
        l.analyzeNoThrow(null);
        l.uncheckedCastTo(type);
        return l;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        return this.getStringValue();
    }

    @Override
    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)super.debugString()).toString();
    }

    @Override
    public String getStringValue() {
        return "NULL";
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType) {
        Preconditions.checkState((boolean)targetType.isValid());
        this.type_ = targetType;
        return this;
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType, TypeCompatibility compatibility) {
        return this.uncheckedCastTo(targetType);
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.NULL_LITERAL;
    }

    @Override
    public Expr clone() {
        return new NullLiteral(this);
    }

    @Override
    protected void resetAnalysisState() {
        super.resetAnalysisState();
        this.type_ = Type.NULL;
    }
}

