/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.DmlStatementBase;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FromClause;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.ModifyImpl;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Pair;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.thrift.TSortingOrder;

public abstract class ModifyStmt
extends DmlStatementBase {
    protected final List<Pair<SlotRef, Expr>> assignments_;
    protected Expr wherePredicate_;
    protected final List<String> targetTablePath_;
    protected TableRef targetTableRef_;
    protected FromClause fromClause_;
    protected ModifyImpl modifyImpl_;
    protected String sqlString_;

    public ModifyStmt(List<String> targetTablePath, FromClause fromClause, List<Pair<SlotRef, Expr>> assignmentExprs, Expr wherePredicate) {
        this.targetTablePath_ = (List)Preconditions.checkNotNull(targetTablePath);
        this.fromClause_ = (FromClause)Preconditions.checkNotNull((Object)fromClause);
        this.assignments_ = (List)Preconditions.checkNotNull(assignmentExprs);
        this.wherePredicate_ = wherePredicate;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.targetTablePath_, null));
        this.fromClause_.collectTableRefs(tblRefs);
        if (this.wherePredicate_ != null) {
            ArrayList subqueries = new ArrayList();
            this.wherePredicate_.collect(Subquery.class, subqueries);
            for (Subquery sq : subqueries) {
                sq.getStatement().collectTableRefs(tblRefs);
            }
        }
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        this.fromClause_.analyze(analyzer);
        List<Path> candidates = analyzer.getTupleDescPaths(this.targetTablePath_);
        if (candidates.isEmpty()) {
            throw new AnalysisException(String.format("'%s' is not a valid table alias or reference.", Joiner.on((String)".").join(this.targetTablePath_)));
        }
        Preconditions.checkState((candidates.size() == 1 ? 1 : 0) != 0);
        Path path = candidates.get(0);
        path.resolve();
        if (!path.isResolved()) {
            throw new AnalysisException(String.format("Cannot resolve path '%s' for DML statement.", path.toString()));
        }
        if (path.destTupleDesc() == null) {
            throw new AnalysisException(String.format("'%s' is not a table alias. Using the FROM clause requires the target table to be a table alias.", Joiner.on((String)".").join(this.targetTablePath_)));
        }
        this.targetTableRef_ = analyzer.getTableRef(path.getRootDesc().getId());
        if (this.targetTableRef_ instanceof InlineViewRef) {
            throw new AnalysisException(String.format("Cannot modify view: '%s'", this.targetTableRef_.toSql()));
        }
        Preconditions.checkNotNull((Object)this.targetTableRef_);
        FeTable dstTbl = this.targetTableRef_.getTable();
        if (!(dstTbl instanceof FeKuduTable) && !(dstTbl instanceof FeIcebergTable)) {
            throw new AnalysisException(String.format("Impala only supports modifying Kudu and Iceberg tables, but the following table is neither: %s", dstTbl.getFullName()));
        }
        if (dstTbl instanceof FeIcebergTable) {
            this.setMaxTableSinks(this.analyzer_.getQueryOptions().getMax_fs_writers());
        }
        analyzer.registerAuthAndAuditEvent(dstTbl, Privilege.ALL);
        this.table_ = dstTbl;
        if (this.modifyImpl_ == null) {
            this.createModifyImpl();
        }
        this.modifyImpl_.analyze(analyzer);
        this.sqlString_ = this.toSql();
        this.modifyImpl_.createSourceStmt(analyzer);
        analyzer.getDescTbl().setTargetTable(this.table_);
        this.analyzer_.addWhereColumns(this.wherePredicate_);
    }

    protected abstract void createModifyImpl();

    @Override
    public void reset() {
        super.reset();
        this.fromClause_.reset();
        this.modifyImpl_.reset();
    }

    @Override
    public List<Expr> getPartitionKeyExprs() {
        return this.modifyImpl_.getPartitionKeyExprs();
    }

    @Override
    public List<Expr> getSortExprs() {
        return this.modifyImpl_.getSortExprs();
    }

    public Expr getWherePredicate() {
        return this.wherePredicate_;
    }

    public List<Pair<SlotRef, Expr>> getAssignments() {
        return this.assignments_;
    }

    @Override
    public TSortingOrder getSortingOrder() {
        return this.modifyImpl_.getSortingOrder();
    }

    @Override
    public boolean resolveTableMask(Analyzer analyzer) throws AnalysisException {
        return this.getQueryStmt().resolveTableMask(analyzer);
    }

    @Override
    public List<Expr> getResultExprs() {
        return this.modifyImpl_.getQueryStmt().getResultExprs();
    }

    @Override
    public void castResultExprs(List<Type> types) throws AnalysisException {
        this.modifyImpl_.castResultExprs(types);
    }

    @Override
    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        Preconditions.checkState((boolean)this.isAnalyzed());
        for (Pair<SlotRef, Expr> assignment : this.assignments_) {
            assignment.second = rewriter.rewrite((Expr)assignment.second, this.analyzer_);
        }
        this.modifyImpl_.rewriteExprs(rewriter);
    }

    public QueryStmt getQueryStmt() {
        return this.modifyImpl_.getQueryStmt();
    }

    public boolean isTargetTableKuduTable() {
        return this.table_ instanceof FeKuduTable;
    }

    @Override
    public abstract String toSql(ToSqlOptions var1);
}

