/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.ModifyStmt;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SelectList;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.UpdateStmt;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.planner.DataSink;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.thrift.TSortingOrder;

abstract class ModifyImpl {
    ModifyStmt modifyStmt_;
    protected SelectStmt sourceStmt_;

    abstract void addCastsToAssignmentsInSourceStmt(Analyzer var1) throws AnalysisException;

    abstract void analyze(Analyzer var1) throws AnalysisException;

    abstract void buildAndValidateSelectExprs(Analyzer var1, List<SelectListItem> var2) throws AnalysisException;

    abstract DataSink createDataSink();

    void substituteResultExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.sourceStmt_.substituteResultExprs(smap, analyzer);
    }

    public ModifyImpl(ModifyStmt modifyStmt) {
        this.modifyStmt_ = modifyStmt;
    }

    public void reset() {
        if (this.sourceStmt_ != null) {
            this.sourceStmt_.reset();
        }
    }

    protected void createSourceStmt(Analyzer analyzer) throws AnalysisException {
        if (this.sourceStmt_ == null) {
            ArrayList<SelectListItem> selectList = new ArrayList<SelectListItem>();
            this.buildAndValidateSelectExprs(analyzer, selectList);
            if (this.modifyStmt_ instanceof UpdateStmt) {
                ((UpdateStmt)this.modifyStmt_).rewriteWherePredicate(analyzer);
            }
            this.sourceStmt_ = new SelectStmt(new SelectList(selectList), this.modifyStmt_.fromClause_, this.modifyStmt_.wherePredicate_, null, null, null, null);
            this.sourceStmt_.analyze(analyzer);
            this.addCastsToAssignmentsInSourceStmt(analyzer);
        } else {
            this.sourceStmt_.analyze(analyzer);
        }
    }

    public abstract List<Expr> getPartitionKeyExprs();

    public List<Expr> getSortExprs() {
        return Collections.emptyList();
    }

    public QueryStmt getQueryStmt() {
        return this.sourceStmt_;
    }

    public void castResultExprs(List<Type> types) throws AnalysisException {
        this.sourceStmt_.castResultExprs(types);
    }

    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        this.sourceStmt_.rewriteExprs(rewriter);
    }

    public TSortingOrder getSortingOrder() {
        return TSortingOrder.LEXICAL;
    }
}

