/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.DmlStatementBase;
import org.apache.impala.analysis.MergeUpdate;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Column;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Pair;

public class MergeUpdateStar
extends MergeUpdate {
    public MergeUpdateStar() {
        super(Collections.emptyList());
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.assignmentExprs_ = Lists.newArrayList();
        Preconditions.checkNotNull((Object)this.targetTableColumns_);
        Preconditions.checkNotNull((Object)this.sourceTableRef_);
        List<String> sourceColumnLabels = this.getSourceColumnLabels();
        String tableName = this.sourceTableRef_.getUniqueAlias();
        this.checkSize(sourceColumnLabels);
        for (int i = 0; i < this.targetTableColumns_.size(); ++i) {
            SlotRef sourceExpr = DmlStatementBase.createSlotRef(analyzer, tableName, sourceColumnLabels.get(i));
            SlotRef targetColumn = DmlStatementBase.createSlotRef(analyzer, this.targetTableRef_.getUniqueAlias(), ((Column)this.targetTableColumns_.get(i)).getName());
            this.assignmentExprs_.add(Pair.create(targetColumn, sourceExpr));
        }
        super.analyze(analyzer);
    }

    private void checkSize(List<String> sourceColumnLabels) throws AnalysisException {
        int sourceColSize = sourceColumnLabels.size();
        int targetColSize = this.targetTableColumns_.size();
        if (targetColSize < sourceColSize) {
            throw new AnalysisException(String.format("Target table has fewer columns (%d) than the source expression (%d): %s", targetColSize, sourceColSize, this.toSql()));
        }
        if (targetColSize > sourceColSize) {
            throw new AnalysisException(String.format("Target table has more columns (%d) than the source expression (%d): %s", targetColSize, sourceColSize, this.toSql()));
        }
    }

    @Override
    protected String listAssignments(ToSqlOptions options) {
        List<String> sourceColumnLabels = this.getSourceColumnLabels();
        int minAvailableItems = Math.min(sourceColumnLabels.size(), this.targetTableColumns_.size());
        StringJoiner assignmentJoiner = new StringJoiner(", ");
        for (int i = 0; i < minAvailableItems; ++i) {
            assignmentJoiner.add(String.format("%s = %s", ((Column)this.targetTableColumns_.get(i)).getName(), sourceColumnLabels.get(i)));
        }
        return assignmentJoiner.toString();
    }
}

