/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.DmlStatementBase;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.InsertStmt;
import org.apache.impala.analysis.MergeCase;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Column;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TMergeCaseType;
import org.apache.impala.thrift.TMergeMatchType;

public class MergeUpdate
extends MergeCase {
    protected List<Pair<SlotRef, Expr>> assignmentExprs_;

    public MergeUpdate(List<Pair<SlotRef, Expr>> assignmentExprs) {
        this.assignmentExprs_ = assignmentExprs;
    }

    protected MergeUpdate(List<Expr> resultExprs, List<Expr> filterExprs, TableName targetTableName, List<Column> targetTableColumns, TableRef targetTableRef, List<Pair<SlotRef, Expr>> assignmentExprs, TMergeMatchType matchType, TableRef sourceTableRef) {
        super(resultExprs, filterExprs, targetTableName, targetTableColumns, targetTableRef, matchType, sourceTableRef);
        this.assignmentExprs_ = assignmentExprs;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        HashMap<Integer, Expr> colToExprs = new HashMap<Integer, Expr>();
        for (Pair<SlotRef, Expr> entry : this.assignmentExprs_) {
            SlotRef lhs = (SlotRef)entry.first;
            Expr rhs = (Expr)entry.second;
            lhs = this.disambiguateLhs(lhs);
            rhs.analyze(analyzer);
            Preconditions.checkNotNull((Object)this.targetTableRef_);
            DmlStatementBase.checkCorrectTargetTable(lhs, rhs, this.targetTableRef_);
            DmlStatementBase.checkLhsIsColumnRef(lhs, rhs);
            DmlStatementBase.checkSubQuery(lhs, rhs);
            Preconditions.checkState((boolean)lhs.isAnalyzed());
            Column c = lhs.getResolvedPath().destColumn();
            rhs = DmlStatementBase.checkTypeCompatibility(analyzer, c, rhs, this.targetTableRef_);
            DmlStatementBase.checkLhsOnlyAppearsOnce(colToExprs, c, lhs, rhs);
            colToExprs.put(c.getPosition(), rhs);
        }
        this.resultExprs_ = Lists.newArrayList();
        Preconditions.checkNotNull((Object)this.targetTableColumns_);
        Preconditions.checkNotNull((Object)this.targetTableName_);
        for (Column col : this.targetTableColumns_) {
            InsertStmt.checkSupportedColumn(col, "MERGE UPDATE", this.targetTableName_);
            Expr expr = (Expr)colToExprs.get(col.getPosition());
            if (expr == null) {
                expr = DmlStatementBase.createSlotRef(analyzer, this.targetTableRef_.getUniqueAlias(), col.getName());
            }
            this.resultExprs_.add(expr);
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        String parent = super.toSql(options);
        return parent + "UPDATE SET " + this.listAssignments(options);
    }

    protected String listAssignments(ToSqlOptions options) {
        StringJoiner assignmentJoiner = new StringJoiner(", ");
        for (Pair<SlotRef, Expr> entry : this.assignmentExprs_) {
            assignmentJoiner.add(String.format("%s = %s", ((SlotRef)entry.first).toSql(options), ((Expr)entry.second).toSql(options)));
        }
        return assignmentJoiner.toString();
    }

    @Override
    public TMergeCaseType caseType() {
        return TMergeCaseType.UPDATE;
    }

    private SlotRef disambiguateLhs(SlotRef lhs) throws AnalysisException {
        try {
            lhs.analyze(this.analyzer_);
            return lhs;
        }
        catch (AnalysisException e) {
            List<String> rawPath = lhs.rawPath_;
            if (rawPath.size() != 1) {
                throw new AnalysisException(String.format("Could not resolve column/field reference: '%s'", lhs));
            }
            String columnName = rawPath.get(0);
            return DmlStatementBase.createSlotRef(this.analyzer_, this.targetTableRef_.getUniqueAlias(), columnName);
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (Pair<SlotRef, Expr> expr : this.assignmentExprs_) {
            ((SlotRef)expr.first).reset();
            ((Expr)expr.second).reset();
        }
    }

    @Override
    public MergeUpdate clone() {
        return new MergeUpdate(Expr.cloneList(this.resultExprs_), Expr.cloneList(this.getFilterExprs()), this.targetTableName_, this.targetTableColumns_, this.targetTableRef_, this.assignmentExprs_, this.matchType_, this.sourceTableRef_);
    }
}

