/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.DmlStatementBase;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.IcebergMergeImpl;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.MergeCase;
import org.apache.impala.analysis.MergeImpl;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.thrift.TMergeCaseType;
import org.apache.impala.thrift.TMergeMatchType;
import org.apache.impala.thrift.TSortingOrder;

public class MergeStmt
extends DmlStatementBase {
    private static final int MERGE_CASE_LIMIT = 1000;
    private TableRef targetTableRef_;
    private TableRef sourceTableRef_;
    private final List<MergeCase> cases_;
    private final Expr onClause_;
    private MergeImpl impl_;

    public MergeStmt(TableRef target, TableRef source, Expr onClause, List<MergeCase> cases) {
        this.targetTableRef_ = target;
        this.sourceTableRef_ = source;
        this.onClause_ = onClause;
        this.cases_ = cases;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        if (this.targetTableRef_ instanceof InlineViewRef) {
            throw new AnalysisException(String.format("Cannot modify view: %s", this.targetTableRef_.toSql()));
        }
        if (this.cases_.size() > 1000) {
            String sql = this.toSql();
            String sqlSubstr = sql.substring(0, Math.min(80, sql.length()));
            throw new AnalysisException(String.format("Exceeded the maximum number of cases (%s).\nStatement has %s cases:\n%s...", 1000, this.cases_.size(), sqlSubstr));
        }
        this.sourceTableRef_ = analyzer.resolveTableRef(this.sourceTableRef_);
        this.targetTableRef_ = analyzer.resolveTableRef(this.targetTableRef_);
        this.table_ = this.targetTableRef_.getTable();
        if (this.impl_ == null) {
            if (this.table_ instanceof FeIcebergTable) {
                this.impl_ = new IcebergMergeImpl(this, this.targetTableRef_, this.sourceTableRef_, this.onClause_);
                this.setMaxTableSinks(this.analyzer_.getQueryOptions().getMax_fs_writers());
            } else {
                throw new AnalysisException(String.format("Target table must be an Iceberg table: %s", this.table_.getFullName()));
            }
        }
        this.impl_.analyze(analyzer);
        for (MergeCase mergeCase : this.getCases()) {
            mergeCase.setParent(this);
            mergeCase.analyze(analyzer);
        }
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        super.collectTableRefs(tblRefs);
        if (this.sourceTableRef_ instanceof InlineViewRef) {
            ((InlineViewRef)this.sourceTableRef_).queryStmt_.collectTableRefs(tblRefs);
        } else {
            tblRefs.add(this.sourceTableRef_);
        }
        if (!(this.targetTableRef_ instanceof InlineViewRef)) {
            tblRefs.add(this.targetTableRef_);
        }
    }

    @Override
    public DataSink createDataSink() {
        return this.impl_.createDataSink();
    }

    @Override
    public void substituteResultExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.impl_.substituteResultExprs(smap, analyzer);
    }

    @Override
    public List<Expr> getResultExprs() {
        return this.impl_.getResultExprs();
    }

    @Override
    public List<Expr> getPartitionKeyExprs() {
        return this.impl_.getPartitionKeyExprs();
    }

    @Override
    public List<Expr> getSortExprs() {
        return this.impl_.getSortExprs();
    }

    @Override
    public TSortingOrder getSortingOrder() {
        return this.impl_.getSortingOrder();
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("MERGE INTO ");
        builder.append(this.targetTableRef_.toSql(options));
        builder.append(" USING ");
        builder.append(this.sourceTableRef_.toSql(options));
        builder.append(" ON ");
        builder.append(this.onClause_.toSql(options));
        for (MergeCase mergeCase : this.cases_) {
            builder.append(" ");
            builder.append(mergeCase.toSql(options));
        }
        return builder.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.impl_.reset();
        this.onClause_.reset();
        for (MergeCase mergeCase : this.cases_) {
            mergeCase.reset();
        }
    }

    @Override
    public boolean resolveTableMask(Analyzer analyzer) throws AnalysisException {
        return this.getQueryStmt().resolveTableMask(analyzer);
    }

    @Override
    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        this.getQueryStmt().rewriteExprs(rewriter);
        for (MergeCase mergeCase : this.cases_) {
            mergeCase.rewriteExprs(rewriter);
        }
    }

    public QueryStmt getQueryStmt() {
        return this.impl_.getQueryStmt();
    }

    public TableRef getTargetTableRef() {
        return this.targetTableRef_;
    }

    public PlanNode getPlanNode(PlannerContext ctx, PlanNode child, Analyzer analyzer) throws ImpalaException {
        return this.impl_.getPlanNode(ctx, child, analyzer);
    }

    public List<MergeCase> getCases() {
        return this.cases_;
    }

    public boolean hasOnlyMatchedCases() {
        return this.cases_.stream().allMatch(mergeCase -> mergeCase.matchType().equals((Object)TMergeMatchType.MATCHED));
    }

    public boolean hasOnlyInsertCases() {
        return this.cases_.stream().allMatch(mergeCase -> mergeCase.caseType().equals((Object)TMergeCaseType.INSERT));
    }

    public boolean hasOnlyDeleteCases() {
        return this.cases_.stream().allMatch(mergeCase -> mergeCase.caseType().equals((Object)TMergeCaseType.DELETE));
    }

    public TableRef getSourceTableRef() {
        return this.sourceTableRef_;
    }
}

