/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.DmlStatementBase;
import org.apache.impala.analysis.MergeInsert;
import org.apache.impala.analysis.SelectList;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.catalog.Column;
import org.apache.impala.common.AnalysisException;

public class MergeInsertStar
extends MergeInsert {
    public MergeInsertStar() {
        super(Collections.emptyList(), new SelectList());
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkNotNull((Object)this.targetTableColumns_);
        Preconditions.checkNotNull((Object)this.sourceTableRef_);
        List<String> sourceColumnLabels = this.getSourceColumnLabels();
        String sourceAlias = this.sourceTableRef_.getUniqueAlias();
        this.columnPermutation_ = this.targetTableColumns_.stream().map(Column::getName).collect(Collectors.toList());
        for (String column : sourceColumnLabels) {
            SlotRef slotRef = DmlStatementBase.createSlotRef(analyzer, sourceAlias, column);
            this.selectList_.getItems().add(new SelectListItem(slotRef, column));
        }
        super.analyze(analyzer);
    }

    @Override
    protected String moreColumnsMessageTemplate() {
        return "%s more columns (%d) than the source expression (%d): %s";
    }

    @Override
    protected String fewerColumnsMessageTemplate() {
        return "%s fewer columns (%d) than the source expression (%d): %s";
    }
}

