/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.InsertStmt;
import org.apache.impala.analysis.MergeCase;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.SelectList;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Column;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TMergeCaseType;
import org.apache.impala.thrift.TMergeMatchType;

public class MergeInsert
extends MergeCase {
    protected List<String> columnPermutation_;
    protected final SelectList selectList_;

    public MergeInsert(List<String> columnPermutation, SelectList selectList) {
        this.columnPermutation_ = columnPermutation;
        this.selectList_ = selectList;
    }

    protected MergeInsert(List<Expr> resultExprs, List<Expr> filterExprs, TableName targetTableName, List<Column> targetTableColumns, TableRef targetTableRef, List<String> columnPermutation, SelectList selectList, TMergeMatchType matchType, TableRef sourceTableRef) {
        super(resultExprs, filterExprs, targetTableName, targetTableColumns, targetTableRef, matchType, sourceTableRef);
        this.columnPermutation_ = columnPermutation;
        this.selectList_ = selectList;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        for (SelectListItem selectListItem : this.selectList_.getItems()) {
            if (selectListItem.isStar()) {
                throw new AnalysisException(String.format("Invalid expression: %s", selectListItem));
            }
            selectListItem.getExpr().analyze(this.analyzer_);
        }
        this.resultExprs_ = this.analyzeColumnPermutation();
        for (Expr expr : this.resultExprs_) {
            expr.analyze(analyzer);
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        String parent = super.toSql(options);
        StringBuilder builder = new StringBuilder(parent);
        builder.append("INSERT ");
        StringJoiner assignmentJoiner = new StringJoiner(", ");
        if (this.columnPermutation_ != Collections.EMPTY_LIST) {
            StringJoiner columnJoiner = new StringJoiner(", ");
            for (String column : this.columnPermutation_) {
                columnJoiner.add(column);
            }
            builder.append(String.format("(%s) ", columnJoiner));
        }
        builder.append(assignmentJoiner);
        builder.append("VALUES ");
        StringJoiner selectItemJoiner = new StringJoiner(", ");
        for (SelectListItem item : this.selectList_.getItems()) {
            selectItemJoiner.add(item.getExpr().toSql(options));
        }
        builder.append(String.format("(%s)", selectItemJoiner));
        return builder.toString();
    }

    @Override
    public TMergeCaseType caseType() {
        return TMergeCaseType.INSERT;
    }

    @Override
    public void reset() {
        super.reset();
        this.selectList_.reset();
    }

    @Override
    public MergeInsert clone() {
        return new MergeInsert(Expr.cloneList(this.resultExprs_), Expr.cloneList(this.getFilterExprs()), this.targetTableName_, this.targetTableColumns_, this.targetTableRef_, this.columnPermutation_, this.selectList_, this.matchType_, this.sourceTableRef_);
    }

    @VisibleForTesting
    public List<Expr> analyzeColumnPermutation() throws AnalysisException {
        boolean emptyColumnPermutation = this.columnPermutation_ == Collections.EMPTY_LIST;
        this.permutationSizeCheck(emptyColumnPermutation);
        this.duplicateColumnCheck();
        HashMap<String, Integer> indexedColumnPermutation = new HashMap<String, Integer>();
        for (int i = 0; i < this.columnPermutation_.size(); ++i) {
            indexedColumnPermutation.put(this.columnPermutation_.get(i), i);
        }
        ArrayList resultExprs = Lists.newArrayList();
        for (int i = 0; i < this.targetTableColumns_.size(); ++i) {
            Column column = (Column)this.targetTableColumns_.get(i);
            InsertStmt.checkSupportedColumn(column, "MERGE INSERT", this.targetTableName_);
            String name = column.getName();
            Expr expr = indexedColumnPermutation.containsKey(name) ? this.selectList_.getItems().get((Integer)indexedColumnPermutation.get(name)).getExpr() : (emptyColumnPermutation ? this.selectList_.getItems().get(i).getExpr() : new NullLiteral());
            expr = StatementBase.checkTypeCompatibility(this.targetTableName_.toSql(), column, expr, this.analyzer_, null);
            resultExprs.add(expr);
            indexedColumnPermutation.remove(name);
        }
        if (!indexedColumnPermutation.isEmpty()) {
            String foreignColumns = String.join((CharSequence)", ", indexedColumnPermutation.keySet());
            throw new AnalysisException(String.format("Unknown column(s) in column permutation: %s", foreignColumns));
        }
        return resultExprs;
    }

    private void permutationSizeCheck(boolean emptyColumnPermutation) throws AnalysisException {
        String target;
        int selectListSize = this.selectList_.getItems().size();
        int columnPermutationSize = this.columnPermutation_.size();
        if (emptyColumnPermutation) {
            target = String.format("Target table '%s' has", this.targetTableName_);
            columnPermutationSize = this.targetTableColumns_.size();
        } else {
            target = "Column permutation mentions";
        }
        if (columnPermutationSize > selectListSize) {
            throw new AnalysisException(String.format(this.moreColumnsMessageTemplate(), target, columnPermutationSize, selectListSize, this.toSql()));
        }
        if (columnPermutationSize < selectListSize) {
            throw new AnalysisException(String.format(this.fewerColumnsMessageTemplate(), target, columnPermutationSize, selectListSize, this.toSql()));
        }
    }

    protected String moreColumnsMessageTemplate() {
        return "%s more columns (%d) than the VALUES clause returns (%d): %s";
    }

    protected String fewerColumnsMessageTemplate() {
        return "%s fewer columns (%d) than the VALUES clause returns (%d): %s";
    }

    private void duplicateColumnCheck() throws AnalysisException {
        HashSet<String> columnNames = new HashSet<String>();
        HashSet<String> duplicatedColumnNames = new HashSet<String>();
        for (String columnName : this.columnPermutation_) {
            if (columnNames.contains(columnName)) {
                duplicatedColumnNames.add(columnName);
                continue;
            }
            columnNames.add(columnName);
        }
        if (!duplicatedColumnNames.isEmpty()) {
            throw new AnalysisException(String.format("Duplicate column(s) in column permutation: %s", String.join((CharSequence)", ", duplicatedColumnNames)));
        }
    }
}

