/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.DmlStatementBase;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.MergeCase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Column;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TMergeCaseType;
import org.apache.impala.thrift.TMergeMatchType;

public class MergeDelete
extends MergeCase {
    public MergeDelete() {
    }

    protected MergeDelete(List<Expr> resultExprs, List<Expr> filterExprs, TableName targetTableName, List<Column> targetTableColumns, TableRef targetTableRef, TMergeMatchType matchType, TableRef sourceTableRef) {
        super(resultExprs, filterExprs, targetTableName, targetTableColumns, targetTableRef, matchType, sourceTableRef);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        this.resultExprs_ = Lists.newArrayList();
        Preconditions.checkNotNull((Object)this.targetTableColumns_);
        for (Column col : this.targetTableColumns_) {
            this.resultExprs_.add(DmlStatementBase.createSlotRef(analyzer, this.targetTableRef_.getUniqueAlias(), col.getName()));
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        String parent = super.toSql(options);
        return String.format("%sDELETE", parent);
    }

    @Override
    public TMergeCaseType caseType() {
        return TMergeCaseType.DELETE;
    }

    @Override
    public MergeDelete clone() {
        return new MergeDelete(Expr.cloneList(this.resultExprs_), Expr.cloneList(this.getFilterExprs()), this.targetTableName_, this.targetTableColumns_, this.targetTableRef_, this.matchType_, this.sourceTableRef_);
    }
}

