/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.MergeStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TMergeCaseType;
import org.apache.impala.thrift.TMergeMatchType;

public abstract class MergeCase
extends StatementBase {
    protected List<Expr> resultExprs_;
    private List<Expr> filterExprs_;
    protected TableName targetTableName_;
    protected List<Column> targetTableColumns_;
    protected TableRef targetTableRef_;
    protected TableRef sourceTableRef_;
    protected TMergeMatchType matchType_;

    protected MergeCase() {
        this.matchType_ = TMergeMatchType.MATCHED;
        this.filterExprs_ = Collections.emptyList();
        this.resultExprs_ = Collections.emptyList();
    }

    protected MergeCase(List<Expr> resultExprs, List<Expr> filterExprs, TableName targetTableName, List<Column> targetTableColumns, TableRef targetTableRef, TMergeMatchType matchType, TableRef sourceTableRef) {
        this.targetTableName_ = targetTableName;
        this.targetTableColumns_ = targetTableColumns;
        this.targetTableRef_ = targetTableRef;
        this.sourceTableRef_ = sourceTableRef;
        this.resultExprs_ = resultExprs;
        this.filterExprs_ = filterExprs;
        this.matchType_ = matchType;
    }

    public List<Expr> getFilterExprs() {
        return this.filterExprs_;
    }

    public void setFilterExprs(List<Expr> exprs) {
        this.filterExprs_ = exprs;
    }

    public void setMatchType(TMergeMatchType matchType) {
        this.matchType_ = matchType;
    }

    public void setParent(MergeStmt parent) {
        this.targetTableName_ = parent.getTargetTable().getTableName();
        this.targetTableColumns_ = parent.getTargetTable().getColumns();
        this.targetTableRef_ = parent.getTargetTableRef();
        this.sourceTableRef_ = parent.getSourceTableRef();
    }

    protected List<String> getSourceColumnLabels() {
        if (this.sourceTableRef_ instanceof InlineViewRef) {
            InlineViewRef source = (InlineViewRef)this.sourceTableRef_;
            return source.getColLabels();
        }
        return this.sourceTableRef_.getTable().getColumnNames();
    }

    public void substituteResultExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.filterExprs_ = Expr.substituteList(this.filterExprs_, smap, analyzer, true);
        this.resultExprs_ = Expr.substituteList(this.resultExprs_, smap, analyzer, true);
    }

    public List<String> getExplainStrings(TExplainLevel explainLevel) {
        ArrayList details = Lists.newArrayList();
        if (!this.filterExprs_.isEmpty()) {
            details.add(String.format("filter predicates: %s", Expr.getExplainString(this.filterExprs_, explainLevel)));
        }
        details.add(String.format("result expressions: %s", Expr.getExplainString(this.resultExprs_, explainLevel)));
        details.add(String.format("type: %s", new Object[]{this.caseType()}));
        return details;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        for (Expr expr : this.filterExprs_) {
            expr.analyze(analyzer);
            if (expr.type_ == Type.BOOLEAN) continue;
            throw new AnalysisException(String.format("Filter expression requires return type '%s'. Actual type is '%s'", Type.BOOLEAN, expr.type_));
        }
    }

    @Override
    public String toSql(ToSqlOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("WHEN ");
        builder.append(this.matchTypeAsString());
        if (!this.filterExprs_.isEmpty()) {
            StringJoiner expressionJoiner = new StringJoiner(" AND ");
            builder.append(" AND ");
            for (Expr filterExpr : this.filterExprs_) {
                expressionJoiner.add(filterExpr.toSql(options));
            }
            builder.append(expressionJoiner);
        }
        builder.append(" THEN ");
        return builder.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.resultExprs_ = Collections.emptyList();
        for (Expr expr : this.filterExprs_) {
            expr.reset();
        }
    }

    @Override
    public abstract MergeCase clone();

    @Override
    public List<Expr> getResultExprs() {
        return this.resultExprs_;
    }

    public TMergeMatchType matchType() {
        return this.matchType_;
    }

    @Override
    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        rewriter.rewriteList(this.filterExprs_, this.analyzer_);
        rewriter.rewriteList(this.resultExprs_, this.analyzer_);
    }

    public String matchTypeAsString() {
        switch (this.matchType_) {
            case MATCHED: {
                return "MATCHED";
            }
            case NOT_MATCHED_BY_TARGET: {
                return "NOT MATCHED BY TARGET";
            }
            case NOT_MATCHED_BY_SOURCE: {
                return "NOT MATCHED BY SOURCE";
            }
        }
        throw new IllegalStateException(String.format("Invalid TMergeMatchType value: %s", new Object[]{this.matchType_}));
    }

    public abstract TMergeCaseType caseType();
}

