/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.DateLiteral;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.TimestampLiteral;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.NotImplementedException;
import org.apache.impala.common.SqlCastException;
import org.apache.impala.common.UnsupportedFeatureException;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TQueryCtx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LiteralExpr
extends Expr
implements Comparable<LiteralExpr> {
    private static final Logger LOG = LoggerFactory.getLogger(LiteralExpr.class);
    public static final int MAX_STRING_LITERAL_SIZE = 65536;

    public LiteralExpr() {
        this.evalCost_ = 1.0f;
        this.numDistinctValues_ = 1L;
    }

    protected LiteralExpr(LiteralExpr other) {
        super(other);
    }

    public static LiteralExpr createFromUnescapedStr(String value, Type type) throws AnalysisException {
        if (!type.isValid()) {
            throw new UnsupportedFeatureException("Invalid literal type: " + type.toSql());
        }
        LiteralExpr e = null;
        switch (type.getPrimitiveType()) {
            case NULL_TYPE: {
                e = new NullLiteral();
                break;
            }
            case BOOLEAN: {
                e = new BoolLiteral(value);
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                e = new NumericLiteral(value, type);
                break;
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: 
            case BINARY: {
                e = new StringLiteral(value, type, false);
                break;
            }
            case DATE: {
                e = new DateLiteral(value);
                break;
            }
            case DATETIME: 
            case TIMESTAMP: {
                throw new UnsupportedFeatureException("Literal unsupported: " + type.toSql());
            }
            default: {
                throw new UnsupportedFeatureException(String.format("Literals of type '%s' not supported.", type.toSql()));
            }
        }
        e.analyze(null);
        return (LiteralExpr)e.uncheckedCastTo(type);
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
    }

    @Override
    protected float computeEvalCost() {
        return 1.0f;
    }

    public static LiteralExpr fromThrift(TExprNode exprNode, Type colType) {
        try {
            LiteralExpr result = null;
            switch (exprNode.node_type) {
                case FLOAT_LITERAL: {
                    result = LiteralExpr.createFromUnescapedStr(Double.toString(exprNode.float_literal.value), colType);
                    break;
                }
                case DECIMAL_LITERAL: {
                    byte[] bytes = exprNode.decimal_literal.getValue();
                    BigDecimal val = new BigDecimal(new BigInteger(bytes));
                    ScalarType decimalType = (ScalarType)colType;
                    val = val.movePointLeft(decimalType.decimalScale());
                    result = new NumericLiteral(val, colType);
                    break;
                }
                case DATE_LITERAL: {
                    result = new DateLiteral(exprNode.date_literal.days_since_epoch, exprNode.date_literal.date_string);
                    break;
                }
                case INT_LITERAL: {
                    result = LiteralExpr.createFromUnescapedStr(Long.toString(exprNode.int_literal.value), colType);
                    break;
                }
                case STRING_LITERAL: {
                    result = new StringLiteral(exprNode.string_literal.getValue(), colType);
                    break;
                }
                case BOOL_LITERAL: {
                    result = LiteralExpr.createFromUnescapedStr(Boolean.toString(exprNode.bool_literal.value), colType);
                    break;
                }
                case NULL_LITERAL: {
                    return NullLiteral.create(colType);
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported partition key type: " + (Object)((Object)exprNode.node_type));
                }
            }
            Preconditions.checkNotNull((Object)result);
            result.analyze(null);
            return result;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error creating LiteralExpr: ", e);
        }
    }

    public abstract String getStringValue();

    public void swapSign() throws NotImplementedException {
        throw new NotImplementedException("swapSign() only implemented for numericliterals");
    }

    public static LiteralExpr create(Expr constExpr, TQueryCtx queryCtx) throws AnalysisException {
        return LiteralExpr.createBounded(constExpr, queryCtx, 0);
    }

    public static LiteralExpr createBounded(Expr constExpr, TQueryCtx queryCtx, int maxResultSize, boolean keepOriginalIntType) throws AnalysisException {
        Preconditions.checkState((boolean)constExpr.isConstant());
        Preconditions.checkState((boolean)constExpr.getType().isValid());
        if (constExpr instanceof LiteralExpr) {
            return (LiteralExpr)constExpr;
        }
        TColumnValue val = null;
        try {
            val = FeSupport.EvalExprWithoutRowBounded(constExpr, queryCtx, maxResultSize);
        }
        catch (InternalException e) {
            LOG.error(String.format("Failed to evaluate expr '%s': %s", constExpr.toSql(), e.getMessage()));
            return null;
        }
        LiteralExpr result = null;
        switch (constExpr.getType().getPrimitiveType()) {
            case NULL_TYPE: {
                result = new NullLiteral();
                break;
            }
            case BOOLEAN: {
                if (!val.isSetBool_val()) break;
                result = new BoolLiteral(val.bool_val);
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                result = LiteralExpr.createIntegerLiteral(val, constExpr.getType(), keepOriginalIntType);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                if (!val.isSetDouble_val()) break;
                try {
                    result = new NumericLiteral(val.double_val, constExpr.getType());
                    break;
                }
                catch (SqlCastException e) {
                    return null;
                }
            }
            case DECIMAL: {
                if (!val.isSetString_val()) break;
                result = new NumericLiteral(new BigDecimal(val.string_val), constExpr.getType());
                break;
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: 
            case BINARY: {
                if (!val.isSetBinary_val()) break;
                byte[] bytes = new byte[val.binary_val.remaining()];
                val.binary_val.get(bytes);
                result = new StringLiteral(bytes, constExpr.getType());
                break;
            }
            case TIMESTAMP: {
                if (!val.isSetBinary_val() || !val.isSetString_val()) break;
                result = new TimestampLiteral(val.getBinary_val(), val.getString_val());
                break;
            }
            case DATE: {
                if (!val.isSetInt_val() || !val.isSetString_val()) break;
                result = new DateLiteral(val.int_val, val.getString_val());
                break;
            }
            case DATETIME: {
                return null;
            }
            default: {
                Preconditions.checkState((boolean)false, (Object)String.format("Literals of type '%s' not supported.", constExpr.getType().toSql()));
            }
        }
        if (result == null) {
            result = new NullLiteral();
        }
        result.analyzeNoThrow(null);
        return result;
    }

    public static LiteralExpr createBounded(Expr constExpr, TQueryCtx queryCtx, int maxResultSize) throws AnalysisException {
        return LiteralExpr.createBounded(constExpr, queryCtx, maxResultSize, false);
    }

    @Override
    public int compareTo(LiteralExpr other) {
        if (Expr.IS_NULL_LITERAL.apply((Object)this) && Expr.IS_NULL_LITERAL.apply((Object)other)) {
            return 0;
        }
        if (Expr.IS_NULL_LITERAL.apply((Object)this)) {
            return -1;
        }
        if (Expr.IS_NULL_LITERAL.apply((Object)other)) {
            return 1;
        }
        Preconditions.checkState((this.getClass() == other.getClass() ? 1 : 0) != 0);
        return 0;
    }

    private static NumericLiteral createIntegerLiteral(TColumnValue val, Type type, boolean keepOriginalIntType) throws SqlCastException {
        BigDecimal value = null;
        switch (type.getPrimitiveType()) {
            case TINYINT: {
                if (!val.isSetByte_val()) break;
                value = BigDecimal.valueOf(val.byte_val);
                break;
            }
            case SMALLINT: {
                if (!val.isSetShort_val()) break;
                value = BigDecimal.valueOf(val.short_val);
                break;
            }
            case INT: {
                if (!val.isSetInt_val()) break;
                value = BigDecimal.valueOf(val.int_val);
                break;
            }
            case BIGINT: {
                if (!val.isSetLong_val()) break;
                value = BigDecimal.valueOf(val.long_val);
                break;
            }
            default: {
                Preconditions.checkState((boolean)false, (Object)String.format("Integer type expected, got '%s'.", type.toSql()));
            }
        }
        if (value == null) {
            return null;
        }
        return keepOriginalIntType ? new NumericLiteral(value, type) : new NumericLiteral(value);
    }
}

