/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;

public class LikePredicate
extends Predicate {
    private final Operator op_;

    public static void initBuiltins(Db db) {
        db.addBuiltin(ScalarFunction.createBuiltin(Operator.LIKE.name(), Lists.newArrayList((Object[])new Type[]{Type.STRING, Type.STRING}), false, Type.BOOLEAN, "_ZN6impala13LikePredicate4LikeEPN10impala_udf15FunctionContextERKNS1_9StringValES6_", "_ZN6impala13LikePredicate11LikePrepareEPN10impala_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN6impala13LikePredicate9LikeCloseEPN10impala_udf15FunctionContextENS2_18FunctionStateScopeE", true));
        db.addBuiltin(ScalarFunction.createBuiltin(Operator.ILIKE.name(), Lists.newArrayList((Object[])new Type[]{Type.STRING, Type.STRING}), false, Type.BOOLEAN, "_ZN6impala13LikePredicate4LikeEPN10impala_udf15FunctionContextERKNS1_9StringValES6_", "_ZN6impala13LikePredicate12ILikePrepareEPN10impala_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN6impala13LikePredicate9LikeCloseEPN10impala_udf15FunctionContextENS2_18FunctionStateScopeE", true));
        db.addBuiltin(ScalarFunction.createBuiltin(Operator.RLIKE.name(), Lists.newArrayList((Object[])new Type[]{Type.STRING, Type.STRING}), false, Type.BOOLEAN, "_ZN6impala13LikePredicate5RegexEPN10impala_udf15FunctionContextERKNS1_9StringValES6_", "_ZN6impala13LikePredicate12RegexPrepareEPN10impala_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN6impala13LikePredicate10RegexCloseEPN10impala_udf15FunctionContextENS2_18FunctionStateScopeE", true));
        db.addBuiltin(ScalarFunction.createBuiltin(Operator.REGEXP.name(), Lists.newArrayList((Object[])new Type[]{Type.STRING, Type.STRING}), false, Type.BOOLEAN, "_ZN6impala13LikePredicate5RegexEPN10impala_udf15FunctionContextERKNS1_9StringValES6_", "_ZN6impala13LikePredicate12RegexPrepareEPN10impala_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN6impala13LikePredicate10RegexCloseEPN10impala_udf15FunctionContextENS2_18FunctionStateScopeE", true));
        db.addBuiltin(ScalarFunction.createBuiltin(Operator.IREGEXP.name(), Lists.newArrayList((Object[])new Type[]{Type.STRING, Type.STRING}), false, Type.BOOLEAN, "_ZN6impala13LikePredicate5RegexEPN10impala_udf15FunctionContextERKNS1_9StringValES6_", "_ZN6impala13LikePredicate13IRegexPrepareEPN10impala_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN6impala13LikePredicate10RegexCloseEPN10impala_udf15FunctionContextENS2_18FunctionStateScopeE", true));
    }

    public LikePredicate(Operator op, Expr e1, Expr e2) {
        this.op_ = op;
        Preconditions.checkNotNull((Object)e1);
        this.children_.add(e1);
        Preconditions.checkNotNull((Object)e2);
        this.children_.add(e2);
    }

    public LikePredicate(LikePredicate other) {
        super(other);
        this.op_ = other.op_;
    }

    @Override
    protected boolean localEquals(Expr that) {
        return super.localEquals(that) && ((LikePredicate)that).op_ == this.op_;
    }

    @Override
    protected int localHash() {
        return Objects.hash(new Object[]{super.localHash(), this.op_});
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        return ((Expr)this.getChild(0)).toSql(options) + " " + this.op_.toString() + " " + ((Expr)this.getChild(1)).toSql(options);
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.FUNCTION_CALL;
    }

    private static boolean isLikeableType(Type type) {
        return type.isStringType() && !type.isBinary() || type.isNull();
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        if (!LikePredicate.isLikeableType(((Expr)this.getChild(0)).getType())) {
            throw new AnalysisException("left operand of " + this.op_.toString() + " must be of type STRING: " + this.toSql());
        }
        if (!LikePredicate.isLikeableType(((Expr)this.getChild(1)).getType())) {
            throw new AnalysisException("right operand of " + this.op_.toString() + " must be of type STRING: " + this.toSql());
        }
        this.fn_ = this.getBuiltinFunction(analyzer, this.op_.toString(), this.collectChildReturnTypes(), Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        Preconditions.checkState((this.fn_ != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.fn_.getReturnType().isBoolean());
        if (Expr.IS_NON_NULL_LITERAL.apply(this.getChild(1)) && (this.op_ == Operator.RLIKE || this.op_ == Operator.REGEXP || this.op_ == Operator.IREGEXP)) {
            try {
                Pattern.compile(((StringLiteral)this.getChild(1)).getValueWithOriginalEscapes());
            }
            catch (PatternSyntaxException e) {
                throw new AnalysisException("invalid regular expression in '" + this.toSql() + "'");
            }
        }
        this.castForFunctionCall(false, analyzer.getRegularCompatibilityLevel());
    }

    @Override
    protected float computeEvalCost() {
        if (!this.hasChildCosts()) {
            return -1.0f;
        }
        if (Expr.IS_NON_NULL_LITERAL.apply(this.getChild(1)) && Pattern.matches("[%_]*[^%_]*[%_]*", ((StringLiteral)this.getChild(1)).getValueWithOriginalEscapes())) {
            return this.getChildCosts() + (float)(LikePredicate.getAvgStringLength((Expr)this.getChild(0)) + LikePredicate.getAvgStringLength((Expr)this.getChild(1)) * 1.0) + 10.0f;
        }
        return this.getChildCosts() + (float)(LikePredicate.getAvgStringLength((Expr)this.getChild(0)) * LikePredicate.getAvgStringLength((Expr)this.getChild(1)) * 1.0) + 10.0f;
    }

    @Override
    public Expr clone() {
        return new LikePredicate(this);
    }

    public Operator getOp() {
        return this.op_;
    }

    @Override
    public boolean shouldConvertToCNF() {
        return false;
    }

    static enum Operator {
        LIKE("LIKE"),
        ILIKE("ILIKE"),
        RLIKE("RLIKE"),
        REGEXP("REGEXP"),
        IREGEXP("IREGEXP");

        private final String description_;

        private Operator(String description) {
            this.description_ = description;
        }

        public String toString() {
            return this.description_;
        }
    }
}

