/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.User;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TKillQueryReq;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.util.TUniqueIdUtil;

public final class KillQueryStmt
extends StatementBase {
    private final String queryIdString_;
    private TUniqueId queryId_;
    private User requestingUser_;
    private boolean requestedByAdmin_ = true;

    public KillQueryStmt(String queryId) {
        this.queryIdString_ = queryId;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return String.format("KILL QUERY '%s'", this.queryIdString_);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        try {
            this.queryId_ = TUniqueIdUtil.ParseId(this.queryIdString_);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException(String.format("Invalid query id: '%s'", this.queryIdString_));
        }
        this.requestingUser_ = analyzer.getUser();
        AuthorizationConfig authzConfig = analyzer.getAuthzConfig();
        if (authzConfig.isEnabled()) {
            String authzServer = authzConfig.getServerName();
            Preconditions.checkNotNull((Object)authzServer);
            analyzer.setMaskPrivChecks(null);
            analyzer.registerPrivReq(builder -> builder.onServer(authzServer).all().build());
        }
    }

    public TKillQueryReq toThrift() {
        return new TKillQueryReq(this.queryId_, this.requestingUser_.getName(), this.requestedByAdmin_);
    }

    @Override
    public void handleAuthorizationException(AnalysisContext.AnalysisResult analysisResult) {
        this.requestedByAdmin_ = false;
        analysisResult.setUserHasProfileAccess(true);
    }
}

