/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Objects;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.ExistsPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Reference;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;

public class IsNullPredicate
extends Predicate {
    private final boolean isNotNull_;
    private static final String IS_NULL = "is_null_pred";
    private static final String IS_NOT_NULL = "is_not_null_pred";

    public IsNullPredicate(Expr e, boolean isNotNull) {
        this.isNotNull_ = isNotNull;
        Preconditions.checkNotNull((Object)e);
        this.children_.add(e);
    }

    protected IsNullPredicate(IsNullPredicate other) {
        super(other);
        this.isNotNull_ = other.isNotNull_;
    }

    public boolean isNotNull() {
        return this.isNotNull_;
    }

    public static void initBuiltins(Db db) {
        for (Type type : Type.getSupportedTypes()) {
            String isNullSymbol;
            if (type.isNull()) continue;
            if (type.isBoolean()) {
                isNullSymbol = "_ZN6impala15IsNullPredicate6IsNullIN10impala_udf10BooleanValEEES3_PNS2_15FunctionContextERKT_";
            } else {
                String udfType = Function.getUdfType(type);
                isNullSymbol = "_ZN6impala15IsNullPredicate6IsNullIN10impala_udf" + udfType.length() + udfType + "EEENS2_10BooleanValEPNS2_15FunctionContextERKT_";
            }
            db.addBuiltin(ScalarFunction.createBuiltinOperator(IS_NULL, isNullSymbol, Lists.newArrayList((Object[])new Type[]{type}), Type.BOOLEAN));
            String isNotNullSymbol = isNullSymbol.replace("6IsNull", "9IsNotNull");
            db.addBuiltin(ScalarFunction.createBuiltinOperator(IS_NOT_NULL, isNotNullSymbol, Lists.newArrayList((Object[])new Type[]{type}), Type.BOOLEAN));
        }
    }

    @Override
    protected boolean localEquals(Expr that) {
        return super.localEquals(that) && ((IsNullPredicate)that).isNotNull_ == this.isNotNull_;
    }

    @Override
    protected int localHash() {
        return Objects.hash(super.localHash(), this.isNotNull_);
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        return ((Expr)this.getChild(0)).toSql(options) + (this.isNotNull_ ? " IS NOT NULL" : " IS NULL");
    }

    @Override
    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("notNull", this.isNotNull_).addValue((Object)super.debugString()).toString();
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        if (this.contains(Subquery.class)) {
            if (this.getChild(0) instanceof ExistsPredicate) {
                this.setChild(0, new BoolLiteral(true));
                ((Expr)this.getChild(0)).analyze(analyzer);
            } else if (!((Expr)this.getChild(0)).contains(Expr.IS_SCALAR_SUBQUERY) && !((Expr)this.getChild(0)).getSubquery().getStatement().isRuntimeScalar()) {
                throw new AnalysisException("Unsupported IS NULL predicate that contains a subquery: " + this.toSqlImpl());
            }
        }
        if (((Expr)this.getChild(0)).getType().isNull()) {
            this.uncheckedCastChild(ScalarType.BOOLEAN, 0);
        }
        if (((Expr)this.getChild(0)).getType().isComplexType()) {
            String errorMsg = (this.isNotNull_ ? "IS NOT NULL" : "IS NULL") + " predicate does not support complex types: ";
            throw new AnalysisException(errorMsg + this.toSqlImpl());
        }
        this.fn_ = this.isNotNull_ ? this.getBuiltinFunction(analyzer, IS_NOT_NULL, this.collectChildReturnTypes(), Function.CompareMode.IS_IDENTICAL) : this.getBuiltinFunction(analyzer, IS_NULL, this.collectChildReturnTypes(), Function.CompareMode.IS_IDENTICAL);
        this.computeSelectivity();
    }

    protected void computeSelectivity() {
        if (this.hasValidSelectivityHint()) {
            return;
        }
        Reference<SlotRef> slotRefRef = new Reference<SlotRef>();
        if (this.isSingleColumnPredicate(slotRefRef, null)) {
            SlotDescriptor slotDesc = slotRefRef.getRef().getDesc();
            if (!slotDesc.getStats().hasNullsStats()) {
                return;
            }
            FeTable table = slotDesc.getParent().getTable();
            if (table != null && table.getNumRows() > 0L) {
                long numRows = table.getNumRows();
                this.selectivity_ = this.isNotNull_ ? (double)(numRows - slotDesc.getStats().getNumNulls()) / (double)numRows : (double)slotDesc.getStats().getNumNulls() / (double)numRows;
                this.selectivity_ = Math.max(0.0, Math.min(1.0, this.selectivity_));
            }
        }
    }

    @Override
    protected float computeEvalCost() {
        return ((Expr)this.getChild(0)).hasCost() ? ((Expr)this.getChild(0)).getCost() + 1.0f : -1.0f;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.FUNCTION_CALL;
    }

    @Override
    public SlotRef getBoundSlot() {
        return ((Expr)this.getChild(0)).unwrapSlotRef(true);
    }

    @Override
    public Expr negate() {
        return new IsNullPredicate((Expr)this.getChild(0), !this.isNotNull_);
    }

    @Override
    public Expr clone() {
        return new IsNullPredicate(this);
    }
}

