/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;

public class IsNotEmptyPredicate
extends Predicate {
    public IsNotEmptyPredicate(Expr collectionExpr) {
        Preconditions.checkNotNull((Object)collectionExpr);
        this.children_.add(collectionExpr);
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        if (!((Expr)this.getChild(0)).getType().isCollectionType()) {
            throw new AnalysisException("Operand must be a collection type: " + ((Expr)this.getChild(0)).toSql() + " is of type " + ((Expr)this.getChild(0)).getType());
        }
        this.selectivity_ = 1.0;
    }

    @Override
    protected float computeEvalCost() {
        if (!((Expr)this.getChild(0)).hasCost()) {
            return -1.0f;
        }
        return ((Expr)this.getChild(0)).getCost() + 1.0f;
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        return "!empty(" + ((Expr)this.getChild(0)).toSql(options) + ")";
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.IS_NOT_EMPTY_PRED;
    }

    @Override
    public Expr clone() {
        return new IsNotEmptyPredicate(((Expr)this.getChild(0)).clone());
    }

    @Override
    public boolean shouldConvertToCNF() {
        return false;
    }
}

