/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.Reference;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;

public class InPredicate
extends Predicate {
    private static final String IN_SET_LOOKUP = "in_set_lookup";
    private static final String NOT_IN_SET_LOOKUP = "not_in_set_lookup";
    private static final String IN_ITERATE = "in_iterate";
    private static final String NOT_IN_ITERATE = "not_in_iterate";
    private final boolean isNotIn_;

    public boolean isNotIn() {
        return this.isNotIn_;
    }

    public static void initBuiltins(Db db) {
        for (Type type : Type.getSupportedTypes()) {
            if (type.isNull() || type.getPrimitiveType() == PrimitiveType.CHAR) continue;
            String typeString = type.getPrimitiveType().toString().toLowerCase();
            if (type.isVarchar() || type.isBinary()) {
                typeString = "string";
            }
            db.addBuiltin(ScalarFunction.createBuiltin(IN_ITERATE, Lists.newArrayList((Object[])new Type[]{type, type}), true, Type.BOOLEAN, "impala::InPredicate::InIterate", null, null, false));
            db.addBuiltin(ScalarFunction.createBuiltin(NOT_IN_ITERATE, Lists.newArrayList((Object[])new Type[]{type, type}), true, Type.BOOLEAN, "impala::InPredicate::NotInIterate", null, null, false));
            String prepareFn = "impala::InPredicate::SetLookupPrepare_" + typeString;
            String closeFn = "impala::InPredicate::SetLookupClose_" + typeString;
            db.addBuiltin(ScalarFunction.createBuiltin(IN_SET_LOOKUP, Lists.newArrayList((Object[])new Type[]{type, type}), true, Type.BOOLEAN, "impala::InPredicate::InSetLookup", prepareFn, closeFn, false));
            db.addBuiltin(ScalarFunction.createBuiltin(NOT_IN_SET_LOOKUP, Lists.newArrayList((Object[])new Type[]{type, type}), true, Type.BOOLEAN, "impala::InPredicate::NotInSetLookup", prepareFn, closeFn, false));
        }
    }

    public InPredicate(Expr compareExpr, List<Expr> inList, boolean isNotIn) {
        this.children_.add(compareExpr);
        this.children_.addAll(inList);
        this.isNotIn_ = isNotIn;
    }

    public InPredicate(Expr compareExpr, Expr subquery, boolean isNotIn) {
        Preconditions.checkNotNull((Object)compareExpr);
        Preconditions.checkNotNull((Object)subquery);
        this.children_.add(compareExpr);
        this.children_.add(subquery);
        this.isNotIn_ = isNotIn;
    }

    protected InPredicate(InPredicate other) {
        super(other);
        this.isNotIn_ = other.isNotIn_;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        if (this.contains(Subquery.class)) {
            if (this.children_.size() != 2 || !(this.getChild(1) instanceof Subquery)) {
                throw new AnalysisException("Unsupported IN predicate with a subquery: " + this.toSqlImpl());
            }
            Subquery subquery = (Subquery)this.getChild(1);
            subquery.getStatement().setIsRuntimeScalar(false);
            if (!subquery.returnsScalarColumn()) {
                throw new AnalysisException("Subquery must return a single column: " + subquery.toSql());
            }
            List<Expr> subqueryExprs = subquery.getStatement().getResultExprs();
            Expr compareExpr = (Expr)this.children_.get(0);
            Expr subqueryExpr = subqueryExprs.get(0);
            analyzer.getCompatibleType(compareExpr.getType(), compareExpr, subqueryExpr);
        } else {
            int setLookupThreshold;
            Preconditions.checkState((this.getChildren().size() >= 2 ? 1 : 0) != 0);
            analyzer.castAllToCompatibleType(this.children_);
            Type childType = ((Expr)this.children_.get(0)).getType();
            if (childType.isNull()) {
                for (int i = 0; i < this.children_.size(); ++i) {
                    this.uncheckedCastChild(Type.BOOLEAN, i);
                }
            }
            boolean allConstant = true;
            for (int i = 1; i < this.children_.size(); ++i) {
                if (((Expr)this.children_.get(i)).isConstant()) continue;
                allConstant = false;
                break;
            }
            boolean useSetLookup = allConstant;
            int n = setLookupThreshold = ((Expr)this.children_.get(0)).getType().isStringType() ? 2 : 6;
            if (this.children_.size() - 1 < setLookupThreshold) {
                useSetLookup = false;
            }
            Type[] argTypes = new Type[]{((Expr)this.getChild((int)0)).type_, ((Expr)this.getChild((int)1)).type_};
            this.fn_ = useSetLookup ? this.getBuiltinFunction(analyzer, this.isNotIn_ ? NOT_IN_SET_LOOKUP : IN_SET_LOOKUP, argTypes, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF) : this.getBuiltinFunction(analyzer, this.isNotIn_ ? NOT_IN_ITERATE : IN_ITERATE, argTypes, Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
            Preconditions.checkNotNull((Object)this.fn_);
            Preconditions.checkState((boolean)this.fn_.getReturnType().isBoolean());
            this.castForFunctionCall(false, analyzer.getRegularCompatibilityLevel());
        }
        this.computeSelectivity();
    }

    protected void computeSelectivity() {
        if (this.hasValidSelectivityHint()) {
            return;
        }
        Reference<SlotRef> slotRefRef = new Reference<SlotRef>();
        Reference<Integer> idxRef = new Reference<Integer>();
        if (this.isSingleColumnPredicate(slotRefRef, idxRef) && idxRef.getRef() == 0 && slotRefRef.getRef().getNumDistinctValues() > 0L) {
            this.selectivity_ = this.isNotIn() ? 1.0 - (double)(this.getChildren().size() - 1) / (double)slotRefRef.getRef().getNumDistinctValues() : (double)(this.getChildren().size() - 1) / (double)slotRefRef.getRef().getNumDistinctValues();
            this.selectivity_ = Math.max(0.0, Math.min(1.0, this.selectivity_));
        }
    }

    @Override
    protected float computeEvalCost() {
        if (!this.hasChildCosts()) {
            return -1.0f;
        }
        return this.getChildCosts() + 1.0f * (float)(this.children_.size() - 1);
    }

    @Override
    protected void toThrift(TExprNode msg) {
        Preconditions.checkState((!this.contains(Subquery.class) ? 1 : 0) != 0);
        msg.node_type = TExprNodeType.FUNCTION_CALL;
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        StringBuilder strBuilder = new StringBuilder();
        String notStr = this.isNotIn_ ? "NOT " : "";
        strBuilder.append(((Expr)this.getChild(0)).toSql(options) + " " + notStr + "IN ");
        boolean hasSubquery = this.contains(Subquery.class);
        if (!hasSubquery) {
            strBuilder.append("(");
        }
        for (int i = 1; i < this.children_.size(); ++i) {
            strBuilder.append(((Expr)this.getChild(i)).toSql(options));
            strBuilder.append(i + 1 != this.children_.size() ? ", " : "");
        }
        if (!hasSubquery) {
            strBuilder.append(")");
        }
        return strBuilder.toString();
    }

    @Override
    public SlotRef getBoundSlot() {
        return ((Expr)this.getChild(0)).unwrapSlotRef(true);
    }

    @Override
    public Expr negate() {
        return new InPredicate((Expr)this.getChild(0), this.children_.subList(1, this.children_.size()), !this.isNotIn_);
    }

    @Override
    public Expr clone() {
        return new InPredicate(this);
    }
}

