/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.IcebergPartitionTransform;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TIcebergPartitionField;
import org.apache.impala.thrift.TIcebergPartitionTransformType;

public class IcebergPartitionField
extends StmtNode {
    private int sourceId_;
    private int fieldId_;
    private String fieldName_;
    private String origFieldName_;
    private IcebergPartitionTransform transform_;
    private ScalarType type_;

    public IcebergPartitionField(int sourceId, int fieldId, String origFieldName, String fieldName, IcebergPartitionTransform transform, Type type) {
        Preconditions.checkState((boolean)type.isScalarType());
        this.sourceId_ = sourceId;
        this.fieldId_ = fieldId;
        this.origFieldName_ = origFieldName.toLowerCase();
        this.fieldName_ = fieldName.toLowerCase();
        this.transform_ = transform;
        this.type_ = (ScalarType)type;
    }

    public IcebergPartitionField(String fieldName, IcebergPartitionTransform transform) {
        this(0, 0, fieldName, fieldName, transform, Type.NULL);
    }

    public String getFieldName() {
        return this.fieldName_;
    }

    public int getSourceId() {
        return this.sourceId_;
    }

    public int getFieldId_() {
        return this.fieldId_;
    }

    public TIcebergPartitionTransformType getTransformType() {
        return this.transform_.getTransformType();
    }

    public Integer getTransformParam() {
        return this.transform_.getTransformParam();
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.transform_.analyze(analyzer);
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return this.transform_.toSql(this.origFieldName_);
    }

    public TIcebergPartitionField toThrift() {
        TIcebergPartitionField result = new TIcebergPartitionField();
        result.setField_id(this.fieldId_);
        result.setSource_id(this.sourceId_);
        result.setOrig_field_name(this.origFieldName_);
        result.setField_name(this.fieldName_);
        result.setTransform(this.transform_.toThrift());
        result.setType(this.type_.toTScalarType());
        return result;
    }
}

