/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.DmlStatementBase;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.ModifyImpl;
import org.apache.impala.analysis.ModifyStmt;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.IcebergPositionDeleteTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TIcebergFileFormat;

abstract class IcebergModifyImpl
extends ModifyImpl {
    FeIcebergTable originalTargetTable_;
    IcebergPositionDeleteTable icePosDelTable_;
    protected List<Expr> deleteResultExprs_ = new ArrayList<Expr>();
    protected List<Expr> deletePartitionKeyExprs_ = new ArrayList<Expr>();
    protected List<Expr> sortExprs_ = new ArrayList<Expr>();

    public IcebergModifyImpl(ModifyStmt modifyStmt) {
        super(modifyStmt);
        this.originalTargetTable_ = (FeIcebergTable)this.modifyStmt_.getTargetTable();
        this.icePosDelTable_ = new IcebergPositionDeleteTable(this.originalTargetTable_);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.modifyStmt_.setMaxTableSinks(analyzer.getQueryOptions().getMax_fs_writers());
        if (this.icePosDelTable_.getFormatVersion() == 1) {
            throw new AnalysisException("Iceberg V1 table do not support DELETE/UPDATE operations: " + this.originalTargetTable_.getFullName());
        }
        if (this.originalTargetTable_.getDeleteFileFormat() != TIcebergFileFormat.PARQUET) {
            throw new AnalysisException("Impala can only write delete files in PARQUET, but the given table uses a different file format: " + this.originalTargetTable_.getFullName());
        }
        String modifyMode = this.getModifyMode();
        String modifyWriteMode = (String)this.originalTargetTable_.getIcebergApiTable().properties().get(modifyMode);
        if (modifyWriteMode != null && !Objects.equals(modifyWriteMode, "merge-on-read") && !this.isMergeOnReadAlwaysAllowed()) {
            throw new AnalysisException(String.format("Unsupported '%s': '%s' for Iceberg table: %s", modifyMode, modifyWriteMode, this.originalTargetTable_.getFullName()));
        }
    }

    @Override
    public List<Expr> getSortExprs() {
        return this.sortExprs_;
    }

    @Override
    public void substituteResultExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        super.substituteResultExprs(smap, analyzer);
        this.sortExprs_ = Expr.substituteList(this.sortExprs_, smap, analyzer, true);
        this.deleteResultExprs_ = Expr.substituteList(this.deleteResultExprs_, smap, analyzer, true);
        this.deletePartitionKeyExprs_ = Expr.substituteList(this.deletePartitionKeyExprs_, smap, analyzer, true);
    }

    public List<Expr> getDeletePartitionExprs(Analyzer analyzer) throws AnalysisException {
        if (!this.originalTargetTable_.isPartitioned()) {
            return Collections.emptyList();
        }
        return this.getSlotRefs(analyzer, Lists.newArrayList((Object[])new String[]{"PARTITION__SPEC__ID", "ICEBERG__PARTITION__SERIALIZED"}));
    }

    public List<Expr> getDeleteResultExprs(Analyzer analyzer) throws AnalysisException {
        return this.getSlotRefs(analyzer, Lists.newArrayList((Object[])new String[]{"INPUT__FILE__NAME", "FILE__POSITION"}));
    }

    private List<Expr> getSlotRefs(Analyzer analyzer, List<String> cols) throws AnalysisException {
        ArrayList<Expr> ret = new ArrayList<Expr>();
        for (String col : cols) {
            ret.add(DmlStatementBase.createSlotRef(analyzer, this.modifyStmt_.targetTableRef_.getUniqueAlias(), col));
        }
        return ret;
    }

    abstract String getModifyMode();

    protected boolean isMergeOnReadAlwaysAllowed() {
        return BackendConfig.INSTANCE.icebergAlwaysAllowMergeOnReadOperations();
    }
}

