/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.impala.analysis.AlterTableSetTblProperties;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ArithmeticExpr;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FromClause;
import org.apache.impala.analysis.InlineViewRef;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.analysis.MergeCase;
import org.apache.impala.analysis.MergeImpl;
import org.apache.impala.analysis.MergeStmt;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.PlanHint;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.SelectList;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.analysis.TupleIsNullPredicate;
import org.apache.impala.analysis.TypeDef;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.IcebergPositionDeleteTable;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.DataSink;
import org.apache.impala.planner.IcebergBufferedDeleteSink;
import org.apache.impala.planner.IcebergMergeNode;
import org.apache.impala.planner.IcebergMergeSink;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.PlannerContext;
import org.apache.impala.planner.TableSink;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.util.IcebergUtil;

public class IcebergMergeImpl
implements MergeImpl {
    private static final String ROW_PRESENT = "row_present";
    private static final String MERGE_ACTION_TUPLE_NAME = "merge-action";
    private final MergeStmt mergeStmt_;
    private TableRef targetTableRef_;
    private TableRef sourceTableRef_;
    private final Expr on_;
    private FeIcebergTable icebergTable_;
    private IcebergPositionDeleteTable icebergPositionalDeleteTable_;
    private SelectStmt queryStmt_;
    private int deleteTableId_;
    private final FeTable table_;
    private TupleDescriptor mergeActionTuple_;
    private TupleId targetTupleId_;
    private List<Expr> targetExpressions_;
    private List<Expr> targetDeleteMetaExpressions_;
    private List<Expr> targetPartitionMetaExpressions_;
    private List<Expr> targetPartitionExpressions_;
    private MergeSorting targetSorting_;
    private Expr rowPresentExpression_;
    private Expr mergeActionExpression_;

    public IcebergMergeImpl(MergeStmt stmt, TableRef target, TableRef source, Expr on) {
        this.mergeStmt_ = stmt;
        this.targetTableRef_ = target;
        this.sourceTableRef_ = source;
        this.on_ = on;
        this.table_ = this.targetTableRef_.getTable();
        this.targetExpressions_ = Lists.newArrayList();
        this.targetDeleteMetaExpressions_ = Lists.newArrayList();
        this.targetPartitionMetaExpressions_ = Lists.newArrayList();
        this.targetPartitionExpressions_ = Lists.newArrayList();
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.queryStmt_ != null) {
            Preconditions.checkState((this.queryStmt_.fromClause_.size() == 2 ? 1 : 0) != 0);
            this.sourceTableRef_ = analyzer.resolveTableRef(this.sourceTableRef_);
            this.targetTableRef_ = analyzer.resolveTableRef(this.targetTableRef_);
            this.queryStmt_.fromClause_.set(0, this.targetTableRef_);
            this.queryStmt_.fromClause_.set(1, this.sourceTableRef_);
        }
        this.setJoinParams();
        this.targetTableRef_.analyze(analyzer);
        if (this.targetTableRef_.isTableMaskingView()) {
            this.targetTableRef_ = ((InlineViewRef)this.targetTableRef_).getUnMaskedTableRef();
        }
        FeTable table = this.targetTableRef_.getTable();
        Preconditions.checkState((boolean)(table instanceof FeIcebergTable));
        this.icebergTable_ = (FeIcebergTable)table;
        IcebergUtil.validateIcebergTableForInsert(this.icebergTable_);
        String modifyWriteMode = (String)this.icebergTable_.getIcebergApiTable().properties().get("write.merge.mode");
        if (modifyWriteMode != null && !Objects.equals(modifyWriteMode, "merge-on-read") && !BackendConfig.INSTANCE.icebergAlwaysAllowMergeOnReadOperations()) {
            throw new AnalysisException(String.format("Unsupported '%s': '%s' for Iceberg table: %s", "write.merge.mode", modifyWriteMode, this.icebergTable_.getFullName()));
        }
        for (Column column : this.icebergTable_.getColumns()) {
            Path slotPath = new Path(this.targetTableRef_.desc_, Collections.singletonList(column.getName()));
            slotPath.resolve();
            analyzer.registerSlotRef(slotPath);
        }
        this.sourceTableRef_.analyze(analyzer);
        this.queryStmt_ = this.prepareQuery();
        this.queryStmt_.analyze(analyzer);
        this.targetTupleId_ = this.targetTableRef_.getId();
        this.addMergeActionTuple(analyzer);
        if (!this.mergeStmt_.hasOnlyInsertCases()) {
            this.icebergPositionalDeleteTable_ = new IcebergPositionDeleteTable(this.icebergTable_);
            this.deleteTableId_ = analyzer.getDescTbl().addTargetTable(this.icebergPositionalDeleteTable_);
        }
        IcebergUtil.populatePartitionExprs(analyzer, null, this.table_.getColumns(), this.getResultExprs(), this.icebergTable_, this.targetPartitionExpressions_, null);
        analyzer.registerPrivReq(builder -> builder.onTable(this.icebergTable_).allOf(Privilege.ALL).build());
        this.targetSorting_ = this.getSorting();
        analyzer.getDescTbl().setTargetTable(this.icebergTable_);
    }

    private void setJoinParams() {
        if (this.mergeStmt_.hasOnlyMatchedCases()) {
            this.sourceTableRef_.setJoinOp(JoinOperator.INNER_JOIN);
        } else {
            this.sourceTableRef_.setJoinOp(JoinOperator.FULL_OUTER_JOIN);
        }
        this.sourceTableRef_.setOnClause(this.on_);
        this.sourceTableRef_.setLeftTblRef(this.targetTableRef_);
    }

    private void addMergeActionTuple(Analyzer analyzer) {
        this.mergeActionTuple_ = analyzer.getDescTbl().createTupleDescriptor(MERGE_ACTION_TUPLE_NAME);
        SlotDescriptor sd = analyzer.addSlotDescriptor(this.mergeActionTuple_);
        sd.setType(Type.TINYINT);
        sd.setIsMaterialized(true);
        sd.setIsNullable(false);
        this.mergeActionExpression_ = new SlotRef(sd);
        sd.setSourceExpr(this.mergeActionExpression_);
    }

    @Override
    public void substituteResultExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.targetExpressions_ = Expr.substituteList(this.targetExpressions_, smap, analyzer, true);
        this.targetPartitionMetaExpressions_ = Expr.substituteList(this.targetPartitionMetaExpressions_, smap, analyzer, true);
        this.targetDeleteMetaExpressions_ = Expr.substituteList(this.targetDeleteMetaExpressions_, smap, analyzer, true);
        this.mergeActionExpression_ = this.mergeActionExpression_.substitute(smap, analyzer, true);
        this.targetPartitionExpressions_ = Expr.substituteList(this.targetPartitionExpressions_, smap, analyzer, true);
        for (MergeCase mergeCase : this.mergeStmt_.getCases()) {
            mergeCase.substituteResultExprs(smap, analyzer);
        }
    }

    @Override
    public List<Expr> getResultExprs() {
        ArrayList result = Lists.newArrayList(this.targetExpressions_);
        result.addAll(this.targetDeleteMetaExpressions_);
        result.addAll(this.targetPartitionMetaExpressions_);
        result.add(this.mergeActionExpression_);
        return result;
    }

    @Override
    public List<Expr> getPartitionKeyExprs() {
        return this.targetPartitionExpressions_;
    }

    @Override
    public List<Expr> getSortExprs() {
        return this.targetSorting_.sortingExpressions_;
    }

    @Override
    public TSortingOrder getSortingOrder() {
        return this.targetSorting_.order_;
    }

    @Override
    public QueryStmt getQueryStmt() {
        return this.queryStmt_;
    }

    @Override
    public PlanNode getPlanNode(PlannerContext ctx, PlanNode child, Analyzer analyzer) throws ImpalaException {
        List<MergeCase> copyOfCases = this.mergeStmt_.getCases().stream().map(MergeCase::clone).collect(Collectors.toList());
        List<Expr> deleteMetaExprs = Expr.cloneList(this.targetDeleteMetaExpressions_);
        List<Expr> partitionMetaExprs = Expr.cloneList(this.targetPartitionMetaExpressions_);
        IcebergMergeNode mergeNode = new IcebergMergeNode(ctx.getNextNodeId(), child, copyOfCases, this.rowPresentExpression_.clone(), deleteMetaExprs, partitionMetaExprs, this.mergeActionTuple_, this.targetTupleId_);
        mergeNode.init(analyzer);
        return mergeNode;
    }

    @Override
    public void reset() {
        this.queryStmt_.reset();
        this.targetTableRef_ = this.queryStmt_.fromClause_.get(0);
        this.sourceTableRef_ = this.queryStmt_.fromClause_.get(1);
        this.targetPartitionExpressions_.clear();
    }

    @Override
    public DataSink createDataSink() {
        if (this.mergeStmt_.hasOnlyDeleteCases()) {
            return this.createDeleteSink();
        }
        if (this.mergeStmt_.hasOnlyInsertCases()) {
            return this.createInsertSink();
        }
        TableSink insertSink = this.createInsertSink();
        TableSink deleteSink = this.createDeleteSink();
        return new IcebergMergeSink(insertSink, deleteSink, Collections.singletonList(this.mergeActionExpression_));
    }

    public TableSink createDeleteSink() {
        List<Expr> deletePartitionKeys = Collections.emptyList();
        if (this.icebergTable_.isPartitioned()) {
            deletePartitionKeys = this.targetPartitionMetaExpressions_;
        }
        return new IcebergBufferedDeleteSink(this.icebergPositionalDeleteTable_, deletePartitionKeys, this.targetDeleteMetaExpressions_, this.deleteTableId_);
    }

    public TableSink createInsertSink() {
        return TableSink.create(this.icebergTable_, TableSink.Op.INSERT, this.targetPartitionExpressions_, this.targetExpressions_, Collections.emptyList(), false, true, this.targetSorting_.sortingColumnsAndOrder(), -1L, null, this.mergeStmt_.maxTableSinks_);
    }

    public SelectStmt prepareQuery() {
        ArrayList selectListItems = Lists.newArrayList();
        SelectList selectList = new SelectList(selectListItems);
        selectList.setPlanHints(Collections.singletonList(new PlanHint("straight_join")));
        List targetSlotRefs = this.targetTableRef_.getTable().getColumns().stream().map(column -> new SlotRef((List<String>)ImmutableList.of((Object)this.targetTableRef_.getUniqueAlias(), (Object)column.getName()))).collect(Collectors.toList());
        SelectListItem sourceColumns = SelectListItem.createStarItem(Collections.singletonList(this.sourceTableRef_.getUniqueAlias()));
        CastExpr rowPresentExpression = this.createRowPresentExpression(this.targetTableRef_, this.sourceTableRef_);
        ImmutableList partitionMetaExpressions = Collections.emptyList();
        if (this.icebergTable_.isPartitioned()) {
            partitionMetaExpressions = ImmutableList.of((Object)new SlotRef((List<String>)ImmutableList.of((Object)this.targetTableRef_.getUniqueAlias(), (Object)VirtualColumn.PARTITION_SPEC_ID.getName())), (Object)new SlotRef((List<String>)ImmutableList.of((Object)this.targetTableRef_.getUniqueAlias(), (Object)VirtualColumn.ICEBERG_PARTITION_SERIALIZED.getName())));
        }
        ArrayList deleteMetaExpressions = Lists.newArrayList();
        boolean hasEqualityDeleteFiles = !this.icebergTable_.getContentFileStore().getEqualityDeleteFiles().isEmpty();
        deleteMetaExpressions.add(new SlotRef((List<String>)ImmutableList.of((Object)this.targetTableRef_.getUniqueAlias(), (Object)VirtualColumn.INPUT_FILE_NAME.getName())));
        deleteMetaExpressions.add(new SlotRef((List<String>)ImmutableList.of((Object)this.targetTableRef_.getUniqueAlias(), (Object)VirtualColumn.FILE_POSITION.getName())));
        if (hasEqualityDeleteFiles) {
            deleteMetaExpressions.add(new SlotRef((List<String>)ImmutableList.of((Object)this.targetTableRef_.getUniqueAlias(), (Object)VirtualColumn.ICEBERG_DATA_SEQUENCE_NUMBER.getName())));
        }
        selectListItems.add(new SelectListItem(rowPresentExpression, ROW_PRESENT));
        selectListItems.addAll(targetSlotRefs.stream().map(expr -> new SelectListItem((Expr)expr, null)).collect(Collectors.toList()));
        selectListItems.addAll(deleteMetaExpressions.stream().map(expr -> new SelectListItem((Expr)expr, null)).collect(Collectors.toList()));
        selectListItems.addAll(partitionMetaExpressions.stream().map(expr -> new SelectListItem((Expr)expr, null)).collect(Collectors.toList()));
        selectListItems.add(sourceColumns);
        this.rowPresentExpression_ = rowPresentExpression;
        this.targetPartitionMetaExpressions_ = partitionMetaExpressions;
        this.targetDeleteMetaExpressions_ = deleteMetaExpressions;
        this.targetExpressions_ = targetSlotRefs;
        FromClause fromClause = new FromClause(Lists.newArrayList((Object[])new TableRef[]{this.targetTableRef_, this.sourceTableRef_}));
        return new SelectStmt(selectList, fromClause, null, null, null, null, null);
    }

    private CastExpr createRowPresentExpression(TableRef targetTableRef, TableRef sourceTableRef) {
        TupleIsNullPredicate targetPresent = new TupleIsNullPredicate(targetTableRef.getMaterializedTupleIds());
        TupleIsNullPredicate sourcePresent = new TupleIsNullPredicate(sourceTableRef.getMaterializedTupleIds());
        CastExpr targetPresentAsTinyInt = new CastExpr(new TypeDef(Type.TINYINT), (Expr)targetPresent);
        CastExpr sourcePresentAsTinyInt = new CastExpr(new TypeDef(Type.TINYINT), (Expr)sourcePresent);
        ArithmeticExpr sourcePresentShifted = new ArithmeticExpr(ArithmeticExpr.Operator.MULTIPLY, sourcePresentAsTinyInt, NumericLiteral.create(2L));
        return new CastExpr(new TypeDef(Type.TINYINT), (Expr)new ArithmeticExpr(ArithmeticExpr.Operator.ADD, targetPresentAsTinyInt, sourcePresentShifted));
    }

    private MergeSorting getSorting() throws AnalysisException {
        Pair<List<Integer>, TSortingOrder> sortProperties = AlterTableSetTblProperties.analyzeSortColumns(this.table_, this.table_.getMetaStoreTable().getParameters());
        List sortColumnPositions = (List)sortProperties.first;
        List<Expr> sortExpressions = sortColumnPositions.stream().map(this.getResultExprs()::get).collect(Collectors.toList());
        return new MergeSorting(sortColumnPositions, sortExpressions, (TSortingOrder)((Object)sortProperties.second));
    }

    protected static class MergeSorting {
        private final List<Integer> sortingColumnPositions_;
        private final List<Expr> sortingExpressions_;
        private final TSortingOrder order_;

        public MergeSorting(List<Integer> sortingColumnPositions, List<Expr> sortingExpressions, TSortingOrder order) {
            this.sortingColumnPositions_ = sortingColumnPositions;
            this.sortingExpressions_ = sortingExpressions;
            this.order_ = order;
        }

        public Pair<List<Integer>, TSortingOrder> sortingColumnsAndOrder() {
            return Pair.create(this.sortingColumnPositions_, this.order_);
        }
    }
}

