/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.AuthorizationStmt;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TGrantRevokeRoleParams;

public class GrantRevokeRoleStmt
extends AuthorizationStmt {
    private final String roleName_;
    private final String groupName_;
    private final boolean isGrantStmt_;

    public GrantRevokeRoleStmt(String roleName, String groupName, boolean isGrantStmt) {
        Preconditions.checkNotNull((Object)roleName);
        Preconditions.checkNotNull((Object)groupName);
        this.roleName_ = roleName;
        this.groupName_ = groupName;
        this.isGrantStmt_ = isGrantStmt;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return String.format("%s ROLE %s %s GROUP %s", this.isGrantStmt_ ? "GRANT" : "REVOKE", this.roleName_, this.isGrantStmt_ ? "TO" : "FROM", this.groupName_);
    }

    public TGrantRevokeRoleParams toThrift() {
        TGrantRevokeRoleParams params = new TGrantRevokeRoleParams();
        params.setRole_names(Lists.newArrayList((Object[])new String[]{this.roleName_}));
        params.setGroup_names(Lists.newArrayList((Object[])new String[]{this.groupName_}));
        params.setIs_grant(this.isGrantStmt_);
        return params;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        if (Strings.isNullOrEmpty((String)this.roleName_)) {
            throw new AnalysisException("Role name in GRANT/REVOKE ROLE cannot be empty.");
        }
        if (Strings.isNullOrEmpty((String)this.groupName_)) {
            throw new AnalysisException("Group name in GRANT/REVOKE ROLE cannot be empty.");
        }
    }

    @Override
    public boolean requiresHmsMetadata() {
        return false;
    }
}

