/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TypeDef;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;

public class FunctionArgs
extends StmtNode {
    private final List<TypeDef> argTypeDefs_;
    private boolean hasVarArgs_;
    private List<Type> argTypes_;

    public FunctionArgs() {
        this.argTypeDefs_ = new ArrayList<TypeDef>();
        this.hasVarArgs_ = false;
    }

    public FunctionArgs(List<TypeDef> argTypeDefs, boolean varArgs) {
        this.argTypeDefs_ = argTypeDefs;
        this.hasVarArgs_ = varArgs;
        if (varArgs) {
            Preconditions.checkState((argTypeDefs.size() > 0 ? 1 : 0) != 0);
        }
    }

    public void setHasVarArgs(boolean b) {
        Preconditions.checkState((this.argTypeDefs_.size() > 0 ? 1 : 0) != 0);
        this.hasVarArgs_ = b;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        ArrayList argTypes = Lists.newArrayListWithCapacity((int)this.argTypeDefs_.size());
        for (TypeDef typeDef : this.argTypeDefs_) {
            typeDef.analyze(analyzer);
            argTypes.add(typeDef.getType());
        }
        this.argTypes_ = argTypes;
    }

    public List<TypeDef> getArgTypeDefs() {
        return this.argTypeDefs_;
    }

    public List<Type> getArgTypes() {
        return this.argTypes_;
    }

    public boolean hasVarArgs() {
        return this.hasVarArgs_;
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return null;
    }
}

