/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.service.BackendConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExprSubstitutionMap {
    private static final Logger LOG = LoggerFactory.getLogger(ExprSubstitutionMap.class);
    private List<Expr> lhs_;
    private List<Expr> rhs_;
    private Map<Expr, Expr> substitutions_;

    public ExprSubstitutionMap() {
        this(new ArrayList<Expr>(), new ArrayList<Expr>());
    }

    public ExprSubstitutionMap(List<Expr> lhs, List<Expr> rhs) {
        Preconditions.checkArgument((lhs.size() == rhs.size() ? 1 : 0) != 0);
        this.lhs_ = lhs;
        this.rhs_ = rhs;
        this.buildMap();
        this.verify();
    }

    private void buildMap() {
        this.substitutions_ = new HashMap<Expr, Expr>();
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (int i = 0; i < this.lhs_.size(); ++i) {
            Expr existingVal = this.substitutions_.putIfAbsent(this.lhs_.get(i), this.rhs_.get(i));
            if (existingVal == null) continue;
            toRemove.add(i);
        }
        Collections.reverse(toRemove);
        Iterator iterator = toRemove.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.lhs_.remove(i);
            this.rhs_.remove(i);
        }
    }

    public void put(Expr lhsExpr, Expr rhsExpr) {
        if (this.substitutions_.containsKey(lhsExpr)) {
            return;
        }
        Preconditions.checkState((boolean)rhsExpr.isAnalyzed(), (Object)"Rhs expr must be analyzed.");
        this.lhs_.add(lhsExpr);
        this.rhs_.add(rhsExpr);
        this.substitutions_.put(lhsExpr, rhsExpr);
    }

    public Expr get(Expr lhsExpr) {
        return this.substitutions_.get(lhsExpr);
    }

    public boolean containsMappingFor(Expr lhsExpr) {
        return this.substitutions_.containsKey(lhsExpr);
    }

    public static ExprSubstitutionMap compose(ExprSubstitutionMap f, ExprSubstitutionMap g, Analyzer analyzer) {
        if (f == null && g == null) {
            return new ExprSubstitutionMap();
        }
        if (f == null) {
            return g;
        }
        if (g == null) {
            return f;
        }
        ExprSubstitutionMap result = new ExprSubstitutionMap(new ArrayList<Expr>(f.lhs_), Expr.substituteList(f.rhs_, g, analyzer, false));
        for (int i = 0; i < g.lhs_.size(); ++i) {
            result.put(g.lhs_.get(i), g.rhs_.get(i).clone());
        }
        return result;
    }

    public static ExprSubstitutionMap combine(ExprSubstitutionMap f, ExprSubstitutionMap g) {
        if (f == null && g == null) {
            return new ExprSubstitutionMap();
        }
        if (f == null) {
            return g;
        }
        if (g == null) {
            return f;
        }
        return new ExprSubstitutionMap(Lists.newArrayList((Iterable)Iterables.concat(f.lhs_, g.lhs_)), Lists.newArrayList((Iterable)Iterables.concat(f.rhs_, g.rhs_)));
    }

    public void substituteLhs(ExprSubstitutionMap lhsSmap, Analyzer analyzer) {
        this.lhs_ = Expr.substituteList(this.lhs_, lhsSmap, analyzer, false);
        this.buildMap();
        this.verify();
    }

    public List<Expr> getLhs() {
        return this.lhs_;
    }

    public List<Expr> getRhs() {
        return this.rhs_;
    }

    public int size() {
        return this.lhs_.size();
    }

    public String debugString() {
        Preconditions.checkState((this.lhs_.size() == this.rhs_.size() ? 1 : 0) != 0);
        ArrayList<String> output = new ArrayList<String>();
        for (int i = 0; i < this.lhs_.size(); ++i) {
            output.add(this.lhs_.get(i).toSql() + ":" + this.rhs_.get(i).toSql());
            output.add("(" + this.lhs_.get(i).debugString() + ":" + this.rhs_.get(i).debugString() + ")");
        }
        return "smap(" + Joiner.on((String)" ").join(output) + ")";
    }

    private void verify() {
        Preconditions.checkState((this.lhs_.size() == this.rhs_.size() ? 1 : 0) != 0);
        Preconditions.checkState((this.substitutions_.size() == this.lhs_.size() ? 1 : 0) != 0);
        if (BackendConfig.INSTANCE.isReleaseBuild()) {
            return;
        }
        for (int i = 0; i < this.lhs_.size(); ++i) {
            Preconditions.checkState((boolean)this.substitutions_.get(this.lhs_.get(i)).equals(this.rhs_.get(i)));
            Preconditions.checkState((boolean)this.rhs_.get(i).isAnalyzed());
        }
    }

    public void clear() {
        this.lhs_.clear();
        this.rhs_.clear();
        this.substitutions_.clear();
    }

    public ExprSubstitutionMap clone() {
        return new ExprSubstitutionMap(new ArrayList<Expr>(this.lhs_), Expr.cloneList(this.rhs_));
    }

    public boolean checkComposedFrom(ExprSubstitutionMap other) {
        for (int i = 0; i < other.lhs_.size() - 1; ++i) {
            for (int j = i + 1; j < other.lhs_.size(); ++j) {
                Expr a = other.lhs_.get(i);
                Expr b = other.lhs_.get(j);
                Expr finalA = this.get(a);
                Expr finalB = this.get(b);
                if (finalA == null || finalB == null) {
                    if (LOG.isTraceEnabled()) {
                        if (finalA == null) {
                            LOG.trace("current smap misses item for " + a.debugString());
                        }
                        if (finalB == null) {
                            LOG.trace("current smap misses item for " + b.debugString());
                        }
                    }
                    return false;
                }
                if (!other.rhs_.get(i).equals(other.rhs_.get(j)) || finalA.equals(finalB)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace(String.format("smap conflicts in substituting %s and %s. Result of the base map: %s. Results of current map: %s and %s", a.debugString(), b.debugString(), other.rhs_.get(i).debugString(), finalA.debugString(), finalB.debugString()));
                }
                return false;
            }
        }
        return true;
    }
}

