/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ArithmeticExpr;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.CaseExpr;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.ConstantPredicateHandler;
import org.apache.impala.analysis.ExprId;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.IsNullPredicate;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.ParseNode;
import org.apache.impala.analysis.PlanHint;
import org.apache.impala.analysis.Predicate;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SlotDescriptor;
import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.SqlCastException;
import org.apache.impala.common.ThriftSerializationCtx;
import org.apache.impala.common.TreeNode;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TExplainLevel;
import org.apache.impala.thrift.TExpr;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TFunction;
import org.apache.impala.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Expr
extends TreeNode<Expr>
implements ParseNode,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(Expr.class);
    public static final int EXPR_CHILDREN_LIMIT = 10000;
    public static final int EXPR_DEPTH_LIMIT = 1000;
    private static final String NEGATE_FN = "negate";
    public static final double DEFAULT_SELECTIVITY = 0.1;
    public static final float ARITHMETIC_OP_COST = 1.0f;
    public static final float BINARY_PREDICATE_COST = 1.0f;
    public static final float VAR_LEN_BINARY_PREDICATE_COST = 5.0f;
    public static final float COMPOUND_PREDICATE_COST = 1.0f;
    public static final float FUNCTION_CALL_COST = 10.0f;
    public static final float IS_NOT_EMPTY_COST = 1.0f;
    public static final float IS_NULL_COST = 1.0f;
    public static final float LIKE_COST = 10.0f;
    public static final float LITERAL_COST = 1.0f;
    public static final float SLOT_REF_COST = 1.0f;
    public static final float TIMESTAMP_ARITHMETIC_COST = 5.0f;
    public static final float UNKNOWN_COST = -1.0f;
    private static final int CONST_PROPAGATION_EXPR_LIMIT = 200;
    public static final int DEFAULT_AVG_STRING_LENGTH = 5;
    public static final com.google.common.base.Predicate<Expr> IS_AGGREGATE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof FunctionCallExpr && ((FunctionCallExpr)arg).isAggregateFunction();
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_NOT_PREDICATE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof CompoundPredicate && ((CompoundPredicate)arg).getOp() == CompoundPredicate.Operator.NOT;
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_OR_PREDICATE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof CompoundPredicate && ((CompoundPredicate)arg).getOp() == CompoundPredicate.Operator.OR;
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_SCALAR_SUBQUERY = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg.isScalarSubquery();
        }
    };
    public static final com.google.common.base.Predicate<Expr> HAS_SUBQUERY_CHILD = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            for (Expr child : arg.getChildren()) {
                if (!(child instanceof Subquery)) continue;
                return true;
            }
            return false;
        }
    };
    public static final com.google.common.base.Predicate<Expr> NON_NULL_EMPTY_AGG = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof FunctionCallExpr && ((FunctionCallExpr)arg).returnsNonNullOnEmpty();
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_BUILTIN_AGG_FN = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof FunctionCallExpr && ((FunctionCallExpr)arg).getFnName().isBuiltin();
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_UDA_FN = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return IS_AGGREGATE.apply((Object)arg) && !((FunctionCallExpr)arg).getFnName().isBuiltin();
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_TRUE_LITERAL = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof BoolLiteral && ((BoolLiteral)arg).getValue();
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_FALSE_LITERAL = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof BoolLiteral && !((BoolLiteral)arg).getValue();
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_EQ_BINARY_PREDICATE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return BinaryPredicate.getEqSlots(arg) != null;
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_NOT_EQ_BINARY_PREDICATE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof BinaryPredicate && ((BinaryPredicate)arg).getOp() != BinaryPredicate.Operator.EQ && ((BinaryPredicate)arg).getOp() != BinaryPredicate.Operator.NOT_DISTINCT;
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_BINARY_PREDICATE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof BinaryPredicate;
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_EXPR_EQ_LITERAL_PREDICATE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof BinaryPredicate && ((BinaryPredicate)arg).getOp() == BinaryPredicate.Operator.EQ && IS_LITERAL.apply(((BinaryPredicate)arg).getChild(1));
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_NONDETERMINISTIC_BUILTIN_FN_PREDICATE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof FunctionCallExpr && ((FunctionCallExpr)arg).isNondeterministicBuiltinFn();
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_UDF_PREDICATE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof FunctionCallExpr && !((FunctionCallExpr)arg).getFnName().isBuiltin();
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_LITERAL = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof LiteralExpr;
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_NULL_LITERAL = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof NullLiteral;
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_NON_NULL_LITERAL = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return IS_LITERAL.apply((Object)arg) && !IS_NULL_LITERAL.apply((Object)arg);
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_NULL_VALUE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            if (arg instanceof NullLiteral) {
                return true;
            }
            if (!(arg instanceof CastExpr)) {
                return false;
            }
            return IS_NULL_VALUE.apply(((CastExpr)arg).getChild(0));
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_LITERAL_VALUE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return IS_LITERAL.apply((Object)arg) || IS_NULL_VALUE.apply((Object)arg);
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_INT_LITERAL = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return IS_LITERAL.apply((Object)arg) && arg.getType().isIntegerType();
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_CONDITIONAL_BUILTIN_FN_PREDICATE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof FunctionCallExpr && ((FunctionCallExpr)arg).isConditionalBuiltinFn();
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_IS_NULL_PREDICATE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof IsNullPredicate && !((IsNullPredicate)arg).isNotNull();
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_DISTINCT_FROM_OR_NOT_DISTINCT_PREDICATE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof BinaryPredicate && (((BinaryPredicate)arg).getOp() == BinaryPredicate.Operator.DISTINCT_FROM || ((BinaryPredicate)arg).getOp() == BinaryPredicate.Operator.NOT_DISTINCT);
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_CASE_EXPR_PREDICATE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof CaseExpr;
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_ALWAYS_TRUE_PREDICATE = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof Predicate && ((Predicate)arg).hasAlwaysTrueHint();
        }
    };
    public static final com.google.common.base.Predicate<Expr> IS_FN_SLEEP = new com.google.common.base.Predicate<Expr>(){

        public boolean apply(Expr arg) {
            return arg instanceof FunctionCallExpr && ((FunctionCallExpr)arg).getFnName().isBuiltin() && ((FunctionCallExpr)arg).getFnName().getFunction() != null && ((FunctionCallExpr)arg).getFnName().getFunction().equals("sleep");
        }
    };
    protected ExprId id_;
    private boolean isAuxExpr_ = false;
    protected Type type_;
    protected boolean isOnClauseConjunct_;
    protected boolean printSqlInParens_ = false;
    protected double selectivity_;
    protected float evalCost_;
    protected long numDistinctValues_;
    private boolean isConstant_;
    protected org.apache.impala.catalog.Function fn_;
    private boolean isAnalyzed_ = false;
    private boolean isRewritten_ = false;
    private boolean isCountedForNumStmtExprs_ = false;
    protected List<PlanHint> predicateHints_;
    private boolean isCodegenDisabled_ = false;

    protected Expr() {
        this.type_ = Type.INVALID;
        this.selectivity_ = -1.0;
        this.evalCost_ = -1.0f;
        this.numDistinctValues_ = -1L;
    }

    protected Expr(Expr other) {
        this.id_ = other.id_;
        this.isAuxExpr_ = other.isAuxExpr_;
        this.type_ = other.type_;
        this.isAnalyzed_ = other.isAnalyzed_;
        this.isRewritten_ = other.isRewritten_;
        this.isOnClauseConjunct_ = other.isOnClauseConjunct_;
        this.printSqlInParens_ = other.printSqlInParens_;
        this.selectivity_ = other.selectivity_;
        this.evalCost_ = other.evalCost_;
        this.numDistinctValues_ = other.numDistinctValues_;
        this.isConstant_ = other.isConstant_;
        this.fn_ = other.fn_;
        this.isCountedForNumStmtExprs_ = other.isCountedForNumStmtExprs_;
        this.children_ = Expr.cloneList(other.children_);
        if (other.predicateHints_ != null) {
            this.predicateHints_ = new ArrayList<PlanHint>();
            this.predicateHints_.addAll(other.predicateHints_);
        }
        this.isCodegenDisabled_ = other.isCodegenDisabled_;
    }

    public boolean isAnalyzed() {
        return this.isAnalyzed_;
    }

    public boolean isRewritten() {
        return this.isRewritten_;
    }

    public void setRewritten(boolean isRewritten) {
        this.isRewritten_ = isRewritten;
    }

    public ExprId getId() {
        return this.id_;
    }

    protected void setId(ExprId id) {
        this.id_ = id;
    }

    public Type getType() {
        return this.type_;
    }

    public double getSelectivity() {
        return this.selectivity_;
    }

    public boolean hasSelectivity() {
        return this.selectivity_ >= 0.0;
    }

    public float getCost() {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        return this.evalCost_;
    }

    public boolean hasCost() {
        return this.evalCost_ >= 0.0f;
    }

    public long getNumDistinctValues() {
        return this.numDistinctValues_;
    }

    public boolean getPrintSqlInParens() {
        return this.printSqlInParens_;
    }

    public void setPrintSqlInParens(boolean b) {
        this.printSqlInParens_ = b;
    }

    public boolean isOnClauseConjunct() {
        return this.isOnClauseConjunct_;
    }

    public void setIsOnClauseConjunct(boolean b) {
        this.isOnClauseConjunct_ = b;
    }

    public boolean isAuxExpr() {
        return this.isAuxExpr_;
    }

    public void setIsAuxExpr() {
        this.isAuxExpr_ = true;
    }

    public org.apache.impala.catalog.Function getFn() {
        return this.fn_;
    }

    public void disableCodegen() {
        this.isCodegenDisabled_ = true;
        for (Expr child : this.children_) {
            child.disableCodegen();
        }
    }

    public final void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed()) {
            return;
        }
        if (this.children_.size() > 10000) {
            String sql = this.toSql();
            String sqlSubstr = sql.substring(0, Math.min(80, sql.length()));
            throw new AnalysisException(String.format("Exceeded the maximum number of child expressions (%s).\nExpression has %s children:\n%s...", 10000, this.children_.size(), sqlSubstr));
        }
        if (analyzer != null) {
            analyzer.incrementCallDepth();
            if (analyzer.getCallDepth() > 1000) {
                throw new AnalysisException(String.format("Exceeded the maximum depth of an expression tree (%s).", 1000));
            }
            this.incrementNumStmtExprs(analyzer);
        }
        for (Expr child : this.children_) {
            child.analyze(analyzer);
        }
        if (analyzer != null) {
            analyzer.decrementCallDepth();
        }
        this.computeNumDistinctValues();
        this.analyzeImpl(analyzer);
        this.evalCost_ = this.computeEvalCost();
        this.analysisDone();
    }

    protected void analyzeHints(Analyzer analyzer) throws AnalysisException {
        if (this.predicateHints_ != null && !this.predicateHints_.isEmpty()) {
            if (!(this instanceof Predicate)) {
                throw new AnalysisException("Expr hints are only supported for predicates");
            }
            for (PlanHint hint : this.predicateHints_) {
                if (hint.is("ALWAYS_TRUE")) {
                    ((Predicate)this).setHasAlwaysTrueHint(true);
                    List<Expr> conjuncts = this.getConjuncts();
                    if (conjuncts.size() > 1) {
                        for (Expr e : conjuncts) {
                            ((Predicate)e).setHasAlwaysTrueHint(true);
                        }
                    }
                    analyzer.setHasPlanHints();
                    continue;
                }
                analyzer.addWarning("Predicate hint not recognized: " + hint);
            }
        }
    }

    protected abstract void analyzeImpl(Analyzer var1) throws AnalysisException;

    public void analyzeNoThrow(Analyzer analyzer) {
        try {
            this.analyze(analyzer);
        }
        catch (AnalysisException e) {
            throw new IllegalStateException(e);
        }
    }

    private void incrementNumStmtExprs(Analyzer analyzer) {
        if (analyzer.hasWithClause()) {
            return;
        }
        if (this.isCountedForNumStmtExprs_) {
            return;
        }
        analyzer.incrementNumStmtExprs();
        this.isCountedForNumStmtExprs_ = true;
    }

    protected abstract float computeEvalCost();

    protected void computeNumDistinctValues() {
        if (this.isConstant()) {
            this.numDistinctValues_ = 1L;
        } else {
            this.numDistinctValues_ = -1L;
            for (Expr child : this.children_) {
                if (child.isConstant()) continue;
                this.numDistinctValues_ = Math.max(this.numDistinctValues_, child.getNumDistinctValues());
            }
        }
    }

    protected Type[] collectChildReturnTypes() {
        Type[] childTypes = new Type[this.children_.size()];
        for (int i = 0; i < this.children_.size(); ++i) {
            childTypes[i] = ((Expr)this.children_.get((int)i)).type_;
        }
        return childTypes;
    }

    protected org.apache.impala.catalog.Function getBuiltinFunction(Analyzer analyzer, String name, Type[] argTypes, Function.CompareMode mode) throws AnalysisException {
        FunctionName fnName = new FunctionName("_impala_builtins", name);
        org.apache.impala.catalog.Function searchDesc = new org.apache.impala.catalog.Function(fnName, argTypes, (Type)Type.INVALID, false);
        return analyzer.getCatalog().getFunction(searchDesc, mode);
    }

    protected void castForFunctionCall(boolean ignoreWildcardDecimals, TypeCompatibility compatibility) throws AnalysisException {
        Preconditions.checkState((this.fn_ != null ? 1 : 0) != 0);
        Type[] fnArgs = this.fn_.getArgs();
        Type resolvedWildcardType = this.getResolvedWildCardType(compatibility);
        if (resolvedWildcardType != null) {
            if (resolvedWildcardType.isNull()) {
                throw new SqlCastException(String.format("Cannot resolve DECIMAL precision and scale from NULL type in %s function.", this.fn_.getFunctionName().getFunction()));
            }
            if (resolvedWildcardType.isInvalid() && !ignoreWildcardDecimals) {
                StringBuilder argTypes = new StringBuilder();
                for (int j = 0; j < this.children_.size(); ++j) {
                    if (argTypes.length() > 0) {
                        argTypes.append(", ");
                    }
                    Type childType = ((Expr)this.children_.get((int)j)).type_;
                    argTypes.append(childType.toSql());
                }
                throw new SqlCastException(String.format("Cannot resolve DECIMAL types of the %s(%s) function arguments. You need to wrap the arguments in a CAST.", this.fn_.getFunctionName().getFunction(), argTypes.toString()));
            }
        }
        for (int i = 0; i < this.children_.size(); ++i) {
            int ix = Math.min(fnArgs.length - 1, i);
            if (fnArgs[ix].isWildcardDecimal()) {
                if (((Expr)this.children_.get((int)i)).type_.isDecimal() && ignoreWildcardDecimals) continue;
                if (((Expr)this.children_.get((int)i)).type_.isDecimal() || !ignoreWildcardDecimals) {
                    Preconditions.checkState((resolvedWildcardType != null ? 1 : 0) != 0);
                    Preconditions.checkState((!resolvedWildcardType.isInvalid() ? 1 : 0) != 0);
                    if (((Expr)this.children_.get((int)i)).type_.equals(resolvedWildcardType)) continue;
                    this.castChild(resolvedWildcardType, i);
                    continue;
                }
                if (((Expr)this.children_.get((int)i)).type_.isNull()) {
                    this.castChild(ScalarType.createDecimalType(), i);
                    continue;
                }
                Preconditions.checkState((boolean)((Expr)this.children_.get((int)i)).type_.isScalarType());
                Preconditions.checkState((boolean)ignoreWildcardDecimals);
                this.castChild(((ScalarType)((Expr)this.children_.get((int)i)).type_).getMinResolutionDecimal(), i);
                continue;
            }
            if (((Expr)this.children_.get((int)i)).type_.matchesType(fnArgs[ix])) continue;
            this.castChild(fnArgs[ix], i);
        }
    }

    Type getResolvedWildCardType(TypeCompatibility compatibility) {
        Preconditions.checkState((compatibility.equals((Object)TypeCompatibility.DEFAULT) || compatibility.equals((Object)TypeCompatibility.STRICT_DECIMAL) ? 1 : 0) != 0);
        Type result = null;
        Type[] fnArgs = this.fn_.getArgs();
        for (int i = 0; i < this.children_.size(); ++i) {
            int ix = Math.min(fnArgs.length - 1, i);
            if (!fnArgs[ix].isWildcardDecimal()) continue;
            Type childType = ((Expr)this.children_.get((int)i)).type_;
            Preconditions.checkState((!childType.isWildcardDecimal() ? 1 : 0) != 0, (Object)"Child expr should have been resolved.");
            Preconditions.checkState((boolean)childType.isScalarType(), (Object)"Function should not have resolved with a non-scalar child type.");
            if (result == null) {
                ScalarType decimalType = (ScalarType)childType;
                result = decimalType.getMinResolutionDecimal();
                continue;
            }
            result = Type.getAssignmentCompatibleType(result, childType, compatibility);
        }
        if (result != null && !result.isNull()) {
            Preconditions.checkState(((result = ((ScalarType)result).getMinResolutionDecimal()).isDecimal() || result.isInvalid() ? 1 : 0) != 0);
            Preconditions.checkState((!result.isWildcardDecimal() ? 1 : 0) != 0);
        }
        return result;
    }

    private boolean isExplicitCastToDecimal(Expr e) {
        if (!(e instanceof CastExpr)) {
            return false;
        }
        CastExpr c = (CastExpr)e;
        return !c.isImplicit() && c.getType().isDecimal();
    }

    private Expr convertDecimalLiteralsToFloat(Analyzer analyzer, Expr child, Type targetType) throws AnalysisException {
        if (!targetType.isFloatingPointType() && !targetType.isIntegerType()) {
            return child;
        }
        if (targetType.isIntegerType()) {
            targetType = Type.DOUBLE;
        }
        ArrayList literals = new ArrayList();
        child.collectAll(Predicates.instanceOf(NumericLiteral.class), literals);
        ExprSubstitutionMap smap = new ExprSubstitutionMap();
        for (NumericLiteral l : literals) {
            if (!l.getType().isDecimal()) continue;
            NumericLiteral castLiteral = (NumericLiteral)l.clone();
            castLiteral.explicitlyCastToFloat(targetType);
            smap.put(l, castLiteral);
        }
        return child.substitute(smap, analyzer, false);
    }

    protected void convertNumericLiteralsFromDecimal(Analyzer analyzer) throws AnalysisException {
        boolean c1IsConstantDecimal;
        Preconditions.checkState((this instanceof ArithmeticExpr || this instanceof BinaryPredicate ? 1 : 0) != 0);
        if (analyzer.getQueryOptions().isDecimal_v2()) {
            return;
        }
        if (this.getChildCount() == 1) {
            return;
        }
        Preconditions.checkState((this.getChildCount() == 2 ? 1 : 0) != 0);
        Type t0 = ((Expr)this.getChild(0)).getType();
        Type t1 = ((Expr)this.getChild(1)).getType();
        boolean c0IsConstantDecimal = ((Expr)this.getChild(0)).isConstant() && t0.isDecimal();
        boolean bl = c1IsConstantDecimal = ((Expr)this.getChild(1)).isConstant() && t1.isDecimal();
        if (c0IsConstantDecimal && c1IsConstantDecimal) {
            return;
        }
        if (!c0IsConstantDecimal && !c1IsConstantDecimal) {
            return;
        }
        if (c0IsConstantDecimal && !this.isExplicitCastToDecimal((Expr)this.getChild(0))) {
            Expr c0 = this.convertDecimalLiteralsToFloat(analyzer, (Expr)this.getChild(0), t1);
            this.setChild(0, c0);
        }
        if (c1IsConstantDecimal && !this.isExplicitCastToDecimal((Expr)this.getChild(1))) {
            Expr c1 = this.convertDecimalLiteralsToFloat(analyzer, (Expr)this.getChild(1), t0);
            this.setChild(1, c1);
        }
    }

    public static void analyze(List<? extends Expr> exprs, Analyzer analyzer) throws AnalysisException {
        if (exprs == null) {
            return;
        }
        for (Expr expr : exprs) {
            expr.analyze(analyzer);
        }
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return this.printSqlInParens_ ? "(" + this.toSqlImpl(options) + ")" : this.toSqlImpl(options);
    }

    protected abstract String toSqlImpl(ToSqlOptions var1);

    protected String toSqlImpl() {
        return this.toSqlImpl(ToSqlOptions.DEFAULT);
    }

    public TExpr treeToThrift() {
        return this.treeToThrift(new ThriftSerializationCtx());
    }

    public TExpr treeToThrift(ThriftSerializationCtx serialCtx) {
        if (this.type_.isNull()) {
            Preconditions.checkState((IS_NULL_LITERAL.apply((Object)this) || this instanceof SlotRef ? 1 : 0) != 0);
            return NullLiteral.create(ScalarType.BOOLEAN).treeToThrift(serialCtx);
        }
        TExpr result = new TExpr();
        this.treeToThriftHelper(result, serialCtx);
        return result;
    }

    protected void treeToThriftHelper(TExpr container, ThriftSerializationCtx serialCtx) {
        Preconditions.checkState((boolean)this.isAnalyzed_, (String)"Must be analyzed before serializing to thrift. %s", (Object)this);
        Preconditions.checkState((!this.type_.isWildcardDecimal() ? 1 : 0) != 0);
        Preconditions.checkState((!this.type_.isNull() ? 1 : 0) != 0, (Object)"Expr has type null!");
        TExprNode msg = new TExprNode();
        msg.type = this.type_.toThrift();
        msg.is_constant = this.isConstant_;
        msg.num_children = this.children_.size();
        msg.setIs_codegen_disabled(this.isCodegenDisabled_);
        if (this.fn_ != null) {
            TFunction thriftFn = this.fn_.toThrift();
            thriftFn.setLast_modified_time(this.fn_.getLastModifiedTime());
            msg.setFn(thriftFn);
            if (this.fn_.hasVarArgs()) {
                msg.setVararg_start_idx(this.fn_.getNumArgs() - 1);
            }
        }
        this.toThrift(msg, serialCtx);
        container.addToNodes(msg);
        for (Expr child : this.children_) {
            child.treeToThriftHelper(container, serialCtx);
        }
    }

    protected abstract void toThrift(TExprNode var1);

    protected void toThrift(TExprNode msg, ThriftSerializationCtx serialCtx) {
        this.toThrift(msg);
    }

    public static long getNumDistinctValues(List<Expr> exprs) {
        if (exprs == null || exprs.isEmpty()) {
            return 0L;
        }
        long numDistinctValues = 1L;
        for (Expr expr : exprs) {
            if (expr.getNumDistinctValues() == -1L) {
                numDistinctValues = -1L;
                break;
            }
            numDistinctValues = MathUtil.saturatingMultiply(numDistinctValues, expr.getNumDistinctValues());
        }
        return numDistinctValues;
    }

    public static List<TExpr> treesToThrift(List<? extends Expr> exprs, ThriftSerializationCtx serialCtx) {
        ArrayList<TExpr> result = new ArrayList<TExpr>();
        for (Expr expr : exprs) {
            result.add(expr.treeToThrift(serialCtx));
        }
        return result;
    }

    public static List<TExpr> treesToThrift(List<? extends Expr> exprs) {
        return Expr.treesToThrift(exprs, new ThriftSerializationCtx());
    }

    public boolean isAggregate() {
        return IS_AGGREGATE.apply((Object)this);
    }

    public List<String> childrenToSql(ToSqlOptions options) {
        ArrayList<String> result = new ArrayList<String>();
        for (Expr child : this.children_) {
            result.add(child.toSql(options));
        }
        return result;
    }

    public String debugString() {
        return (this.id_ != null ? "exprid=" + this.id_.toString() + " " : "") + Expr.debugString(this.children_);
    }

    public static String debugString(List<? extends Expr> exprs) {
        if (exprs == null || exprs.isEmpty()) {
            return "";
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (Expr expr : exprs) {
            strings.add(expr.debugString());
        }
        return Joiner.on((String)" ").join(strings);
    }

    public static String toSql(List<? extends Expr> exprs, ToSqlOptions options) {
        if (exprs == null || exprs.isEmpty()) {
            return "";
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (Expr expr : exprs) {
            strings.add(expr.toSql(options));
        }
        return Joiner.on((String)", ").join(strings);
    }

    public boolean matches(Expr that, SlotRef.Comparator slotRefCmp) {
        if (that == null) {
            return false;
        }
        if (this instanceof CastExpr && ((CastExpr)this).isImplicit()) {
            return ((Expr)this.children_.get(0)).matches(that, slotRefCmp);
        }
        if (that instanceof CastExpr && ((CastExpr)that).isImplicit()) {
            return this.matches((Expr)((CastExpr)that).children_.get(0), slotRefCmp);
        }
        if (this instanceof SlotRef && that instanceof SlotRef) {
            return slotRefCmp.matches((SlotRef)this, (SlotRef)that);
        }
        if (!this.localEquals(that)) {
            return false;
        }
        if (this.children_.size() != that.children_.size()) {
            return false;
        }
        for (int i = 0; i < this.children_.size(); ++i) {
            if (((Expr)this.children_.get(i)).matches((Expr)that.children_.get(i), slotRefCmp)) continue;
            return false;
        }
        return true;
    }

    protected boolean localEquals(Expr that) {
        return this.getClass() == that.getClass() && (this.fn_ == null ? that.fn_ == null : this.fn_.equals(that.fn_));
    }

    public final boolean equals(Object obj) {
        return obj instanceof Expr && this.matches((Expr)obj, SlotRef.SLOTREF_EQ_CMP);
    }

    protected int localHash() {
        return Objects.hash(this.getClass(), this.fn_);
    }

    public int hashCode() {
        return Objects.hash(this.localHash(), this.children_);
    }

    public static <C extends Expr> boolean equalLists(List<C> l1, List<C> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<C> l1Iter = l1.iterator();
        Iterator<C> l2Iter = l2.iterator();
        while (l1Iter.hasNext()) {
            if (((Expr)l1Iter.next()).equals(l2Iter.next())) continue;
            return false;
        }
        return true;
    }

    public static <C extends Expr> boolean equalSets(List<C> l1, List<C> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        return l1.containsAll(l2) && l2.containsAll(l1);
    }

    public static <C extends Expr> boolean isSubset(List<C> l1, List<C> l2) {
        if (l1.size() > l2.size()) {
            return false;
        }
        return l2.containsAll(l1);
    }

    public static <C extends Expr> List<C> intersect(List<C> l1, List<C> l2) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr element : l1) {
            if (!l2.contains(element)) continue;
            result.add(element);
        }
        return result;
    }

    public List<Expr> getConjuncts() {
        ArrayList<Expr> list = new ArrayList<Expr>();
        if (this instanceof CompoundPredicate && ((CompoundPredicate)this).getOp() == CompoundPredicate.Operator.AND) {
            list.addAll(((Expr)this.getChild(0)).getConjuncts());
            list.addAll(((Expr)this.getChild(1)).getConjuncts());
        } else {
            list.add(this);
        }
        return list;
    }

    public boolean isTriviallyTrue() {
        for (Expr conjunct : this.getConjuncts()) {
            if (IS_TRUE_LITERAL.apply((Object)conjunct)) continue;
            return false;
        }
        return true;
    }

    public Expr trySubstitute(ExprSubstitutionMap smap, Analyzer analyzer, boolean preserveRootType) throws AnalysisException {
        Expr result = this.clone();
        if (smap == null) {
            return result;
        }
        result = result.substituteImpl(smap, analyzer);
        result.analyze(analyzer);
        if (preserveRootType && !this.type_.equals(result.getType())) {
            if (this instanceof CastExpr) {
                CastExpr thisCastExpr = (CastExpr)this;
                TypeCompatibility compatibility = thisCastExpr.getCompatibility();
                return result.castTo(this.type_, compatibility);
            }
            return result.castTo(this.type_);
        }
        return result;
    }

    public Expr substitute(ExprSubstitutionMap smap, Analyzer analyzer, boolean preserveRootType) {
        try {
            return this.trySubstitute(smap, analyzer, preserveRootType);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed analysis after expr substitution.", e);
        }
    }

    public static List<Expr> trySubstituteList(Iterable<? extends Expr> exprs, ExprSubstitutionMap smap, Analyzer analyzer, boolean preserveRootTypes) throws AnalysisException {
        if (exprs == null) {
            return null;
        }
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr expr : exprs) {
            result.add(expr.trySubstitute(smap, analyzer, preserveRootTypes));
        }
        return result;
    }

    public static List<Expr> substituteList(Iterable<? extends Expr> exprs, ExprSubstitutionMap smap, Analyzer analyzer, boolean preserveRootTypes) {
        try {
            return Expr.trySubstituteList(exprs, smap, analyzer, preserveRootTypes);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed analysis after expr substitution.", e);
        }
    }

    protected Expr substituteImpl(ExprSubstitutionMap smap, Analyzer analyzer) {
        Expr substExpr;
        if (this.isImplicitCast()) {
            return ((Expr)this.getChild(0)).substituteImpl(smap, analyzer);
        }
        if (smap != null && (substExpr = smap.get(this)) != null) {
            return substExpr.clone();
        }
        this.substituteImplOnChildren(smap, analyzer);
        this.resetAnalysisState();
        return this;
    }

    protected final void substituteImplOnChildren(ExprSubstitutionMap smap, Analyzer analyzer) {
        for (int i = 0; i < this.children_.size(); ++i) {
            this.children_.set(i, ((Expr)this.children_.get(i)).substituteImpl(smap, analyzer));
        }
    }

    protected void analysisDone() {
        Preconditions.checkState((!this.isAnalyzed_ ? 1 : 0) != 0);
        this.isConstant_ = this.isConstantImpl();
        this.isAnalyzed_ = true;
    }

    protected void resetAnalysisState() {
        this.isAnalyzed_ = false;
    }

    public Expr reset() {
        if (this.isImplicitCast()) {
            return ((Expr)this.getChild(0)).reset();
        }
        for (int i = 0; i < this.children_.size(); ++i) {
            this.children_.set(i, ((Expr)this.children_.get(i)).reset());
        }
        this.resetAnalysisState();
        return this;
    }

    public static List<Expr> resetList(List<Expr> l) {
        for (int i = 0; i < l.size(); ++i) {
            l.set(i, l.get(i).reset());
        }
        return l;
    }

    public abstract Expr clone();

    public static <C extends Expr> List<C> cloneList(List<C> l) {
        Preconditions.checkNotNull(l);
        ArrayList<Expr> result = new ArrayList<Expr>(l.size());
        for (Expr element : l) {
            result.add(element.clone());
        }
        return result;
    }

    public static <C extends Expr> List<List<C>> deepCopy(List<List<C>> ls) {
        Preconditions.checkNotNull(ls);
        ArrayList<List<C>> result = new ArrayList<List<C>>(ls.size());
        for (List<C> l : ls) {
            if (l == null) {
                result.add(null);
                continue;
            }
            ArrayList<Expr> l2 = new ArrayList<Expr>(l.size());
            for (Expr element : l) {
                l2.add(element.clone());
            }
            result.add(l2);
        }
        return result;
    }

    public Expr cloneAndOverrideSelectivity(double selectivity) {
        Preconditions.checkArgument((selectivity >= 0.0 && selectivity <= 1.0 ? 1 : 0) != 0, (Object)selectivity);
        Expr e = this.clone();
        e.selectivity_ = selectivity;
        return e;
    }

    public static <C extends Expr> void removeDuplicates(List<C> l) {
        if (l == null) {
            return;
        }
        ArrayList origList = Lists.newArrayList(l);
        l.clear();
        for (Expr expr : origList) {
            if (l.contains(expr)) continue;
            l.add(expr);
        }
    }

    public static <C extends Expr> List<C> removeDuplicates(List<C> l, SlotRef.Comparator cmp) {
        ArrayList<Expr> newList = new ArrayList<Expr>();
        for (Expr expr : l) {
            boolean exists = false;
            for (Expr newExpr : newList) {
                if (!newExpr.matches(expr, cmp)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            newList.add(expr);
        }
        return newList;
    }

    public static <C extends Expr> void removeConstants(List<C> l) {
        if (l == null) {
            return;
        }
        ListIterator<C> it = l.listIterator();
        while (it.hasNext()) {
            Expr e = (Expr)it.next();
            if (!e.isConstant()) continue;
            it.remove();
        }
    }

    private static BitSet propagateConstants(List<Expr> conjuncts, BitSet candidates, List<Expr> keepConjuncts, Analyzer analyzer) {
        Preconditions.checkState((conjuncts.size() <= candidates.size() ? 1 : 0) != 0);
        ConstantPredicateHandler handler = new ConstantPredicateHandler();
        handler.classifyPredicates(conjuncts, candidates);
        BitSet changed = new BitSet(conjuncts.size());
        handler.propagateConstantPreds(conjuncts, changed, keepConjuncts, analyzer);
        return changed;
    }

    public static boolean optimizeConjuncts(List<Expr> conjuncts, Analyzer analyzer) {
        Preconditions.checkNotNull(conjuncts);
        ArrayList<Expr> tmpConjuncts = new ArrayList<Expr>();
        ArrayList<Expr> keepConjuncts = new ArrayList<Expr>();
        try {
            BitSet candidates = new BitSet(conjuncts.size());
            candidates.set(0, Math.min(conjuncts.size(), 200));
            int transfers = 0;
            tmpConjuncts.addAll(conjuncts);
            while (!candidates.isEmpty()) {
                BitSet changed = Expr.propagateConstants(tmpConjuncts, candidates, keepConjuncts, analyzer);
                candidates.clear();
                int pruned = 0;
                int i = changed.nextSetBit(0);
                while (i >= 0) {
                    int index = i - pruned;
                    Preconditions.checkState((index >= 0 ? 1 : 0) != 0);
                    ExprRewriter rewriter = analyzer.getExprRewriter();
                    Expr rewritten = rewriter.rewrite((Expr)tmpConjuncts.get(index), analyzer);
                    rewritten.reset();
                    rewritten.analyze(analyzer);
                    if (!rewritten.isConstant()) {
                        conjuncts.set(index, rewritten);
                        tmpConjuncts.set(index, rewritten);
                        if (++transfers < 200) {
                            candidates.set(index, true);
                        }
                    } else {
                        if (IS_NULL_LITERAL.apply((Object)rewritten) || IS_FALSE_LITERAL.apply((Object)rewritten)) {
                            conjuncts.clear();
                            conjuncts.add(rewritten);
                            return false;
                        }
                        if (IS_TRUE_LITERAL.apply((Object)rewritten)) {
                            ++pruned;
                            conjuncts.remove(index);
                            tmpConjuncts.remove(index);
                        }
                    }
                    i = changed.nextSetBit(i + 1);
                }
            }
        }
        catch (AnalysisException e) {
            LOG.warn("Not able to analyze after rewrite: " + e.toString() + " conjuncts: " + Expr.debugString(conjuncts));
        }
        conjuncts.addAll(keepConjuncts);
        Expr.removeDuplicates(conjuncts);
        return true;
    }

    public boolean isBound(TupleId tid) {
        return this.isBoundByTupleIds(Lists.newArrayList((Object[])new TupleId[]{tid}));
    }

    public boolean isBoundByTupleIds(List<TupleId> tids) {
        for (Expr child : this.children_) {
            if (child.isBoundByTupleIds(tids)) continue;
            return false;
        }
        return true;
    }

    public boolean isBoundBySlotIds(List<SlotId> slotIds) {
        for (Expr child : this.children_) {
            if (child.isBoundBySlotIds(slotIds)) continue;
            return false;
        }
        return true;
    }

    public static Expr getFirstBoundChild(Expr expr, List<TupleId> tids) {
        for (Expr child : expr.getChildren()) {
            if (!child.isBoundByTupleIds(tids)) continue;
            return child;
        }
        return null;
    }

    public void getIds(List<TupleId> tupleIds, List<SlotId> slotIds) {
        HashSet<TupleId> tupleIdSet = new HashSet<TupleId>();
        HashSet<SlotId> slotIdSet = new HashSet<SlotId>();
        this.getIdsHelper(tupleIdSet, slotIdSet);
        if (tupleIds != null) {
            tupleIds.addAll(tupleIdSet);
        }
        if (slotIds != null) {
            slotIds.addAll(slotIdSet);
        }
    }

    protected void getIdsHelper(Set<TupleId> tupleIds, Set<SlotId> slotIds) {
        for (Expr child : this.children_) {
            child.getIdsHelper(tupleIds, slotIds);
        }
    }

    public static <C extends Expr> void getIds(List<? extends Expr> exprs, List<TupleId> tupleIds, List<SlotId> slotIds) {
        if (exprs == null) {
            return;
        }
        for (Expr expr : exprs) {
            expr.getIds(tupleIds, slotIds);
        }
    }

    public boolean referencesTuple(TupleId tid) {
        for (Expr child : this.children_) {
            if (!child.referencesTuple(tid)) continue;
            return true;
        }
        return false;
    }

    public final boolean isConstant() {
        if (this.isAnalyzed_) {
            return this.isConstant_;
        }
        return this.isConstantImpl();
    }

    protected boolean isConstantImpl() {
        for (Expr expr : this.children_) {
            if (expr.isConstant()) continue;
            return false;
        }
        return true;
    }

    public static boolean allConstant(List<Expr> exprs) {
        for (Expr p : exprs) {
            if (p.isConstant()) continue;
            return false;
        }
        return true;
    }

    public boolean isScalarSubquery() {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        if (!(this instanceof Subquery)) {
            return false;
        }
        Subquery subq = (Subquery)this;
        SelectStmt stmt = (SelectStmt)subq.getStatement();
        return stmt.returnsAtMostOneRow() && this.getType().isScalarType();
    }

    public void checkReturnsBool(String name, boolean printExpr) throws AnalysisException {
        if (!this.type_.isBoolean() && !this.type_.isNull()) {
            throw new AnalysisException(String.format("%s%s requires return type 'BOOLEAN'. Actual type is '%s'.", name, printExpr ? " '" + this.toSql() + "'" : "", this.type_.toString()));
        }
    }

    public final Expr castTo(Type targetType, TypeCompatibility compatibility) throws AnalysisException {
        Type type = Type.getAssignmentCompatibleType(this.type_, targetType, compatibility);
        Preconditions.checkState((boolean)type.isValid(), (String)"cast %s to %s", (Object)this.type_, (Object)targetType);
        if (targetType.isNull()) {
            return this;
        }
        if (targetType.isDecimal()) {
            return this.uncheckedCastTo(targetType, compatibility);
        }
        if (type.matchesType(targetType)) {
            return this.uncheckedCastTo(type, compatibility);
        }
        throw new SqlCastException("targetType=" + targetType + " type=" + type);
    }

    public final Expr castTo(Type targetType) throws AnalysisException {
        return this.castTo(targetType, TypeCompatibility.DEFAULT);
    }

    protected Expr uncheckedCastTo(Type targetType, TypeCompatibility compatibility) throws AnalysisException {
        return new CastExpr(targetType, this, compatibility);
    }

    protected Expr uncheckedCastTo(Type targetType) throws AnalysisException {
        return this.uncheckedCastTo(targetType, TypeCompatibility.DEFAULT);
    }

    public void castChild(Type targetType, int childIndex) throws AnalysisException {
        Expr child = (Expr)this.getChild(childIndex);
        Expr newChild = child.castTo(targetType);
        this.setChild(childIndex, newChild);
    }

    protected void uncheckedCastChild(Type targetType, int childIndex) throws AnalysisException {
        Expr child = (Expr)this.getChild(childIndex);
        Expr newChild = child.uncheckedCastTo(targetType);
        this.setChild(childIndex, newChild);
    }

    public Expr ignoreImplicitCast() {
        return this;
    }

    public boolean isImplicitCast() {
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id_).add("type", (Object)this.type_).add("toSql", (Object)this.toSql(ToSqlOptions.SHOW_IMPLICIT_CASTS)).add("sel", this.selectivity_).add("evalCost", this.evalCost_).add("#distinct", this.numDistinctValues_).toString();
    }

    public SlotRef unwrapSlotRef(boolean implicitOnly) {
        Expr unwrappedExpr = this.unwrapExpr(implicitOnly);
        if (unwrappedExpr instanceof SlotRef) {
            return (SlotRef)unwrappedExpr;
        }
        return null;
    }

    public Expr unwrapExpr(boolean implicitOnly) {
        if (this instanceof CastExpr && (!implicitOnly || ((CastExpr)this).isImplicit()) || this instanceof FunctionCallExpr && ((FunctionCallExpr)this).isBuiltinCastFunction()) {
            return (Expr)this.children_.get(0);
        }
        return this;
    }

    public Expr findSrcExpr() {
        if (this.isConstant()) {
            return this;
        }
        SlotRef slotRef = this.unwrapSlotRef(false);
        if (slotRef == null) {
            return null;
        }
        SlotDescriptor slotDesc = slotRef.getDesc();
        if (slotDesc.isScanSlot()) {
            return slotRef;
        }
        if (slotDesc.getSourceExprs().size() == 1) {
            return slotDesc.getSourceExprs().get(0).findSrcExpr();
        }
        return null;
    }

    public SlotDescriptor findSrcScanSlot() {
        Expr sourceExpr = this.findSrcExpr();
        if (sourceExpr == null) {
            return null;
        }
        SlotRef slotRef = sourceExpr.unwrapSlotRef(false);
        if (slotRef == null) {
            return null;
        }
        return slotRef.getDesc();
    }

    public static Expr pushNegationToOperands(Expr root) {
        Preconditions.checkNotNull((Object)root);
        if (IS_NOT_PREDICATE.apply((Object)root)) {
            try {
                ((Expr)root.getChild(0)).getClass().getDeclaredMethod(NEGATE_FN, new Class[0]);
                return Expr.pushNegationToOperands(((Expr)root.getChild(0)).negate());
            }
            catch (NoSuchMethodException e) {
                return root;
            }
        }
        if (root instanceof CompoundPredicate) {
            Expr left = Expr.pushNegationToOperands((Expr)root.getChild(0));
            Expr right = Expr.pushNegationToOperands((Expr)root.getChild(1));
            CompoundPredicate compoundPredicate = new CompoundPredicate(((CompoundPredicate)root).getOp(), left, right);
            compoundPredicate.setPrintSqlInParens(root.getPrintSqlInParens());
            return compoundPredicate;
        }
        return root;
    }

    public Expr negate() {
        Preconditions.checkState((this.type_.getPrimitiveType() == PrimitiveType.BOOLEAN ? 1 : 0) != 0);
        return new CompoundPredicate(CompoundPredicate.Operator.NOT, this, null);
    }

    public Subquery getSubquery() {
        if (!this.contains(Subquery.class)) {
            return null;
        }
        ArrayList subqueries = new ArrayList();
        this.collect(Subquery.class, subqueries);
        Preconditions.checkState((subqueries.size() == 1 ? 1 : 0) != 0);
        return (Subquery)subqueries.get(0);
    }

    protected boolean hasChildCosts() {
        for (Expr child : this.children_) {
            if (child.hasCost()) continue;
            return false;
        }
        return true;
    }

    protected float getChildCosts() {
        float cost = 0.0f;
        for (Expr child : this.children_) {
            cost += child.getCost();
        }
        return cost;
    }

    protected static double getAvgStringLength(Expr e) {
        Preconditions.checkState((boolean)e.getType().isStringType());
        Preconditions.checkState((boolean)e.isAnalyzed_);
        SlotRef ref = e.unwrapSlotRef(false);
        if (ref != null) {
            if (ref.getDesc() != null && ref.getDesc().getStats().getAvgSize() > 0.0) {
                return ref.getDesc().getStats().getAvgSize();
            }
            return 5.0;
        }
        if (e instanceof StringLiteral) {
            return ((StringLiteral)e).utf8ArrayLength();
        }
        return 5.0;
    }

    public static String listToSql(List<Expr> exprs, final ToSqlOptions options) {
        Function<Expr, String> toSql = new Function<Expr, String>(){

            public String apply(Expr arg) {
                return arg.toSql(options);
            }
        };
        return Joiner.on((String)",").join(Iterables.transform(exprs, (Function)toSql));
    }

    public static String getExplainString(List<? extends Expr> exprs, TExplainLevel detailLevel) {
        if (exprs == null) {
            return "";
        }
        ToSqlOptions toSqlOptions = detailLevel.ordinal() >= TExplainLevel.EXTENDED.ordinal() ? ToSqlOptions.SHOW_IMPLICIT_CASTS : ToSqlOptions.DEFAULT;
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < exprs.size(); ++i) {
            if (i > 0) {
                output.append(", ");
            }
            output.append(exprs.get(i).toSql(toSqlOptions));
        }
        return output.toString();
    }

    public long evalToInteger(Analyzer analyzer, String name, boolean acceptDate) throws AnalysisException {
        if (this.contains(SlotRef.class) || this.contains(Subquery.class)) {
            throw new AnalysisException(name + " expression must be a constant expression: " + this.toSql());
        }
        this.analyze(analyzer);
        if (!this.isConstant()) {
            throw new AnalysisException(name + " expression must be a constant expression: " + this.toSql());
        }
        if (!(this.getType().isIntegerType() || acceptDate && this.getType().isDate())) {
            throw new AnalysisException(name + " expression must be an integer type but is '" + this.getType() + "': " + this.toSql());
        }
        TColumnValue val = null;
        try {
            val = FeSupport.EvalExprWithoutRow(this, analyzer.getQueryCtx());
        }
        catch (InternalException e) {
            throw new AnalysisException("Failed to evaluate expr: " + this.toSql(), e);
        }
        try {
            return Expr.evalToInteger(val, acceptDate);
        }
        catch (AnalysisException e) {
            throw new AnalysisException(name + " expression evaluates to NULL: " + this.toSql());
        }
    }

    public static long evalToInteger(TColumnValue val, boolean acceptDate) throws AnalysisException {
        long value;
        if (val.isSetLong_val()) {
            value = val.getLong_val();
        } else if (val.isSetInt_val()) {
            value = val.getInt_val();
        } else if (val.isSetShort_val()) {
            value = val.getShort_val();
        } else if (val.isSetByte_val()) {
            value = val.getByte_val();
        } else if (acceptDate && val.isSetDate_val()) {
            value = val.getDate_val();
        } else {
            throw new AnalysisException("TColumnValue evaluates to NULL: " + val);
        }
        return value;
    }

    public long evalToInteger(Analyzer analyzer, String name) throws AnalysisException {
        return this.evalToInteger(analyzer, name, false);
    }

    public long evalToNonNegativeInteger(Analyzer analyzer, String name) throws AnalysisException {
        long value = this.evalToInteger(analyzer, name);
        if (value < 0L) {
            throw new AnalysisException(name + " must be a non-negative integer: " + this.toSql() + " = " + value);
        }
        return value;
    }

    public void setPredicateHints(List<PlanHint> hints) {
        Preconditions.checkNotNull(hints);
        this.predicateHints_ = hints;
    }

    public List<PlanHint> getPredicateHints() {
        return this.predicateHints_;
    }

    protected Expr createNullLiteral() {
        return new NullLiteral();
    }

    public boolean resolveTableMask(Analyzer analyzer) throws AnalysisException {
        boolean hasChanges = false;
        for (Expr child : this.children_) {
            hasChanges |= child.resolveTableMask(analyzer);
        }
        return hasChanges;
    }

    public Expr getSlotDescFirstSourceExpr() {
        SlotRef slotRef = this.unwrapSlotRef(false);
        if (slotRef == null) {
            return null;
        }
        SlotDescriptor slotDesc = slotRef.getDesc();
        if (slotDesc.getSourceExprs().size() >= 1) {
            return slotDesc.getSourceExprs().get(0);
        }
        return null;
    }

    public Optional<Expr> getFirstNonConstSourceExpr() {
        SlotRef slotRef = this.unwrapSlotRef(false);
        if (slotRef == null) {
            Preconditions.checkState((boolean)this.isAnalyzed());
            return this.isConstant() ? Optional.empty() : Optional.of(this);
        }
        SlotDescriptor slotDesc = slotRef.getDesc();
        Preconditions.checkNotNull((Object)slotDesc);
        if (slotDesc.getSourceExprs().isEmpty()) {
            return Optional.of(this);
        }
        Optional<Expr> nonConstSourceExpr = Optional.empty();
        for (Expr expr : slotDesc.getSourceExprs()) {
            Preconditions.checkState((boolean)expr.isAnalyzed());
            if (expr.isConstant()) continue;
            nonConstSourceExpr = Optional.of(expr);
            break;
        }
        return nonConstSourceExpr;
    }

    public boolean shouldConvertToCNF() {
        return this.isConstant();
    }

    public boolean recordChildrenInWorkloadManagement() {
        return false;
    }
}

